/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.items.KeypressItem;
import com.yyon.grapplinghook.network.BaseMessageServer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class KeypressMessage
extends BaseMessageServer {
    KeypressItem.Keys key;
    boolean isDown;

    public KeypressMessage(PacketBuffer buf) {
        super(buf);
    }

    public KeypressMessage(KeypressItem.Keys thekey, boolean isDown) {
        this.key = thekey;
        this.isDown = isDown;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.key = KeypressItem.Keys.values()[buf.readInt()];
        this.isDown = buf.readBoolean();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.key.ordinal());
        buf.writeBoolean(this.isDown);
    }

    @Override
    public void processMessage(NetworkEvent.Context ctx) {
        ServerPlayerEntity player = ctx.getSender();
        if (player != null) {
            Item item;
            ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
            if (stack != null && (item = stack.func_77973_b()) instanceof KeypressItem) {
                if (this.isDown) {
                    ((KeypressItem)item).onCustomKeyDown(stack, (PlayerEntity)player, this.key, true);
                } else {
                    ((KeypressItem)item).onCustomKeyUp(stack, (PlayerEntity)player, this.key, true);
                }
                return;
            }
            stack = player.func_184586_b(Hand.OFF_HAND);
            if (stack != null && (item = stack.func_77973_b()) instanceof KeypressItem) {
                if (this.isDown) {
                    ((KeypressItem)item).onCustomKeyDown(stack, (PlayerEntity)player, this.key, false);
                } else {
                    ((KeypressItem)item).onCustomKeyUp(stack, (PlayerEntity)player, this.key, false);
                }
                return;
            }
        }
    }
}

