/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.network.BaseMessageServer;
import com.yyon.grapplinghook.server.ServerControllerManager;
import java.util.HashSet;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class GrappleEndMessage
extends BaseMessageServer {
    public int entityId;
    public HashSet<Integer> hookEntityIds;

    public GrappleEndMessage(PacketBuffer buf) {
        super(buf);
    }

    public GrappleEndMessage(int entityId, HashSet<Integer> hookEntityIds) {
        this.entityId = entityId;
        this.hookEntityIds = hookEntityIds;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.entityId = buf.readInt();
        int size = buf.readInt();
        this.hookEntityIds = new HashSet();
        for (int i = 0; i < size; ++i) {
            this.hookEntityIds.add(buf.readInt());
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.hookEntityIds.size());
        for (int id : this.hookEntityIds) {
            buf.writeInt(id);
        }
    }

    @Override
    public void processMessage(NetworkEvent.Context ctx) {
        int id = this.entityId;
        ServerPlayerEntity player = ctx.getSender();
        if (player == null) {
            return;
        }
        World w = player.field_70170_p;
        ServerControllerManager.receiveGrappleEnd(id, w, this.hookEntityIds);
    }
}

