/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.entities.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.entities.grapplehook.SegmentHandler;
import com.yyon.grapplinghook.network.BaseMessageClient;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import com.yyon.grapplinghook.utils.Vec;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class GrappleAttachMessage
extends BaseMessageClient {
    public int id;
    public double x;
    public double y;
    public double z;
    public int controlId;
    public int entityId;
    public BlockPos blockPos;
    public LinkedList<Vec> segments;
    public LinkedList<Direction> segmentTopSides;
    public LinkedList<Direction> segmentBottomSides;
    public GrappleCustomization custom;

    public GrappleAttachMessage(PacketBuffer buf) {
        super(buf);
    }

    public GrappleAttachMessage(int id, double x, double y, double z, int controlid, int entityid, BlockPos blockpos, LinkedList<Vec> segments, LinkedList<Direction> segmenttopsides, LinkedList<Direction> segmentbottomsides, GrappleCustomization custom) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.controlId = controlid;
        this.entityId = entityid;
        this.blockPos = blockpos;
        this.segments = segments;
        this.segmentTopSides = segmenttopsides;
        this.segmentBottomSides = segmentbottomsides;
        this.custom = custom;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.id = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.controlId = buf.readInt();
        this.entityId = buf.readInt();
        int blockx = buf.readInt();
        int blocky = buf.readInt();
        int blockz = buf.readInt();
        this.blockPos = new BlockPos(blockx, blocky, blockz);
        this.custom = new GrappleCustomization();
        this.custom.readFromBuf((ByteBuf)buf);
        int size = buf.readInt();
        this.segments = new LinkedList();
        this.segmentBottomSides = new LinkedList();
        this.segmentTopSides = new LinkedList();
        this.segments.add(new Vec(0.0, 0.0, 0.0));
        this.segmentBottomSides.add(null);
        this.segmentTopSides.add(null);
        for (int i = 1; i < size - 1; ++i) {
            this.segments.add(new Vec(buf.readDouble(), buf.readDouble(), buf.readDouble()));
            this.segmentBottomSides.add((Direction)buf.func_179257_a(Direction.class));
            this.segmentTopSides.add((Direction)buf.func_179257_a(Direction.class));
        }
        this.segments.add(new Vec(0.0, 0.0, 0.0));
        this.segmentBottomSides.add(null);
        this.segmentTopSides.add(null);
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.id);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.controlId);
        buf.writeInt(this.entityId);
        buf.writeInt(this.blockPos.func_177958_n());
        buf.writeInt(this.blockPos.func_177956_o());
        buf.writeInt(this.blockPos.func_177952_p());
        this.custom.writeToBuf((ByteBuf)buf);
        buf.writeInt(this.segments.size());
        for (int i = 1; i < this.segments.size() - 1; ++i) {
            buf.writeDouble(this.segments.get((int)i).x);
            buf.writeDouble(this.segments.get((int)i).y);
            buf.writeDouble(this.segments.get((int)i).z);
            buf.func_179249_a((Enum)this.segmentBottomSides.get(i));
            buf.func_179249_a((Enum)this.segmentTopSides.get(i));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void processMessage(NetworkEvent.Context ctx) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        Entity grapple = world.func_73045_a(this.id);
        if (grapple instanceof GrapplehookEntity) {
            ((GrapplehookEntity)grapple).clientAttach(this.x, this.y, this.z);
            SegmentHandler segmenthandler = ((GrapplehookEntity)grapple).segmentHandler;
            segmenthandler.segments = this.segments;
            segmenthandler.segmentBottomSides = this.segmentBottomSides;
            segmenthandler.segmentTopSides = this.segmentTopSides;
            Entity player = world.func_73045_a(this.entityId);
            segmenthandler.forceSetPos(new Vec(this.x, this.y, this.z), Vec.positionVec(player));
        }
        ClientProxyInterface.proxy.createControl(this.controlId, this.id, this.entityId, (World)world, new Vec(this.x, this.y, this.z), this.blockPos, this.custom);
    }
}

