/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.grapplemod;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class BaseMessageClient {
    public BaseMessageClient(PacketBuffer buf) {
        this.decode(buf);
    }

    public BaseMessageClient() {
    }

    public abstract void decode(PacketBuffer var1);

    public abstract void encode(PacketBuffer var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void processMessage(NetworkEvent.Context var1);

    public void onMessageReceived(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        if (sideReceived != LogicalSide.CLIENT) {
            grapplemod.LOGGER.warn("message received on wrong side:" + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        ctx.enqueueWork(() -> ClientProxyInterface.proxy.onMessageReceivedClient(this, ctx));
    }
}

