/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.items;

import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.client.ClientSetup;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.entities.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.items.KeypressItem;
import com.yyon.grapplinghook.network.DetachSingleHookMessage;
import com.yyon.grapplinghook.network.GrappleDetachMessage;
import com.yyon.grapplinghook.network.KeypressMessage;
import com.yyon.grapplinghook.server.ServerControllerManager;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import com.yyon.grapplinghook.utils.GrapplemodUtils;
import com.yyon.grapplinghook.utils.Vec;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GrapplehookItem
extends Item
implements KeypressItem {
    public static HashMap<Entity, GrapplehookEntity> grapplehookEntitiesLeft = new HashMap();
    public static HashMap<Entity, GrapplehookEntity> grapplehookEntitiesRight = new HashMap();

    public GrapplehookItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(CommonSetup.tabGrapplemod).func_200918_c(GrappleConfig.getConf().grapplinghook.other.default_durability));
    }

    public boolean hasHookEntity(Entity entity) {
        GrapplehookEntity hookLeft = this.getHookEntityLeft(entity);
        GrapplehookEntity hookRight = this.getHookEntityRight(entity);
        return hookLeft != null || hookRight != null;
    }

    public void setHookEntityLeft(Entity entity, GrapplehookEntity hookEntity) {
        grapplehookEntitiesLeft.put(entity, hookEntity);
    }

    public void setHookEntityRight(Entity entity, GrapplehookEntity hookEntity) {
        grapplehookEntitiesRight.put(entity, hookEntity);
    }

    public GrapplehookEntity getHookEntityLeft(Entity entity) {
        GrapplehookEntity hookEntity;
        if (grapplehookEntitiesLeft.containsKey(entity) && (hookEntity = grapplehookEntitiesLeft.get(entity)) != null && hookEntity.func_70089_S()) {
            return hookEntity;
        }
        return null;
    }

    public GrapplehookEntity getHookEntityRight(Entity entity) {
        GrapplehookEntity hookEntity;
        if (grapplehookEntitiesRight.containsKey(entity) && (hookEntity = grapplehookEntitiesRight.get(entity)) != null && hookEntity.func_70089_S()) {
            return hookEntity;
        }
        return null;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repair) {
        if (repair != null && repair.func_77973_b().equals(Items.field_151116_aA)) {
            return true;
        }
        return super.func_82789_a(stack, repair);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        return true;
    }

    public boolean func_195938_a(BlockState p_195938_1_, World p_195938_2_, BlockPos p_195938_3_, PlayerEntity p_195938_4_) {
        return false;
    }

    @Override
    public void onCustomKeyDown(ItemStack stack, PlayerEntity player, KeypressItem.Keys key, boolean ismainhand) {
        if (player.field_70170_p.field_72995_K) {
            if (key == KeypressItem.Keys.LAUNCHER) {
                if (this.getCustomization((ItemStack)stack).enderstaff) {
                    ClientProxyInterface.proxy.launchPlayer(player);
                }
            } else if (key == KeypressItem.Keys.THROWLEFT || key == KeypressItem.Keys.THROWRIGHT || key == KeypressItem.Keys.THROWBOTH) {
                CommonSetup.network.sendToServer((Object)new KeypressMessage(key, true));
            } else if (key == KeypressItem.Keys.ROCKET) {
                GrappleCustomization custom = this.getCustomization(stack);
                if (custom.rocket) {
                    ClientProxyInterface.proxy.startRocket(player, custom);
                }
            }
        } else {
            GrappleCustomization custom = this.getCustomization(stack);
            if (key == KeypressItem.Keys.THROWBOTH || !custom.doublehook && (key == KeypressItem.Keys.THROWLEFT || key == KeypressItem.Keys.THROWRIGHT)) {
                this.throwBoth(stack, player.field_70170_p, (LivingEntity)player, ismainhand);
            } else if (key == KeypressItem.Keys.THROWLEFT) {
                GrapplehookEntity hookLeft = this.getHookEntityLeft((Entity)player);
                if (hookLeft != null) {
                    this.detachLeft((LivingEntity)player);
                    return;
                }
                stack.func_222118_a(1, (LivingEntity)((ServerPlayerEntity)player), p -> {});
                if (stack.func_190916_E() <= 0) {
                    return;
                }
                boolean threw = this.throwLeft(stack, player.field_70170_p, (LivingEntity)player, ismainhand);
                if (threw) {
                    player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_213303_ch().field_72450_a, player.func_213303_ch().field_72448_b, player.func_213303_ch().field_72449_c, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (Item.field_77697_d.nextFloat() * 0.4f + 1.2f) + 1.0f);
                }
            } else if (key == KeypressItem.Keys.THROWRIGHT) {
                GrapplehookEntity hookRight = this.getHookEntityRight((Entity)player);
                if (hookRight != null) {
                    this.detachRight((LivingEntity)player);
                    return;
                }
                stack.func_222118_a(1, (LivingEntity)((ServerPlayerEntity)player), p -> {});
                if (stack.func_190916_E() <= 0) {
                    return;
                }
                this.throwRight(stack, player.field_70170_p, (LivingEntity)player, ismainhand);
                player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_213303_ch().field_72450_a, player.func_213303_ch().field_72448_b, player.func_213303_ch().field_72449_c, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (Item.field_77697_d.nextFloat() * 0.4f + 1.2f) + 1.0f);
            }
        }
    }

    @Override
    public void onCustomKeyUp(ItemStack stack, PlayerEntity player, KeypressItem.Keys key, boolean ismainhand) {
        if (player.field_70170_p.field_72995_K) {
            if (key == KeypressItem.Keys.THROWLEFT || key == KeypressItem.Keys.THROWRIGHT || key == KeypressItem.Keys.THROWBOTH) {
                CommonSetup.network.sendToServer((Object)new KeypressMessage(key, false));
            }
        } else {
            GrappleCustomization custom = this.getCustomization(stack);
            if (custom.detachonkeyrelease) {
                GrapplehookEntity hookLeft = this.getHookEntityLeft((Entity)player);
                GrapplehookEntity hookRight = this.getHookEntityRight((Entity)player);
                if (key == KeypressItem.Keys.THROWBOTH) {
                    this.detachBoth((LivingEntity)player);
                } else if (key == KeypressItem.Keys.THROWLEFT) {
                    if (hookLeft != null) {
                        this.detachLeft((LivingEntity)player);
                    }
                } else if (key == KeypressItem.Keys.THROWRIGHT && hookRight != null) {
                    this.detachRight((LivingEntity)player);
                }
            }
        }
    }

    public void throwBoth(ItemStack stack, World worldIn, LivingEntity entityLiving, boolean righthand) {
        GrapplehookEntity hookLeft = this.getHookEntityLeft((Entity)entityLiving);
        GrapplehookEntity hookRight = this.getHookEntityRight((Entity)entityLiving);
        if (hookLeft != null || hookRight != null) {
            this.detachBoth(entityLiving);
            return;
        }
        stack.func_222118_a(1, (LivingEntity)((ServerPlayerEntity)entityLiving), p -> {});
        if (stack.func_190916_E() <= 0) {
            return;
        }
        GrappleCustomization custom = this.getCustomization(stack);
        double angle = custom.angle;
        if (entityLiving.func_213453_ef()) {
            angle = custom.sneakingangle;
        }
        if (custom.doublehook && angle != 0.0) {
            this.throwLeft(stack, worldIn, entityLiving, righthand);
        }
        this.throwRight(stack, worldIn, entityLiving, righthand);
        entityLiving.field_70170_p.func_184148_a((PlayerEntity)null, entityLiving.func_213303_ch().field_72450_a, entityLiving.func_213303_ch().field_72448_b, entityLiving.func_213303_ch().field_72449_c, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (Item.field_77697_d.nextFloat() * 0.4f + 1.2f) + 1.0f);
    }

    public boolean throwLeft(ItemStack stack, World worldIn, LivingEntity entityLiving, boolean righthand) {
        GrappleCustomization custom = this.getCustomization(stack);
        double angle = custom.angle;
        double verticalangle = custom.verticalthrowangle;
        if (entityLiving.func_213453_ef()) {
            angle = custom.sneakingangle;
            verticalangle = custom.sneakingverticalthrowangle;
        }
        LivingEntity player = entityLiving;
        Vec anglevec = Vec.fromAngles(Math.toRadians(-angle), Math.toRadians(verticalangle));
        anglevec = anglevec.rotatePitch(Math.toRadians(-player.func_195050_f(1.0f)));
        anglevec = anglevec.rotateYaw(Math.toRadians(player.func_195046_g(1.0f)));
        float velx = -MathHelper.func_76126_a((float)((float)anglevec.getYaw() * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
        float vely = -MathHelper.func_76126_a((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
        float velz = MathHelper.func_76134_b((float)((float)anglevec.getYaw() * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
        GrapplehookEntity hookEntity = this.createGrapplehookEntity(stack, worldIn, entityLiving, false, true);
        float extravelocity = (float)Vec.motionVec((Entity)entityLiving).distAlong(new Vec(velx, vely, velz));
        if (extravelocity < 0.0f) {
            extravelocity = 0.0f;
        }
        hookEntity.func_70186_c(velx, vely, velz, hookEntity.getVelocity() + extravelocity, 0.0f);
        worldIn.func_217376_c((Entity)hookEntity);
        this.setHookEntityLeft((Entity)entityLiving, hookEntity);
        return true;
    }

    public void throwRight(ItemStack stack, World worldIn, LivingEntity entityLiving, boolean righthand) {
        GrappleCustomization custom = this.getCustomization(stack);
        double angle = custom.angle;
        double verticalangle = custom.verticalthrowangle;
        if (entityLiving.func_213453_ef()) {
            angle = custom.sneakingangle;
            verticalangle = custom.sneakingverticalthrowangle;
        }
        if (!custom.doublehook || angle == 0.0) {
            GrapplehookEntity hookEntity = this.createGrapplehookEntity(stack, worldIn, entityLiving, righthand, false);
            Vec anglevec = new Vec(0.0, 0.0, 1.0).rotatePitch(Math.toRadians(verticalangle));
            anglevec = anglevec.rotatePitch(Math.toRadians(-entityLiving.func_195050_f(1.0f)));
            anglevec = anglevec.rotateYaw(Math.toRadians(entityLiving.func_195046_g(1.0f)));
            float velx = -MathHelper.func_76126_a((float)((float)anglevec.getYaw() * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
            float vely = -MathHelper.func_76126_a((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
            float velz = MathHelper.func_76134_b((float)((float)anglevec.getYaw() * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
            float extravelocity = (float)Vec.motionVec((Entity)entityLiving).distAlong(new Vec(velx, vely, velz));
            if (extravelocity < 0.0f) {
                extravelocity = 0.0f;
            }
            hookEntity.func_70186_c(velx, vely, velz, hookEntity.getVelocity() + extravelocity, 0.0f);
            this.setHookEntityRight((Entity)entityLiving, hookEntity);
            worldIn.func_217376_c((Entity)hookEntity);
        } else {
            LivingEntity player = entityLiving;
            Vec anglevec = Vec.fromAngles(Math.toRadians(angle), Math.toRadians(verticalangle));
            anglevec = anglevec.rotatePitch(Math.toRadians(-player.func_195050_f(1.0f)));
            anglevec = anglevec.rotateYaw(Math.toRadians(player.func_195046_g(1.0f)));
            float velx = -MathHelper.func_76126_a((float)((float)anglevec.getYaw() * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
            float vely = -MathHelper.func_76126_a((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
            float velz = MathHelper.func_76134_b((float)((float)anglevec.getYaw() * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
            GrapplehookEntity hookEntity = this.createGrapplehookEntity(stack, worldIn, entityLiving, true, true);
            float extravelocity = (float)Vec.motionVec((Entity)entityLiving).distAlong(new Vec(velx, vely, velz));
            if (extravelocity < 0.0f) {
                extravelocity = 0.0f;
            }
            hookEntity.func_70186_c(velx, vely, velz, hookEntity.getVelocity() + extravelocity, 0.0f);
            worldIn.func_217376_c((Entity)hookEntity);
            this.setHookEntityRight((Entity)entityLiving, hookEntity);
        }
    }

    public void detachBoth(LivingEntity entityLiving) {
        GrapplehookEntity hookLeft = this.getHookEntityLeft((Entity)entityLiving);
        GrapplehookEntity hookRight = this.getHookEntityRight((Entity)entityLiving);
        this.setHookEntityLeft((Entity)entityLiving, null);
        this.setHookEntityRight((Entity)entityLiving, null);
        if (hookLeft != null) {
            hookLeft.removeServer();
        }
        if (hookRight != null) {
            hookRight.removeServer();
        }
        int id = entityLiving.func_145782_y();
        GrapplemodUtils.sendToCorrectClient(new GrappleDetachMessage(id), entityLiving.func_145782_y(), entityLiving.field_70170_p);
        if (ServerControllerManager.attached.contains(id)) {
            ServerControllerManager.attached.remove(id);
        }
    }

    public void detachLeft(LivingEntity entityLiving) {
        GrapplehookEntity hookLeft = this.getHookEntityLeft((Entity)entityLiving);
        this.setHookEntityLeft((Entity)entityLiving, null);
        if (hookLeft != null) {
            hookLeft.removeServer();
        }
        int id = entityLiving.func_145782_y();
        if (this.getHookEntityRight((Entity)entityLiving) == null) {
            GrapplemodUtils.sendToCorrectClient(new GrappleDetachMessage(id), id, entityLiving.field_70170_p);
        } else {
            GrapplemodUtils.sendToCorrectClient(new DetachSingleHookMessage(id, hookLeft.func_145782_y()), id, entityLiving.field_70170_p);
        }
        if (ServerControllerManager.attached.contains(id)) {
            ServerControllerManager.attached.remove(id);
        }
    }

    public void detachRight(LivingEntity entityLiving) {
        GrapplehookEntity hookRight = this.getHookEntityRight((Entity)entityLiving);
        this.setHookEntityRight((Entity)entityLiving, null);
        if (hookRight != null) {
            hookRight.removeServer();
        }
        int id = entityLiving.func_145782_y();
        if (this.getHookEntityLeft((Entity)entityLiving) == null) {
            GrapplemodUtils.sendToCorrectClient(new GrappleDetachMessage(id), id, entityLiving.field_70170_p);
        } else {
            GrapplemodUtils.sendToCorrectClient(new DetachSingleHookMessage(id, hookRight.func_145782_y()), id, entityLiving.field_70170_p);
        }
        if (ServerControllerManager.attached.contains(id)) {
            ServerControllerManager.attached.remove(id);
        }
    }

    public double getAngle(LivingEntity entity, ItemStack stack) {
        GrappleCustomization custom = this.getCustomization(stack);
        if (entity.func_213453_ef()) {
            return custom.sneakingangle;
        }
        return custom.angle;
    }

    public GrapplehookEntity createGrapplehookEntity(ItemStack stack, World worldIn, LivingEntity entityLiving, boolean righthand, boolean isdouble) {
        GrapplehookEntity hookEntity = new GrapplehookEntity(worldIn, entityLiving, righthand, this.getCustomization(stack), isdouble);
        ServerControllerManager.addGrapplehookEntity(entityLiving.func_145782_y(), hookEntity);
        return hookEntity;
    }

    public GrappleCustomization getCustomization(ItemStack itemstack) {
        CompoundNBT tag = itemstack.func_196082_o();
        if (tag.func_74764_b("custom")) {
            GrappleCustomization custom = new GrappleCustomization();
            custom.loadNBT(tag.func_74775_l("custom"));
            return custom;
        }
        GrappleCustomization custom = this.getDefaultCustomization();
        CompoundNBT nbt = custom.writeNBT();
        tag.func_218657_a("custom", (INBT)nbt);
        itemstack.func_77982_d(tag);
        return custom;
    }

    public GrappleCustomization getDefaultCustomization() {
        return new GrappleCustomization();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag par4) {
        GrappleCustomization custom = this.getCustomization(stack);
        if (Screen.func_231173_s_()) {
            if (!custom.detachonkeyrelease) {
                list.add((ITextComponent)new StringTextComponent(ClientSetup.key_boththrow.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.throw.desc")));
                list.add((ITextComponent)new StringTextComponent(ClientSetup.key_boththrow.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.release.desc")));
                list.add((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grappletooltip.double.desc") + ClientSetup.key_boththrow.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.releaseandthrow.desc")));
            } else {
                list.add((ITextComponent)new StringTextComponent(ClientSetup.key_boththrow.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.throwhold.desc")));
            }
            list.add((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.getKeyname(ClientProxyInterface.McKeys.keyBindForward) + ", " + ClientProxyInterface.proxy.getKeyname(ClientProxyInterface.McKeys.keyBindLeft) + ", " + ClientProxyInterface.proxy.getKeyname(ClientProxyInterface.McKeys.keyBindBack) + ", " + ClientProxyInterface.proxy.getKeyname(ClientProxyInterface.McKeys.keyBindRight) + " " + ClientProxyInterface.proxy.localize("grappletooltip.swing.desc")));
            list.add((ITextComponent)new StringTextComponent(ClientSetup.key_jumpanddetach.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.jump.desc")));
            list.add((ITextComponent)new StringTextComponent(ClientSetup.key_slow.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.slow.desc")));
            list.add((ITextComponent)new StringTextComponent(ClientSetup.key_climb.func_238171_j_().getString() + " + " + ClientProxyInterface.proxy.getKeyname(ClientProxyInterface.McKeys.keyBindForward) + " / " + ClientSetup.key_climbup.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.climbup.desc")));
            list.add((ITextComponent)new StringTextComponent(ClientSetup.key_climb.func_238171_j_().getString() + " + " + ClientProxyInterface.proxy.getKeyname(ClientProxyInterface.McKeys.keyBindBack) + " / " + ClientSetup.key_climbdown.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.climbdown.desc")));
            if (custom.enderstaff) {
                list.add((ITextComponent)new StringTextComponent(ClientSetup.key_enderlaunch.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.enderlaunch.desc")));
            }
            if (custom.rocket) {
                list.add((ITextComponent)new StringTextComponent(ClientSetup.key_rocket.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.rocket.desc")));
            }
            if (custom.motor) {
                if (custom.motorwhencrouching && !custom.motorwhennotcrouching) {
                    list.add((ITextComponent)new StringTextComponent(ClientSetup.key_motoronoff.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.motoron.desc")));
                } else if (!custom.motorwhencrouching && custom.motorwhennotcrouching) {
                    list.add((ITextComponent)new StringTextComponent(ClientSetup.key_motoronoff.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.motoroff.desc")));
                }
            }
            if (custom.doublehook) {
                if (!custom.detachonkeyrelease) {
                    list.add((ITextComponent)new StringTextComponent(ClientSetup.key_leftthrow.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.throwleft.desc")));
                    list.add((ITextComponent)new StringTextComponent(ClientSetup.key_rightthrow.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.throwright.desc")));
                } else {
                    list.add((ITextComponent)new StringTextComponent(ClientSetup.key_leftthrow.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.throwlefthold.desc")));
                    list.add((ITextComponent)new StringTextComponent(ClientSetup.key_rightthrow.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.throwrighthold.desc")));
                }
            } else {
                list.add((ITextComponent)new StringTextComponent(ClientSetup.key_rightthrow.func_238171_j_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.throwalt.desc")));
            }
            if (custom.reelin) {
                list.add((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.getKeyname(ClientProxyInterface.McKeys.keyBindSneak) + " " + ClientProxyInterface.proxy.localize("grappletooltip.reelin.desc")));
            }
        } else if (Screen.func_231172_r_()) {
            for (String option : GrappleCustomization.booleanoptions) {
                if (!custom.isOptionValid(option) || custom.getBoolean(option) == GrappleCustomization.DEFAULT.getBoolean(option)) continue;
                list.add((ITextComponent)new StringTextComponent((custom.getBoolean(option) ? "" : ClientProxyInterface.proxy.localize("grappletooltip.negate.desc") + " ") + ClientProxyInterface.proxy.localize(custom.getName(option))));
            }
            for (String option : GrappleCustomization.doubleoptions) {
                if (!custom.isOptionValid(option) || custom.getDouble(option) == GrappleCustomization.DEFAULT.getDouble(option)) continue;
                list.add((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize(custom.getName(option)) + ": " + Math.floor(custom.getDouble(option) * 100.0) / 100.0));
            }
        } else {
            if (custom.doublehook) {
                list.add((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize(custom.getName("doublehook"))));
            }
            if (custom.motor) {
                if (custom.smartmotor) {
                    list.add((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize(custom.getName("smartmotor"))));
                } else {
                    list.add((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize(custom.getName("motor"))));
                }
            }
            if (custom.enderstaff) {
                list.add((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize(custom.getName("enderstaff"))));
            }
            if (custom.rocket) {
                list.add((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize(custom.getName("rocket"))));
            }
            if (custom.attract) {
                list.add((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize(custom.getName("attract"))));
            }
            if (custom.repel) {
                list.add((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize(custom.getName("repel"))));
            }
            list.add((ITextComponent)new StringTextComponent(""));
            list.add((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grappletooltip.shiftcontrols.desc")));
            list.add((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grappletooltip.controlconfiguration.desc")));
        }
    }

    public void setCustomOnServer(ItemStack helditemstack, GrappleCustomization custom, PlayerEntity player) {
        CompoundNBT tag = helditemstack.func_196082_o();
        CompoundNBT nbt = custom.writeNBT();
        tag.func_218657_a("custom", (INBT)nbt);
        helditemstack.func_77982_d(tag);
    }

    public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        int id = player.func_145782_y();
        GrapplemodUtils.sendToCorrectClient(new GrappleDetachMessage(id), id, player.field_70170_p);
        if (!player.field_70170_p.field_72995_K && ServerControllerManager.attached.contains(id)) {
            ServerControllerManager.attached.remove(id);
        }
        if (grapplehookEntitiesLeft.containsKey(player)) {
            GrapplehookEntity hookLeft = grapplehookEntitiesLeft.get(player);
            this.setHookEntityLeft((Entity)player, null);
            if (hookLeft != null) {
                hookLeft.removeServer();
            }
        }
        if (grapplehookEntitiesRight.containsKey(player)) {
            GrapplehookEntity hookRight = grapplehookEntitiesRight.get(player);
            this.setHookEntityLeft((Entity)player, null);
            if (hookRight != null) {
                hookRight.removeServer();
            }
        }
        return super.onDroppedByPlayer(item, player);
    }

    public boolean getPropertyRocket(ItemStack stack, World world, LivingEntity entity) {
        return this.getCustomization((ItemStack)stack).rocket;
    }

    public boolean getPropertyDouble(ItemStack stack, World world, LivingEntity entity) {
        return this.getCustomization((ItemStack)stack).doublehook;
    }

    public boolean getPropertyMotor(ItemStack stack, World world, LivingEntity entity) {
        return this.getCustomization((ItemStack)stack).motor;
    }

    public boolean getPropertySmart(ItemStack stack, World world, LivingEntity entity) {
        return this.getCustomization((ItemStack)stack).smartmotor;
    }

    public boolean getPropertyEnderstaff(ItemStack stack, World world, LivingEntity entity) {
        return this.getCustomization((ItemStack)stack).enderstaff;
    }

    public boolean getPropertyMagnet(ItemStack stack, World world, LivingEntity entity) {
        return this.getCustomization((ItemStack)stack).attract || this.getCustomization((ItemStack)stack).repel;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            items.add((Object)stack);
            if (ClientProxyInterface.proxy != null) {
                ClientProxyInterface.proxy.fillGrappleVariants(tab, items);
            }
        }
    }

    public boolean getPropertyHook(ItemStack stack, World world, LivingEntity entity) {
        CompoundNBT tag = stack.func_196082_o();
        return tag.func_74764_b("hook");
    }
}

