/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.integrations;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import java.util.Arrays;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JeiIntegrations
implements IModPlugin {
    ResourceLocation modifierRecipesLoc = new ResourceLocation("grapplemod", "modifierrecipes");

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("grapplemod", "jeiintegration");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        super.registerItemSubtypes(registration);
        registration.registerSubtypeInterpreter((Item)CommonSetup.grapplingHookItem, (IIngredientSubtypeInterpreter)new IIngredientSubtypeInterpreter<ItemStack>(){

            public String optionalString(boolean value, String desc) {
                return value ? "+" : "!";
            }

            public String apply(ItemStack ingredient, UidContext context) {
                GrappleCustomization custom = CommonSetup.grapplingHookItem.getCustomization(ingredient);
                return "" + this.optionalString(custom.motor, "motor") + this.optionalString(custom.rocket, "rocket") + this.optionalString(custom.doublehook, "double") + this.optionalString(custom.smartmotor, "smart") + this.optionalString(custom.enderstaff, "enderstaff") + this.optionalString(custom.attract, "attract") + this.optionalString(custom.repel, "repel") + "";
            }
        });
    }

    public void registerCategories(final IRecipeCategoryRegistration registration) {
        super.registerCategories(registration);
        registration.addRecipeCategories(new IRecipeCategory[]{new IRecipeCategory<ModifierRecipes>(){

            public ResourceLocation getUid() {
                return JeiIntegrations.this.modifierRecipesLoc;
            }

            public Class<? extends ModifierRecipes> getRecipeClass() {
                return ModifierRecipes.class;
            }

            public String getTitle() {
                return ClientProxyInterface.proxy.localize("block.grapplemod.block_grapple_modifier");
            }

            public IDrawable getBackground() {
                return registration.getJeiHelpers().getGuiHelper().createDrawable(new ResourceLocation("grapplemod", "textures/gui/jei_modifier_bg.png"), 0, 0, 120, 60);
            }

            public IDrawable getIcon() {
                return registration.getJeiHelpers().getGuiHelper().createDrawableIngredient((Object)new ItemStack((IItemProvider)CommonSetup.grappleModifierBlockItem));
            }

            public void setIngredients(ModifierRecipes recipe, IIngredients ingredients) {
                if (recipe.input2 == null) {
                    ingredients.setInput(VanillaTypes.ITEM, (Object)recipe.input1);
                } else {
                    ingredients.setInputs(VanillaTypes.ITEM, Arrays.asList(recipe.input1, recipe.input2));
                }
                ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.output);
            }

            public void setRecipe(IRecipeLayout recipeLayout, ModifierRecipes recipe, IIngredients ingredients) {
                IGuiItemStackGroup items = recipeLayout.getItemStacks();
                items.init(0, true, 12, 9);
                items.init(1, true, 34, 9);
                items.init(2, false, 85, 9);
                items.set(ingredients);
            }

            public void draw(ModifierRecipes recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
                super.draw((Object)recipe, matrixStack, mouseX, mouseY);
                if (recipe.input2 != null) {
                    String text = ClientProxyInterface.proxy.localize("grapplemod.jei_modifier_text");
                    int linenum = 0;
                    for (String line : text.split("\n")) {
                        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, line, 3.0f, (float)(29 + 11 * linenum), 0);
                        ++linenum;
                    }
                }
            }
        }});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        super.registerRecipeCatalysts(registration);
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CommonSetup.grappleModifierBlockItem), new ResourceLocation[]{this.modifierRecipesLoc});
    }

    ItemStack grappleWithCustom(String option) {
        GrappleCustomization custom = new GrappleCustomization();
        custom.setBoolean(option, true);
        ItemStack stack = new ItemStack((IItemProvider)CommonSetup.grapplingHookItem);
        CommonSetup.grapplingHookItem.setCustomOnServer(stack, custom, null);
        return stack;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        super.registerRecipes(registration);
        ItemStack ff_diamond_boots = new ItemStack((IItemProvider)Items.field_151175_af);
        ff_diamond_boots.func_77966_a(Enchantments.field_180309_e, 4);
        registration.addRecipes(Arrays.asList(new ModifierRecipes(new ItemStack((IItemProvider)CommonSetup.motorUpgradeItem), new ItemStack((IItemProvider)CommonSetup.grapplingHookItem), this.grappleWithCustom("motor")), new ModifierRecipes(new ItemStack((IItemProvider)CommonSetup.doubleUpgradeItem), new ItemStack((IItemProvider)CommonSetup.grapplingHookItem), this.grappleWithCustom("doublehook")), new ModifierRecipes(new ItemStack((IItemProvider)CommonSetup.staffUpgradeItem), new ItemStack((IItemProvider)CommonSetup.grapplingHookItem), this.grappleWithCustom("enderstaff")), new ModifierRecipes(new ItemStack((IItemProvider)CommonSetup.forcefieldUpgradeItem), new ItemStack((IItemProvider)CommonSetup.grapplingHookItem), this.grappleWithCustom("repel")), new ModifierRecipes(new ItemStack((IItemProvider)CommonSetup.magnetUpgradeItem), new ItemStack((IItemProvider)CommonSetup.grapplingHookItem), this.grappleWithCustom("attract")), new ModifierRecipes(new ItemStack((IItemProvider)CommonSetup.rocketUpgradeItem), new ItemStack((IItemProvider)CommonSetup.grapplingHookItem), this.grappleWithCustom("rocket"))), this.modifierRecipesLoc);
        if (GrappleConfig.getConf().longfallboots.longfallbootsrecipe) {
            registration.addRecipes(Arrays.asList(new ModifierRecipes(ff_diamond_boots, new ItemStack((IItemProvider)CommonSetup.longFallBootsItem))), this.modifierRecipesLoc);
        }
    }

    class ModifierRecipes {
        ItemStack input1;
        ItemStack input2;
        ItemStack output;

        public ModifierRecipes(ItemStack input1, ItemStack output) {
            this.input1 = input1;
            this.input2 = null;
            this.output = output;
        }

        public ModifierRecipes(ItemStack input1, ItemStack input2, ItemStack output) {
            this.input1 = input1;
            this.input2 = input2;
            this.output = output;
        }
    }
}

