/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.entities.grapplehook;

import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.entities.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.network.SegmentMessage;
import com.yyon.grapplinghook.utils.GrapplemodUtils;
import com.yyon.grapplinghook.utils.Vec;
import java.util.LinkedList;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class SegmentHandler {
    public LinkedList<Vec> segments = new LinkedList();
    public LinkedList<Direction> segmentBottomSides;
    public LinkedList<Direction> segmentTopSides;
    public World world;
    public GrapplehookEntity hookEntity;
    Vec prevHookPos = null;
    Vec prevPlayerPos = null;
    final double bendOffset = 0.05;
    final double intoBlock = 0.05;
    double ropeLen;

    public SegmentHandler(World w, GrapplehookEntity hookEntity, Vec hookpos, Vec playerpos) {
        this.segments.add(hookpos);
        this.segments.add(playerpos);
        this.segmentBottomSides = new LinkedList();
        this.segmentBottomSides.add(null);
        this.segmentBottomSides.add(null);
        this.segmentTopSides = new LinkedList();
        this.segmentTopSides.add(null);
        this.segmentTopSides.add(null);
        this.world = w;
        this.hookEntity = hookEntity;
        this.prevHookPos = new Vec(hookpos);
        this.prevPlayerPos = new Vec(playerpos);
    }

    public void forceSetPos(Vec hookpos, Vec playerpos) {
        this.prevHookPos = new Vec(hookpos);
        this.prevPlayerPos = new Vec(playerpos);
        this.segments.set(0, new Vec(hookpos));
        this.segments.set(this.segments.size() - 1, new Vec(playerpos));
    }

    public void updatePos(Vec hookpos, Vec playerpos, double ropelen) {
        this.segments.set(0, hookpos);
        this.segments.set(this.segments.size() - 1, playerpos);
        this.ropeLen = ropelen;
    }

    public void update(Vec hookpos, Vec playerpos, double ropelen, boolean movinghook) {
        if (this.prevHookPos == null) {
            this.prevHookPos = hookpos;
            this.prevPlayerPos = playerpos;
        }
        this.segments.set(0, hookpos);
        this.segments.set(this.segments.size() - 1, playerpos);
        this.ropeLen = ropelen;
        Vec closest = this.segments.get(this.segments.size() - 2);
        while (this.segments.size() != 2) {
            int index = this.segments.size() - 2;
            closest = this.segments.get(index);
            Direction bottomside = this.segmentBottomSides.get(index);
            Direction topside = this.segmentTopSides.get(index);
            Vec ropevec = playerpos.sub(closest);
            Vec beforepoint = this.segments.get(index - 1);
            Vec edgevec = this.getNormal(bottomside).cross(this.getNormal(topside));
            Vec planenormal = beforepoint.sub(closest).cross(edgevec);
            if (!(ropevec.dot(planenormal) > 0.0)) break;
            this.removeSegment(index);
        }
        Vec farthest = this.segments.get(1);
        if (movinghook) {
            while (this.segments.size() != 2) {
                int index = 1;
                farthest = this.segments.get(index);
                Direction bottomside = this.segmentBottomSides.get(index);
                Direction topside = this.segmentTopSides.get(index);
                Vec ropevec = farthest.sub(hookpos);
                Vec beforepoint = this.segments.get(index + 1);
                Vec edgevec = this.getNormal(bottomside).cross(this.getNormal(topside));
                Vec planenormal = beforepoint.sub(farthest).cross(edgevec);
                if (!(ropevec.dot(planenormal) > 0.0) && !(ropevec.length() < 0.1)) break;
                this.removeSegment(index);
            }
            while (this.getDistToFarthest() > ropelen) {
                this.removeSegment(1);
            }
        }
        if (movinghook) {
            Vec prevfarthest = farthest = this.segments.get(1);
            if (this.segments.size() == 2) {
                prevfarthest = this.prevPlayerPos;
            }
            this.updateSegment(hookpos, this.prevHookPos, farthest, prevfarthest, 1, 0);
        }
        Vec prevclosest = closest;
        if (this.segments.size() == 2) {
            prevclosest = this.prevHookPos;
        }
        this.updateSegment(closest, prevclosest, playerpos, this.prevPlayerPos, this.segments.size() - 1, 0);
        this.prevHookPos = hookpos;
        this.prevPlayerPos = playerpos;
    }

    public void removeSegment(int index) {
        this.segments.remove(index);
        this.segmentBottomSides.remove(index);
        this.segmentTopSides.remove(index);
        if (!this.world.field_72995_K) {
            SegmentMessage addmessage = new SegmentMessage(this.hookEntity.func_145782_y(), false, index, new Vec(0.0, 0.0, 0.0), Direction.DOWN, Direction.DOWN);
            Vec playerpoint = Vec.positionVec(this.hookEntity.shootingEntity);
            CommonSetup.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.world.func_175726_f(new BlockPos(playerpoint.x, playerpoint.y, playerpoint.z))), (Object)addmessage);
        }
    }

    public void updateSegment(Vec top, Vec prevtop, Vec bottom, Vec prevbottom, int index, int numberrecursions) {
        BlockRayTraceResult bottomraytraceresult = GrapplemodUtils.rayTraceBlocks(this.world, bottom, top);
        if (bottomraytraceresult != null) {
            if (GrapplemodUtils.rayTraceBlocks(this.world, prevbottom, prevtop) != null) {
                return;
            }
            Vec bottomhitvec = new Vec(bottomraytraceresult.func_216347_e());
            Direction bottomside = bottomraytraceresult.func_216354_b();
            Vec bottomnormal = this.getNormal(bottomside);
            double prevropelen = prevtop.sub(prevbottom).length();
            Vec cornerbound1 = bottomhitvec.add(bottomnormal.changeLen(-0.05));
            Vec bound_option1 = this.linePlaneIntersection(prevtop, prevbottom, cornerbound1, bottomnormal);
            Vec bound_option2 = this.linePlaneIntersection(top, prevtop, cornerbound1, bottomnormal);
            Vec bound_option3 = this.linePlaneIntersection(prevbottom, bottom, cornerbound1, bottomnormal);
            for (Vec cornerbound2 : new Vec[]{bound_option1, bound_option2, bound_option3}) {
                BlockRayTraceResult cornerraytraceresult;
                if (cornerbound2 == null || (cornerraytraceresult = GrapplemodUtils.rayTraceBlocks(this.world, cornerbound2, cornerbound1)) == null) continue;
                Vec cornerhitpos = new Vec(cornerraytraceresult.func_216347_e());
                Direction cornerside = cornerraytraceresult.func_216354_b();
                if (cornerside == bottomside || cornerside.func_176734_d() == bottomside) continue;
                Vec actualcorner = cornerhitpos.add(bottomnormal.changeLen(0.05));
                Vec bend = actualcorner.add(bottomnormal.changeLen(0.05)).add(this.getNormal(cornerside).changeLen(0.05));
                Vec topropevec = bend.sub(top);
                Vec bottomropevec = bend.sub(bottom);
                if (topropevec.length() < 0.05 && this.segmentBottomSides.get(index - 1) == bottomside && this.segmentTopSides.get(index - 1) == cornerside || bottomropevec.length() < 0.05 && this.segmentBottomSides.get(index) == bottomside && this.segmentTopSides.get(index) == cornerside) continue;
                this.actuallyAddSegment(index, bend, bottomside, cornerside);
                if (this.getDistToAnchor() + 0.2 > this.ropeLen) {
                    this.removeSegment(index);
                    continue;
                }
                double newropelen = topropevec.length() + bottomropevec.length();
                double prevtoptobend = topropevec.length() * prevropelen / newropelen;
                Vec prevbend = prevtop.add(prevbottom.sub(prevtop).changeLen(prevtoptobend));
                if (numberrecursions < 10) {
                    this.updateSegment(top, prevtop, bend, prevbend, index, numberrecursions + 1);
                    break;
                }
                System.out.println("Warning: number recursions exceeded");
                break;
            }
        }
    }

    public Vec linePlaneIntersection(Vec linepoint1, Vec linepoint2, Vec planepoint, Vec planenormal) {
        Vec linevec = linepoint2.sub(linepoint1);
        if (linevec.dot(planenormal) == 0.0) {
            return null;
        }
        double d = planepoint.sub(linepoint1).dot(planenormal) / linevec.dot(planenormal);
        return linepoint1.add(linevec.mult(d));
    }

    public Vec getNormal(Direction facing) {
        Vector3i facingvec = facing.func_176730_m();
        return new Vec(facingvec.func_177958_n(), facingvec.func_177956_o(), facingvec.func_177952_p());
    }

    public boolean hookPastBend(double ropelen) {
        return this.getDistToFarthest() > ropelen;
    }

    public BlockPos getBendBlock(int index) {
        Vec bendpos = this.segments.get(index);
        Vec vec = this.getNormal(this.segmentBottomSides.get(index));
        this.getClass();
        bendpos.add_ip(vec.changeLen(-0.05 * 2.0));
        Vec vec2 = this.getNormal(this.segmentTopSides.get(index));
        this.getClass();
        bendpos.add_ip(vec2.changeLen(-0.05 * 2.0));
        return new BlockPos(bendpos.x, bendpos.y, bendpos.z);
    }

    public void actuallyAddSegment(int index, Vec bendpoint, Direction bottomside, Direction topside) {
        this.segments.add(index, bendpoint);
        this.segmentBottomSides.add(index, bottomside);
        this.segmentTopSides.add(index, topside);
        if (!this.world.field_72995_K) {
            SegmentMessage addmessage = new SegmentMessage(this.hookEntity.func_145782_y(), true, index, bendpoint, topside, bottomside);
            Vec playerpoint = Vec.positionVec(this.hookEntity.shootingEntity);
            CommonSetup.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.world.func_175726_f(new BlockPos(playerpoint.x, playerpoint.y, playerpoint.z))), (Object)addmessage);
        }
    }

    public void print() {
        for (int i = 1; i < this.segments.size() - 1; ++i) {
            System.out.print(i);
            System.out.print(" ");
            System.out.print(this.segmentTopSides.get(i).toString());
            System.out.print(" ");
            System.out.print(this.segmentBottomSides.get(i).toString());
            System.out.print(" ");
            this.segments.get(i).print();
        }
    }

    public Vec getClosest(Vec hookpos) {
        this.segments.set(0, hookpos);
        return this.segments.get(this.segments.size() - 2);
    }

    public double getDistToAnchor() {
        double dist = 0.0;
        for (int i = 0; i < this.segments.size() - 2; ++i) {
            dist += this.segments.get(i).sub(this.segments.get(i + 1)).length();
        }
        return dist;
    }

    public Vec getFarthest() {
        return this.segments.get(1);
    }

    public double getDistToFarthest() {
        double dist = 0.0;
        for (int i = 1; i < this.segments.size() - 1; ++i) {
            dist += this.segments.get(i).sub(this.segments.get(i + 1)).length();
        }
        return dist;
    }

    public double getDist(Vec hookpos, Vec playerpos) {
        this.segments.set(0, hookpos);
        this.segments.set(this.segments.size() - 1, playerpos);
        double dist = 0.0;
        for (int i = 0; i < this.segments.size() - 1; ++i) {
            dist += this.segments.get(i).sub(this.segments.get(i + 1)).length();
        }
        return dist;
    }

    public AxisAlignedBB getBoundingBox(Vec hookpos, Vec playerpos) {
        this.updatePos(hookpos, playerpos, this.ropeLen);
        Vec minvec = new Vec(hookpos);
        Vec maxvec = new Vec(hookpos);
        for (int i = 1; i < this.segments.size(); ++i) {
            Vec segpos = this.segments.get(i);
            if (segpos.x < minvec.x) {
                minvec.x = segpos.x;
            } else if (segpos.x > maxvec.x) {
                maxvec.x = segpos.x;
            }
            if (segpos.y < minvec.y) {
                minvec.y = segpos.y;
            } else if (segpos.y > maxvec.y) {
                maxvec.y = segpos.y;
            }
            if (segpos.z < minvec.z) {
                minvec.z = segpos.z;
                continue;
            }
            if (!(segpos.z > maxvec.z)) continue;
            maxvec.z = segpos.z;
        }
        AxisAlignedBB bb = new AxisAlignedBB(minvec.x, minvec.y, minvec.z, maxvec.x, maxvec.y, maxvec.z);
        return bb;
    }
}

