/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.entities.grapplehook;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.yyon.grapplinghook.entities.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.entities.grapplehook.SegmentHandler;
import com.yyon.grapplinghook.utils.Vec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderGrapplehookEntity<T extends GrapplehookEntity>
extends EntityRenderer<T> {
    protected final Item item;
    private static final ResourceLocation HOOK_TEXTURES = new ResourceLocation("grapplemod", "textures/entity/hook.png");
    private static final RenderType HOOK_RENDER = RenderType.func_230167_a_((ResourceLocation)HOOK_TEXTURES, (boolean)false);
    private static final ResourceLocation ROPE_TEXTURES = new ResourceLocation("grapplemod", "textures/entity/rope.png");
    private static final RenderType ROPE_RENDER = RenderType.func_228634_a_((ResourceLocation)ROPE_TEXTURES);
    ItemRenderer context;

    public RenderGrapplehookEntity(EntityRendererManager renderManagerIn, Item itemIn) {
        super(renderManagerIn);
        this.item = itemIn;
        this.context = Minecraft.func_71410_x().func_175599_af();
    }

    public void render(T hookEntity, float p_225623_2_, float partialTicks, MatrixStack matrix, IRenderTypeBuffer rendertype, int p_225623_6_) {
        Vec hand_offset;
        if (hookEntity == null || !hookEntity.func_70089_S()) {
            return;
        }
        SegmentHandler segmenthandler = ((GrapplehookEntity)((Object)hookEntity)).segmentHandler;
        LivingEntity e = (LivingEntity)((GrapplehookEntity)((Object)hookEntity)).shootingEntity;
        if (e == null || !e.func_70089_S()) {
            return;
        }
        LivingEntity playerentity = e;
        int hand_right = (playerentity.func_184591_cq() == HandSide.RIGHT ? 1 : -1) * (((GrapplehookEntity)((Object)hookEntity)).rightHand ? 1 : -1);
        float f = playerentity.func_70678_g(partialTicks);
        float f1 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f) * (float)Math.PI));
        if ((this.field_76990_c.field_78733_k == null || this.field_76990_c.field_78733_k.func_243230_g().func_243192_a()) && playerentity == Minecraft.func_71410_x().field_71439_g) {
            double d7 = this.field_76990_c.field_78733_k.field_74334_X;
            hand_offset = new Vec((double)hand_right * -0.46 * (d7 /= 100.0), -0.18 * d7, 0.38);
            hand_offset = hand_offset.rotatePitch(-f1 * 0.7f);
            hand_offset = hand_offset.rotateYaw(-f1 * 0.5f);
            hand_offset = hand_offset.rotatePitch(-Vec.lerp(partialTicks, playerentity.field_70127_C, playerentity.field_70125_A) * 0.01745329238474369);
            hand_offset = hand_offset.rotateYaw(Vec.lerp(partialTicks, playerentity.field_70126_B, playerentity.field_70177_z) * 0.01745329238474369);
        } else {
            hand_offset = new Vec((double)hand_right * -0.36, -0.65 + (double)(playerentity.func_213453_ef() ? -0.1875f : 0.0f), 0.6);
            hand_offset = hand_offset.rotatePitch(f1 * 0.7f);
            hand_offset = hand_offset.rotateYaw(Vec.lerp(partialTicks, playerentity.field_70760_ar, playerentity.field_70761_aq) * 0.01745329238474369);
        }
        hand_offset.y += (double)playerentity.func_70047_e();
        Vec hand_position = hand_offset.add(Vec.partialPositionVec((Entity)playerentity, partialTicks));
        Vec attach_dir = Vec.motionVec(hookEntity).mult(-1.0);
        if (attach_dir.length() == 0.0) {
            if (((GrapplehookEntity)((Object)hookEntity)).attach_dir != null) {
                attach_dir = ((GrapplehookEntity)((Object)hookEntity)).attach_dir;
            } else if (segmenthandler == null || segmenthandler.segments.size() <= 2) {
                attach_dir = this.getRelativeToEntity((GrapplehookEntity)((Object)hookEntity), new Vec(hand_position), partialTicks);
            } else {
                Vec from = segmenthandler.segments.get(1);
                Vec to = Vec.partialPositionVec(hookEntity, partialTicks);
                attach_dir = from.sub(to);
            }
        }
        attach_dir.normalize_ip();
        if (((GrapplehookEntity)((Object)hookEntity)).attached && ((GrapplehookEntity)((Object)hookEntity)).attach_dir != null) {
            attach_dir = ((GrapplehookEntity)((Object)hookEntity)).attach_dir;
        }
        ((GrapplehookEntity)((Object)hookEntity)).attach_dir = attach_dir;
        matrix.func_227860_a_();
        matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
        matrix.func_227863_a_(new Quaternion(new Vec(0.0, 1.0, 0.0).toVector3f(), (float)(-attach_dir.getYaw()), true));
        matrix.func_227863_a_(new Quaternion(new Vec(1.0, 0.0, 0.0).toVector3f(), (float)(attach_dir.getPitch() - 90.0), true));
        matrix.func_227863_a_(new Quaternion(new Vec(0.0, 1.0, 0.0).toVector3f(), (float)(45 * hand_right), true));
        matrix.func_227863_a_(new Quaternion(new Vec(0.0, 0.0, 1.0).toVector3f(), -45.0f, true));
        ItemStack stack = this.getStackToRender(hookEntity);
        IBakedModel bakedmodel = this.context.func_184393_a(stack, ((GrapplehookEntity)((Object)hookEntity)).field_70170_p, (LivingEntity)null);
        this.context.func_229111_a_(stack, ItemCameraTransforms.TransformType.NONE, false, matrix, rendertype, p_225623_6_, OverlayTexture.field_229196_a_, bakedmodel);
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        MatrixStack.Entry matrixstack$entry = matrix.func_227866_c_();
        Matrix4f matrix4f1 = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f1 = matrixstack$entry.func_227872_b_();
        IVertexBuilder vertexbuffer = rendertype.getBuffer(ROPE_RENDER);
        if (segmenthandler == null) {
            this.drawSegment(new Vec(0.0, 0.0, 0.0), this.getRelativeToEntity((GrapplehookEntity)((Object)hookEntity), new Vec(hand_position), partialTicks), 1.0, vertexbuffer, matrix4f1, matrix3f1, p_225623_6_);
        } else {
            for (int i = 0; i < segmenthandler.segments.size() - 1; ++i) {
                Vec from = segmenthandler.segments.get(i);
                Vec to = segmenthandler.segments.get(i + 1);
                if (i == 0) {
                    from = Vec.partialPositionVec(hookEntity, partialTicks);
                }
                if (i + 2 == segmenthandler.segments.size()) {
                    to = hand_position;
                }
                from = this.getRelativeToEntity((GrapplehookEntity)((Object)hookEntity), from, partialTicks);
                to = this.getRelativeToEntity((GrapplehookEntity)((Object)hookEntity), to, partialTicks);
                double taut = 1.0;
                if (i == segmenthandler.segments.size() - 2) {
                    // empty if block
                }
                this.drawSegment(from, to, taut, vertexbuffer, matrix4f1, matrix3f1, p_225623_6_);
            }
        }
        Vec hook_pos = Vec.partialPositionVec(hookEntity, partialTicks);
        Vec hand_closest = segmenthandler == null || segmenthandler.segments.size() <= 2 ? hook_pos : segmenthandler.segments.get(segmenthandler.segments.size() - 2);
        Vec diff = hand_closest.sub(hand_position);
        Vec forward = diff.changeLen(1.0);
        Vec up = forward.cross(new Vec(1.0, 0.0, 0.0));
        if (up.length() == 0.0) {
            up = forward.cross(new Vec(0.0, 0.0, 1.0));
        }
        up.changeLen_ip(0.025);
        Vec side = forward.cross(up);
        side.changeLen_ip(0.025);
        Vec[] corners = new Vec[]{up.mult(-1.0).add(side.mult(-1.0)), up.mult(-1.0).add(side), up.add(side), up.add(side.mult(-1.0))};
        float[][] uvs = new float[][]{{0.0f, 0.99f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.99f}};
        for (int size = 0; size < 4; ++size) {
            Vec corner = corners[size];
            Vec normal = corner.normalize();
            Vec cornerpos = this.getRelativeToEntity((GrapplehookEntity)((Object)hookEntity), hand_position, partialTicks).add(corner);
            vertexbuffer.func_227888_a_(matrix4f1, (float)cornerpos.x, (float)cornerpos.y, (float)cornerpos.z).func_225586_a_(255, 255, 255, 255).func_225583_a_(uvs[size][0], uvs[size][1]).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(p_225623_6_).func_227887_a_(matrix3f1, (float)normal.x, (float)normal.y, (float)normal.z).func_181675_d();
        }
        matrix.func_227865_b_();
        super.func_225623_a_(hookEntity, p_225623_2_, partialTicks, matrix, rendertype, p_225623_6_);
    }

    Vec getRelativeToEntity(GrapplehookEntity hookEntity, Vec inVec, float partialTicks) {
        return inVec.sub(Vec.partialPositionVec((Entity)hookEntity, partialTicks));
    }

    private static void vertex(IVertexBuilder p_229106_0_, Matrix4f p_229106_1_, Matrix3f p_229106_2_, int p_229106_3_, float p_229106_4_, int p_229106_5_, int p_229106_6_, int p_229106_7_) {
        p_229106_0_.func_227888_a_(p_229106_1_, p_229106_4_ - 0.5f, (float)p_229106_5_ - 0.5f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_((float)p_229106_6_, (float)p_229106_7_).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(p_229106_3_).func_227887_a_(p_229106_2_, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public void drawSegment(Vec start, Vec finish, double taut, IVertexBuilder vertexbuffer, Matrix4f matrix, Matrix3f matrix3, int p_225623_6_) {
        Vec diff;
        Vec forward;
        Vec up;
        if (start.sub(finish).length() < 0.05) {
            return;
        }
        int number_squares = 16;
        if (taut == 1.0) {
            number_squares = 1;
        }
        if ((up = (forward = (diff = finish.sub(start)).changeLen(1.0)).cross(new Vec(1.0, 0.0, 0.0))).length() == 0.0) {
            up = forward.cross(new Vec(0.0, 0.0, 1.0));
        }
        up.changeLen_ip(0.025);
        Vec side = forward.cross(up);
        side.changeLen_ip(0.025);
        Vec[] corners = new Vec[]{up.mult(-1.0).add(side.mult(-1.0)), up.add(side.mult(-1.0)), up.add(side), up.mult(-1.0).add(side)};
        for (int size = 0; size < 4; ++size) {
            Vec corner1 = corners[size];
            Vec corner2 = corners[(size + 1) % 4];
            Vec normal1 = corner1.normalize();
            Vec normal2 = corner2.normalize();
            for (int square_num = 0; square_num < number_squares; ++square_num) {
                float squarefrac1 = (float)square_num / (float)number_squares;
                Vec pos1 = start.add(diff.mult(squarefrac1));
                pos1.y += -(1.0 - taut) * (0.25 - Math.pow((double)squarefrac1 - 0.5, 2.0)) * 1.5;
                float squarefrac2 = ((float)square_num + 1.0f) / (float)number_squares;
                Vec pos2 = start.add(diff.mult(squarefrac2));
                pos2.y += -(1.0 - taut) * (0.25 - Math.pow((double)squarefrac2 - 0.5, 2.0)) * 1.5;
                Vec corner1pos1 = pos1.add(corner1);
                Vec corner2pos1 = pos1.add(corner2);
                Vec corner1pos2 = pos2.add(corner1);
                Vec corner2pos2 = pos2.add(corner2);
                vertexbuffer.func_227888_a_(matrix, (float)corner1pos1.x, (float)corner1pos1.y, (float)corner1pos1.z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, squarefrac1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(p_225623_6_).func_227887_a_(matrix3, (float)normal1.x, (float)normal1.y, (float)normal1.z).func_181675_d();
                vertexbuffer.func_227888_a_(matrix, (float)corner2pos1.x, (float)corner2pos1.y, (float)corner2pos1.z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, squarefrac1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(p_225623_6_).func_227887_a_(matrix3, (float)normal2.x, (float)normal2.y, (float)normal2.z).func_181675_d();
                vertexbuffer.func_227888_a_(matrix, (float)corner2pos2.x, (float)corner2pos2.y, (float)corner2pos2.z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, squarefrac2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(p_225623_6_).func_227887_a_(matrix3, (float)normal2.x, (float)normal2.y, (float)normal2.z).func_181675_d();
                vertexbuffer.func_227888_a_(matrix, (float)corner1pos2.x, (float)corner1pos2.y, (float)corner1pos2.z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, squarefrac2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(p_225623_6_).func_227887_a_(matrix3, (float)normal1.x, (float)normal1.y, (float)normal1.z).func_181675_d();
            }
        }
    }

    public boolean shouldRender(T p_225626_1_, ClippingHelper p_225626_2_, double p_225626_3_, double p_225626_5_, double p_225626_7_) {
        return true;
    }

    public ItemStack getStackToRender(T entityIn) {
        ItemStack stack = new ItemStack((IItemProvider)this.item);
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74757_a("hook", true);
        stack.func_77982_d(tag);
        return stack;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return HOOK_TEXTURES;
    }
}

