/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.entities.grapplehook;

import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.config.GrappleConfigUtils;
import com.yyon.grapplinghook.entities.grapplehook.SegmentHandler;
import com.yyon.grapplinghook.network.GrappleAttachMessage;
import com.yyon.grapplinghook.network.GrappleAttachPosMessage;
import com.yyon.grapplinghook.server.ServerControllerManager;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import com.yyon.grapplinghook.utils.GrapplemodUtils;
import com.yyon.grapplinghook.utils.Vec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class GrapplehookEntity
extends ProjectileItemEntity
implements IEntityAdditionalSpawnData {
    public Entity shootingEntity = null;
    public int shootingEntityID;
    private boolean firstAttach = false;
    public Vec thisPos;
    public boolean rightHand = true;
    public boolean attached = false;
    public double pull;
    public double taut = 1.0;
    public boolean ignoreFrustumCheck = true;
    public boolean isDouble = false;
    public double r;
    public SegmentHandler segmentHandler = null;
    public GrappleCustomization customization = null;
    public Vec prevPos = null;
    public boolean foundBlock = false;
    public boolean wasInAir = false;
    public BlockPos magnetBlock = null;
    public Vec attach_dir = null;

    public GrapplehookEntity(EntityType<? extends GrapplehookEntity> type, World world) {
        super(type, world);
        this.segmentHandler = new SegmentHandler(this.field_70170_p, this, Vec.positionVec((Entity)this), Vec.positionVec((Entity)this));
        this.customization = new GrappleCustomization();
    }

    public GrapplehookEntity(World world, LivingEntity shooter, boolean righthand, GrappleCustomization customization, boolean isdouble) {
        super(CommonSetup.grapplehookEntityType, shooter.func_213303_ch().field_72450_a, shooter.func_213303_ch().field_72448_b + (double)shooter.func_70047_e(), shooter.func_213303_ch().field_72449_c, world);
        this.shootingEntity = shooter;
        this.shootingEntityID = this.shootingEntity.func_145782_y();
        this.isDouble = isdouble;
        Vec pos = Vec.positionVec(this.shootingEntity).add(new Vec(0.0, this.shootingEntity.func_70047_e(), 0.0));
        this.segmentHandler = new SegmentHandler(this.field_70170_p, this, new Vec(pos), new Vec(pos));
        this.customization = customization;
        this.r = customization.maxlen;
        this.rightHand = righthand;
    }

    public void writeSpawnData(PacketBuffer data) {
        data.writeInt(this.shootingEntity != null ? this.shootingEntity.func_145782_y() : 0);
        data.writeBoolean(this.rightHand);
        data.writeBoolean(this.isDouble);
        if (this.customization == null) {
            System.out.println("error: customization null");
        }
        this.customization.writeToBuf((ByteBuf)data);
    }

    public void readSpawnData(PacketBuffer data) {
        this.shootingEntityID = data.readInt();
        this.shootingEntity = this.field_70170_p.func_73045_a(this.shootingEntityID);
        this.rightHand = data.readBoolean();
        this.isDouble = data.readBoolean();
        this.customization = new GrappleCustomization();
        this.customization.readFromBuf((ByteBuf)data);
    }

    public void func_70088_a() {
        super.func_70088_a();
    }

    public void removeServer() {
        this.func_70106_y();
        this.shootingEntityID = 0;
    }

    public float getVelocity() {
        return (float)this.customization.throwspeed;
    }

    public void func_70071_h_() {
        if (this.shootingEntityID == 0 || this.shootingEntity == null) {
            this.func_70106_y();
            return;
        }
        if (this.firstAttach) {
            this.func_213293_j(0.0, 0.0, 0.0);
            this.firstAttach = false;
            super.func_70107_b(this.thisPos.x, this.thisPos.y, this.thisPos.z);
        }
        if (this.attached) {
            this.func_213293_j(0.0, 0.0, 0.0);
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.shootingEntity != null && !this.attached) {
            double newdist;
            Vec farthest;
            if (this.segmentHandler.hookPastBend(this.r)) {
                System.out.println("around bend");
                farthest = this.segmentHandler.getFarthest();
                this.serverAttach(this.segmentHandler.getBendBlock(1), farthest, null);
            }
            if (!this.customization.phaserope) {
                this.segmentHandler.update(Vec.positionVec((Entity)this), Vec.positionVec(this.shootingEntity).add(new Vec(0.0, this.shootingEntity.func_70047_e(), 0.0)), this.r, true);
                if (this.customization.sticky && this.segmentHandler.segments.size() > 2) {
                    int bendnumber = this.segmentHandler.segments.size() - 2;
                    Vec closest = this.segmentHandler.segments.get(bendnumber);
                    BlockPos blockpos = this.segmentHandler.getBendBlock(bendnumber);
                    for (int i = 1; i <= bendnumber; ++i) {
                        this.segmentHandler.removeSegment(1);
                    }
                    this.serverAttach(blockpos, closest, null);
                }
            } else {
                this.segmentHandler.updatePos(Vec.positionVec((Entity)this), Vec.positionVec(this.shootingEntity).add(new Vec(0.0, this.shootingEntity.func_70047_e(), 0.0)), this.r);
            }
            farthest = this.segmentHandler.getFarthest();
            double distToFarthest = this.segmentHandler.getDistToFarthest();
            Vec ropevec = Vec.positionVec((Entity)this).sub(farthest);
            double d = ropevec.length();
            if (this.customization.reelin && this.shootingEntity.func_213453_ef() && (newdist = d + distToFarthest - 0.4) > 1.0 && newdist <= this.customization.maxlen) {
                this.r = newdist;
            }
            if (d + distToFarthest > this.r) {
                Vec motion = Vec.motionVec((Entity)this);
                if (motion.dot(ropevec) > 0.0) {
                    motion = motion.removeAlong(ropevec);
                }
                this.setVelocityActually(motion.x, motion.y, motion.z);
                ropevec.changeLen_ip(this.r - distToFarthest);
                Vec newpos = ropevec.add(farthest);
                this.func_70107_b(newpos.x, newpos.y, newpos.z);
            }
        }
        if (!this.attached && this.customization.attract && Vec.positionVec((Entity)this).sub(Vec.positionVec(this.shootingEntity)).length() > this.customization.attractradius && !this.foundBlock && !this.field_70170_p.field_72995_K) {
            Vec playerpos = Vec.positionVec(this.shootingEntity);
            Vec pos = Vec.positionVec((Entity)this);
            if (this.magnetBlock == null && this.prevPos != null) {
                HashMap<BlockPos, Boolean> checkedset = new HashMap<BlockPos, Boolean>();
                Vec vector = pos.sub(this.prevPos);
                if (vector.length() > 0.0) {
                    Vec normvector = vector.normalize();
                    int i = 0;
                    while ((double)i < vector.length()) {
                        double dist = this.prevPos.sub(playerpos).length();
                        int radius = (int)dist / 4;
                        BlockPos found = this.check(this.prevPos, checkedset);
                        if (found != null) {
                            Vec distvec = new Vec(found.func_177958_n(), found.func_177956_o(), found.func_177952_p());
                            distvec.sub_ip(this.prevPos);
                            if (distvec.length() < (double)radius) {
                                this.func_226286_f_(this.prevPos.x, this.prevPos.y, this.prevPos.z);
                                pos = this.prevPos;
                                this.magnetBlock = found;
                                break;
                            }
                        } else {
                            this.wasInAir = true;
                        }
                        this.prevPos.add_ip(normvector);
                        ++i;
                    }
                }
            }
            if (this.magnetBlock != null) {
                BlockState blockstate = this.field_70170_p.func_180495_p(this.magnetBlock);
                VoxelShape BB = blockstate.func_196952_d((IBlockReader)this.field_70170_p, this.magnetBlock);
                Vec blockvec = new Vec((double)this.magnetBlock.func_177958_n() + (BB.func_197758_c(Direction.Axis.X) + BB.func_197762_b(Direction.Axis.X)) / 2.0, (double)this.magnetBlock.func_177956_o() + (BB.func_197758_c(Direction.Axis.Y) + BB.func_197762_b(Direction.Axis.Y)) / 2.0, (double)this.magnetBlock.func_177952_p() + (BB.func_197758_c(Direction.Axis.Z) + BB.func_197762_b(Direction.Axis.Z)) / 2.0);
                Vec newvel = blockvec.sub(pos);
                double l = newvel.length();
                newvel.changeLen(this.getVelocity());
                this.func_213293_j(newvel.x, newvel.y, newvel.z);
                if (l < 0.2) {
                    this.serverAttach(this.magnetBlock, blockvec, Direction.UP);
                }
            }
            this.prevPos = pos;
        }
    }

    public void setVelocityActually(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    public boolean func_70112_a(double p_70112_1_) {
        return true;
    }

    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return true;
    }

    public AxisAlignedBB func_184177_bl() {
        if (this.shootingEntity == null) {
            return super.func_184177_bl();
        }
        return this.segmentHandler.getBoundingBox(Vec.positionVec((Entity)this), Vec.positionVec(this.shootingEntity).add(new Vec(0.0, this.shootingEntity.func_70047_e(), 0.0)));
    }

    protected void func_70227_a(RayTraceResult movingobjectposition) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.attached) {
                return;
            }
            if (this.shootingEntityID != 0 && this.shootingEntity != null) {
                Block block;
                BlockPos blockpos;
                if (movingobjectposition == null) {
                    return;
                }
                Vec vec3d = Vec.positionVec((Entity)this);
                Vec vec3d1 = vec3d.add(Vec.motionVec((Entity)this));
                if (movingobjectposition instanceof EntityRayTraceResult && !GrappleConfig.getConf().grapplinghook.other.hookaffectsentities) {
                    this.func_70227_a((RayTraceResult)GrapplemodUtils.rayTraceBlocks(this.field_70170_p, vec3d, vec3d1));
                    return;
                }
                BlockRayTraceResult blockhit = null;
                if (movingobjectposition instanceof BlockRayTraceResult) {
                    blockhit = (BlockRayTraceResult)movingobjectposition;
                }
                if (blockhit != null && (blockpos = blockhit.func_216350_a()) != null && GrappleConfigUtils.breaksBlock(block = this.field_70170_p.func_180495_p(blockpos).func_177230_c())) {
                    this.field_70170_p.func_175655_b(blockpos, true);
                    this.func_70227_a((RayTraceResult)GrapplemodUtils.rayTraceBlocks(this.field_70170_p, vec3d, vec3d1));
                    return;
                }
                if (movingobjectposition instanceof EntityRayTraceResult) {
                    EntityRayTraceResult entityHit = (EntityRayTraceResult)movingobjectposition;
                    Entity entity = entityHit.func_216348_a();
                    if (entity == this.shootingEntity) {
                        return;
                    }
                    Vec playerpos = Vec.positionVec(this.shootingEntity);
                    Vec entitypos = Vec.positionVec(entity);
                    Vec yank = playerpos.sub(entitypos).mult(0.4);
                    yank.y = Math.min(yank.y, 2.0);
                    Vec newmotion = Vec.motionVec(entity).add(yank);
                    entity.func_213317_d(newmotion.toVec3d());
                    this.removeServer();
                    return;
                }
                if (blockhit != null) {
                    blockpos = blockhit.func_216350_a();
                    Vec vec3 = new Vec(movingobjectposition.func_216347_e());
                    this.serverAttach(blockpos, vec3, blockhit.func_216354_b());
                } else {
                    System.out.println("unknown impact?");
                }
            }
        }
    }

    protected Item func_213885_i() {
        return CommonSetup.grapplingHookItem;
    }

    public void serverAttach(BlockPos blockpos, Vec pos, Direction sideHit) {
        Block block;
        if (this.attached) {
            return;
        }
        if (this.shootingEntity == null || this.shootingEntityID == 0) {
            return;
        }
        this.attached = true;
        if (blockpos != null && !GrappleConfigUtils.attachesBlock(block = this.field_70170_p.func_180495_p(blockpos).func_177230_c())) {
            this.removeServer();
            return;
        }
        Vec vec3 = Vec.positionVec((Entity)this);
        vec3.add_ip(Vec.motionVec((Entity)this));
        if (pos != null) {
            vec3 = pos;
            this.func_226286_f_(vec3.x, vec3.y, vec3.z);
        }
        Vec curpos = Vec.positionVec((Entity)this);
        if (sideHit == Direction.DOWN) {
            curpos.y -= 0.3;
        } else if (sideHit == Direction.WEST) {
            curpos.x -= 0.05;
        } else if (sideHit == Direction.NORTH) {
            curpos.z -= 0.05;
        } else if (sideHit == Direction.SOUTH) {
            curpos.z += 0.05;
        } else if (sideHit == Direction.EAST) {
            curpos.x += 0.05;
        } else if (sideHit == Direction.UP) {
            curpos.y += 0.05;
        }
        curpos.setPos((Entity)this);
        this.func_213293_j(0.0, 0.0, 0.0);
        this.thisPos = Vec.positionVec((Entity)this);
        this.firstAttach = true;
        ServerControllerManager.attached.add(this.shootingEntityID);
        GrapplemodUtils.sendToCorrectClient(new GrappleAttachMessage(this.func_145782_y(), this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b, this.func_213303_ch().field_72449_c, this.getControlId(), this.shootingEntityID, blockpos, this.segmentHandler.segments, this.segmentHandler.segmentTopSides, this.segmentHandler.segmentBottomSides, this.customization), this.shootingEntityID, this.field_70170_p);
        GrappleAttachPosMessage msg = new GrappleAttachPosMessage(this.func_145782_y(), this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b, this.func_213303_ch().field_72449_c);
        CommonSetup.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_70170_p.func_175726_f(new BlockPos(this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b, this.func_213303_ch().field_72449_c))), (Object)msg);
    }

    public void clientAttach(double x, double y, double z) {
        this.setAttachPos(x, y, z);
        if (this.shootingEntity instanceof PlayerEntity) {
            ClientProxyInterface.proxy.resetLauncherTime(this.shootingEntityID);
        }
    }

    protected float func_70185_h() {
        if (this.attached) {
            return 0.0f;
        }
        return (float)this.customization.hookgravity * 0.1f;
    }

    public int getControlId() {
        return GrapplemodUtils.GRAPPLEID;
    }

    public void setAttachPos(double x, double y, double z) {
        this.func_226286_f_(x, y, z);
        this.func_213293_j(0.0, 0.0, 0.0);
        this.firstAttach = true;
        this.attached = true;
        this.thisPos = new Vec(x, y, z);
    }

    public BlockPos check(Vec p, HashMap<BlockPos, Boolean> checkedset) {
        int radius = (int)Math.floor(this.customization.attractradius);
        BlockPos closestpos = null;
        double closestdist = 0.0;
        for (int x = (int)p.x - radius; x <= (int)p.x + radius; ++x) {
            for (int y = (int)p.y - radius; y <= (int)p.y + radius; ++y) {
                for (int z = (int)p.z - radius; z <= (int)p.z + radius; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (pos == null || !this.hasBlock(pos, checkedset)) continue;
                    Vec distvec = new Vec(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    distvec.sub_ip(p);
                    double dist = distvec.length();
                    if (closestpos != null && !(dist < closestdist)) continue;
                    closestpos = pos;
                    closestdist = dist;
                }
            }
        }
        return closestpos;
    }

    public boolean hasBlock(BlockPos pos, HashMap<BlockPos, Boolean> checkedset) {
        if (!checkedset.containsKey(pos)) {
            VoxelShape BB;
            boolean isblock = false;
            BlockState blockstate = this.field_70170_p.func_180495_p(pos);
            Block b = blockstate.func_177230_c();
            if (GrappleConfigUtils.attachesBlock(b) && !b.isAir(blockstate, (IBlockReader)this.field_70170_p, pos) && (BB = blockstate.func_196952_d((IBlockReader)this.field_70170_p, pos)) != null && !BB.func_197766_b()) {
                isblock = true;
            }
            checkedset.put(pos, isblock);
            return isblock;
        }
        return checkedset.get(pos);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)this.func_213885_i());
    }
}

