/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.config;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@me.shedaniel.autoconfig.annotation.Config(name="grapplemod")
public class GrappleConfig
implements ConfigData {
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip
    public Config options = new Config();
    @ConfigEntry.Gui.Excluded
    private static Config serverOptions = null;
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip
    public ClientConfig clientOptions = new ClientConfig();

    public static Config getConf() {
        if (serverOptions == null) {
            return ((GrappleConfig)AutoConfig.getConfigHolder(GrappleConfig.class).getConfig()).options;
        }
        return serverOptions;
    }

    public static void setServerOptions(Config newserveroptions) {
        serverOptions = newserveroptions;
    }

    public static ClientConfig getClientConf() {
        return ((GrappleConfig)AutoConfig.getConfigHolder(GrappleConfig.class).getConfig()).clientOptions;
    }

    public static class ClientConfig {
        @ConfigEntry.Gui.CollapsibleObject
        @ConfigEntry.Gui.Tooltip
        public Camera camera = new Camera();
        @ConfigEntry.Gui.CollapsibleObject
        @ConfigEntry.Gui.Tooltip
        public Sounds sounds = new Sounds();

        public static class Sounds {
            @ConfigEntry.Gui.Tooltip
            public double wallrun_sound_effect_time_s = 0.35;
            @ConfigEntry.Gui.Tooltip
            public float wallrun_sound_volume = 1.0f;
            @ConfigEntry.Gui.Tooltip
            public float doublejump_sound_volume = 1.0f;
            @ConfigEntry.Gui.Tooltip
            public float slide_sound_volume = 1.0f;
            @ConfigEntry.Gui.Tooltip
            public float wallrunjump_sound_volume = 1.0f;
            @ConfigEntry.Gui.Tooltip
            public float rocket_sound_volume = 1.0f;
            @ConfigEntry.Gui.Tooltip
            public float enderstaff_sound_volume = 1.0f;
        }

        public static class Camera {
            @ConfigEntry.Gui.Tooltip
            public float wallrun_camera_tilt_degrees = 10.0f;
            @ConfigEntry.Gui.Tooltip
            public float wallrun_camera_animation_s = 0.5f;
        }
    }

    public static class Config {
        @ConfigEntry.Gui.CollapsibleObject
        @ConfigEntry.Gui.Tooltip
        public GrapplingHook grapplinghook = new GrapplingHook();
        @ConfigEntry.Gui.CollapsibleObject
        @ConfigEntry.Gui.Tooltip
        public LongFallBoots longfallboots = new LongFallBoots();
        @ConfigEntry.Gui.CollapsibleObject
        @ConfigEntry.Gui.Tooltip
        public EnderStaff enderstaff = new EnderStaff();
        @ConfigEntry.Gui.CollapsibleObject
        @ConfigEntry.Gui.Tooltip
        public Enchantments enchantments = new Enchantments();
        @ConfigEntry.Gui.CollapsibleObject
        @ConfigEntry.Gui.Tooltip
        public Other other = new Other();

        public static class Other {
            @ConfigEntry.Gui.Tooltip
            public boolean override_allowflight = true;
            @ConfigEntry.Gui.Tooltip
            public double airstrafe_max_speed = 0.7;
            @ConfigEntry.Gui.Tooltip
            public double airstrafe_acceleration = 0.015;
            @ConfigEntry.Gui.Tooltip
            public boolean dont_override_movement_in_air = false;
        }

        public static class Enchantments {
            @ConfigEntry.Gui.CollapsibleObject
            @ConfigEntry.Gui.Tooltip
            public Wallrun wallrun = new Wallrun();
            @ConfigEntry.Gui.CollapsibleObject
            @ConfigEntry.Gui.Tooltip
            public DoubleJump doublejump = new DoubleJump();
            @ConfigEntry.Gui.CollapsibleObject
            @ConfigEntry.Gui.Tooltip
            public Slide slide = new Slide();

            public static class Slide {
                @ConfigEntry.Gui.Tooltip
                public double slidingjumpforce = 0.6;
                @ConfigEntry.Gui.Tooltip
                public double sliding_friction = 0.006666666828095913;
                @ConfigEntry.Gui.Tooltip
                public double sliding_min_speed = 0.15;
                @ConfigEntry.Gui.Tooltip
                public double sliding_end_min_speed = 0.01;
                @ConfigEntry.BoundedDiscrete(max=3L, min=0L)
                @ConfigEntry.Gui.Tooltip
                public int enchant_rarity_sliding = 0;
            }

            public static class DoubleJump {
                @ConfigEntry.Gui.Tooltip
                public double doublejumpforce = 0.8;
                @ConfigEntry.Gui.Tooltip
                public boolean doublejump_relative_to_falling = false;
                @ConfigEntry.Gui.Tooltip
                public double dont_doublejump_if_falling_faster_than = 9.9999999E7;
                @ConfigEntry.BoundedDiscrete(max=3L, min=0L)
                @ConfigEntry.Gui.Tooltip
                public int enchant_rarity_double_jump = 0;
            }

            public static class Wallrun {
                @ConfigEntry.Gui.Tooltip
                public double wall_jump_up = 0.7;
                @ConfigEntry.Gui.Tooltip
                public double wall_jump_side = 0.4;
                @ConfigEntry.Gui.Tooltip
                public double max_wallrun_time = 3.0;
                @ConfigEntry.Gui.Tooltip
                public double wallrun_speed = 0.1;
                @ConfigEntry.Gui.Tooltip
                public double wallrun_max_speed = 0.7;
                @ConfigEntry.Gui.Tooltip
                public double wallrun_drag = 0.01;
                @ConfigEntry.Gui.Tooltip
                public double wallrun_min_speed = 0.0;
                @ConfigEntry.BoundedDiscrete(max=3L, min=0L)
                @ConfigEntry.Gui.Tooltip
                public int enchant_rarity_wallrun = 0;
            }
        }

        public static class EnderStaff {
            @ConfigEntry.Gui.Tooltip
            public double ender_staff_strength = 1.5;
            @ConfigEntry.Gui.Tooltip
            public int ender_staff_recharge = 100;
        }

        public static class LongFallBoots {
            @ConfigEntry.Gui.Tooltip
            public boolean longfallbootsrecipe = true;
        }

        public static class GrapplingHook {
            @ConfigEntry.Gui.CollapsibleObject
            @ConfigEntry.Gui.Tooltip
            public Custom custom = new Custom();
            @ConfigEntry.Gui.CollapsibleObject
            @ConfigEntry.Gui.Tooltip
            public Blocks blocks = new Blocks();
            @ConfigEntry.Gui.CollapsibleObject
            @ConfigEntry.Gui.Tooltip
            public Other other = new Other();

            public static class Other {
                @ConfigEntry.Gui.Tooltip
                public boolean hookaffectsentities = true;
                @ConfigEntry.Gui.Tooltip
                public double rope_snap_buffer = 5.0;
                @ConfigEntry.Gui.Tooltip
                public int default_durability = 500;
                @ConfigEntry.Gui.Tooltip
                public double rope_jump_power = 1.0;
                @ConfigEntry.Gui.Tooltip
                public boolean rope_jump_at_angle = false;
                @ConfigEntry.Gui.Tooltip
                public double rope_jump_cooldown_s = 0.0;
                @ConfigEntry.Gui.Tooltip
                public double climb_speed = 0.3;
            }

            public static class Blocks {
                @ConfigEntry.Gui.Tooltip
                public String grapplingBlocks = "any";
                @ConfigEntry.Gui.Tooltip
                public String grapplingNonBlocks = "none";
                @ConfigEntry.Gui.Tooltip
                public String grappleBreakBlocks = "none";
            }

            public static class Custom {
                @ConfigEntry.Gui.CollapsibleObject
                @ConfigEntry.Gui.Tooltip
                public Rope rope = new Rope();
                @ConfigEntry.Gui.CollapsibleObject
                @ConfigEntry.Gui.Tooltip
                public HookThrower hookthrower = new HookThrower();
                @ConfigEntry.Gui.CollapsibleObject
                @ConfigEntry.Gui.Tooltip
                public Motor motor = new Motor();
                @ConfigEntry.Gui.CollapsibleObject
                @ConfigEntry.Gui.Tooltip
                public Swing swing = new Swing();
                @ConfigEntry.Gui.CollapsibleObject
                @ConfigEntry.Gui.Tooltip
                public EnderStaff enderstaff = new EnderStaff();
                @ConfigEntry.Gui.CollapsibleObject
                @ConfigEntry.Gui.Tooltip
                public Forcefield forcefield = new Forcefield();
                @ConfigEntry.Gui.CollapsibleObject
                @ConfigEntry.Gui.Tooltip
                public Magnet magnet = new Magnet();
                @ConfigEntry.Gui.CollapsibleObject
                @ConfigEntry.Gui.Tooltip
                public DoubleHook doublehook = new DoubleHook();
                @ConfigEntry.Gui.CollapsibleObject
                @ConfigEntry.Gui.Tooltip
                public Rocket rocket = new Rocket();

                public static class Rocket {
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption rocketenabled = new BooleanCustomizationOption(false, 0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption rocket_force = new DoubleCustomizationOption(1.0, 0, 1.0, 5.0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption rocket_active_time = new DoubleCustomizationOption(0.5, 0, 0.5, 20.0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption rocket_refuel_ratio = new DoubleCustomizationOption(15.0, 0, 30.0, 30.0, 15.0, 1.0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption rocket_vertical_angle = new DoubleCustomizationOption(0.0, 0, 90.0, 90.0);
                }

                public static class DoubleHook {
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption doublehook = new BooleanCustomizationOption(false, 0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption smartdoublemotor = new BooleanCustomizationOption(true, 0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption angle = new DoubleCustomizationOption(20.0, 0, 45.0, 90.0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption sneakingangle = new DoubleCustomizationOption(10.0, 0, 45.0, 90.0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption oneropepull = new BooleanCustomizationOption(false, 0);
                }

                public static class Magnet {
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption attract = new BooleanCustomizationOption(false, 0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption attractradius = new DoubleCustomizationOption(3.0, 0, 3.0, 10.0);
                }

                public static class Forcefield {
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption repel = new BooleanCustomizationOption(false, 0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption repelforce = new DoubleCustomizationOption(1.0, 0, 1.0, 5.0);
                }

                public static class EnderStaff {
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption enderstaff = new BooleanCustomizationOption(false, 0);
                }

                public static class Swing {
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption playermovementmult = new DoubleCustomizationOption(1.0, 0, 2.0, 5.0);
                }

                public static class Motor {
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption motor = new BooleanCustomizationOption(false, 0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption motormaxspeed = new DoubleCustomizationOption(4.0, 0, 4.0, 10.0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption motoracceleration = new DoubleCustomizationOption(0.2, 0, 0.2, 1.0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption motorwhencrouching = new BooleanCustomizationOption(false, 0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption motorwhennotcrouching = new BooleanCustomizationOption(true, 0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption smartmotor = new BooleanCustomizationOption(false, 0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption motordampener = new BooleanCustomizationOption(false, 1);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption pullbackwards = new BooleanCustomizationOption(true, 0);
                }

                public static class HookThrower {
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption hookgravity = new DoubleCustomizationOption(1.0, 0, 100.0, 100.0, 1.0, 0.0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption throwspeed = new DoubleCustomizationOption(2.0, 0, 5.0, 20.0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption reelin = new BooleanCustomizationOption(true, 0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption verticalthrowangle = new DoubleCustomizationOption(0.0, 0, 45.0, 90.0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption sneakingverticalthrowangle = new DoubleCustomizationOption(0.0, 0, 45.0, 90.0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption detachonkeyrelease = new BooleanCustomizationOption(false, 0);
                }

                public static class Rope {
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public DoubleCustomizationOption maxlen = new DoubleCustomizationOption(30.0, 0, 60.0, 200.0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption phaserope = new BooleanCustomizationOption(false, 0);
                    @ConfigEntry.Gui.CollapsibleObject
                    @ConfigEntry.Gui.Tooltip
                    public BooleanCustomizationOption sticky = new BooleanCustomizationOption(false, 0);
                }

                public static class BooleanCustomizationOption {
                    @Comment(value="Value when creating a new non-modified grappling hook")
                    public boolean default_value;
                    @Comment(value="Is this value changeable in the grappling hook modifier? 0 = always enabled, 1 = enabled after the limits upgrade, 2 = always disabled")
                    @ConfigEntry.BoundedDiscrete(max=2L, min=0L)
                    public int enabled;

                    public BooleanCustomizationOption(boolean default_value, int enabled) {
                        this.default_value = default_value;
                        this.enabled = enabled;
                    }
                }

                public static class DoubleCustomizationOption {
                    @Comment(value="Value when creating a new non-modified grappling hook")
                    public double default_value;
                    @Comment(value="Is this value changeable in the grappling hook modifier? 0 = always enabled, 1 = enabled after the limits upgrade, 2 = always disabled")
                    @ConfigEntry.BoundedDiscrete(max=2L, min=0L)
                    public int enabled;
                    @Comment(value="Maximum value in the grappling hook modifier (before limits upgrade)")
                    public double max;
                    @Comment(value="Maximum value in the grappling hook modifier (after limits upgrade)")
                    public double max_upgraded;
                    @Comment(value="Minimum value in the grappling hook modifier (before limits upgrade)")
                    public double min;
                    @Comment(value="Minimum value in the grappling hook modifier (after limits upgrade)")
                    public double min_upgraded;

                    public DoubleCustomizationOption(double default_value, int enabled, double max, double max_upgraded) {
                        this.default_value = default_value;
                        this.enabled = enabled;
                        this.max = max;
                        this.max_upgraded = max_upgraded;
                        this.min = 0.0;
                        this.min_upgraded = 0.0;
                    }

                    public DoubleCustomizationOption(double default_value, int enabled, double max, double max_upgraded, double min, double min_upgraded) {
                        this(default_value, enabled, max, max_upgraded);
                        this.min = min;
                        this.min_upgraded = min_upgraded;
                    }
                }
            }
        }
    }
}

