/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.common;

import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.entities.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.items.GrapplehookItem;
import com.yyon.grapplinghook.items.LongFallBoots;
import com.yyon.grapplinghook.network.GrappleDetachMessage;
import com.yyon.grapplinghook.network.LoggedInMessage;
import com.yyon.grapplinghook.server.ServerControllerManager;
import com.yyon.grapplinghook.utils.GrapplemodUtils;
import java.util.HashSet;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class CommonEventHandlers {
    public CommonEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        AutoConfig.register(GrappleConfig.class, Toml4jConfigSerializer::new);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Item item;
        ItemStack stack;
        PlayerEntity player = event.getPlayer();
        if (player != null && (stack = player.func_184586_b(Hand.MAIN_HAND)) != null && (item = stack.func_77973_b()) instanceof GrapplehookItem) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        Entity entity;
        int id;
        boolean isconnected;
        if (!event.getEntity().field_70170_p.field_72995_K && (isconnected = ServerControllerManager.allGrapplehookEntities.containsKey(id = (entity = event.getEntity()).func_145782_y()))) {
            HashSet<GrapplehookEntity> grapplehookEntities = ServerControllerManager.allGrapplehookEntities.get(id);
            for (GrapplehookEntity hookEntity : grapplehookEntities) {
                hookEntity.removeServer();
            }
            grapplehookEntities.clear();
            ServerControllerManager.attached.remove(id);
            if (GrapplehookItem.grapplehookEntitiesLeft.containsKey(entity)) {
                GrapplehookItem.grapplehookEntitiesLeft.remove(entity);
            }
            if (GrapplehookItem.grapplehookEntitiesRight.containsKey(entity)) {
                GrapplehookItem.grapplehookEntitiesRight.remove(entity);
            }
            GrapplemodUtils.sendToCorrectClient(new GrappleDetachMessage(id), id, entity.field_70170_p);
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            for (ItemStack armor : player.func_184193_aE()) {
                if (armor == null || !(armor.func_77973_b() instanceof LongFallBoots) || event.getSource() != DamageSource.field_188406_j) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            for (ItemStack armor : player.func_184193_aE()) {
                if (armor == null || !(armor.func_77973_b() instanceof LongFallBoots)) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onServerStart(FMLServerStartedEvent event) {
        if (GrappleConfig.getConf().other.override_allowflight) {
            event.getServer().func_71245_h(true);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.getPlayer() instanceof ServerPlayerEntity) {
            CommonSetup.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)e.getPlayer()), (Object)new LoggedInMessage(GrappleConfig.getConf()));
        } else {
            System.out.println("Not an PlayerEntityMP");
        }
    }
}

