/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.yyon.grapplinghook.client.ClientControllerManager;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.items.GrapplehookItem;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import net.minecraft.client.GameSettings;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class CrosshairRenderer {
    public Minecraft mc;
    float zLevel = -90.0f;

    public CrosshairRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.mc = Minecraft.func_71410_x();
    }

    @SubscribeEvent
    public void onRenderGameOverlayPost(RenderGameOverlayEvent.Post event) {
        MatrixStack mStack = event.getMatrixStack();
        GameSettings gamesettings = this.mc.field_71474_y;
        if (!gamesettings.func_243230_g().func_243192_a()) {
            return;
        }
        if (this.mc.field_71439_g.func_175149_v()) {
            return;
        }
        if (gamesettings.field_74330_P && !gamesettings.field_74319_N && !this.mc.field_71439_g.func_175140_cp() && !gamesettings.field_178879_v) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            double rocketFuel;
            ClientPlayerEntity player = this.mc.field_71439_g;
            ItemStack grapplehookItemStack = null;
            if (player.func_184586_b(Hand.MAIN_HAND) != null && player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof GrapplehookItem) {
                grapplehookItemStack = player.func_184586_b(Hand.MAIN_HAND);
            } else if (player.func_184586_b(Hand.OFF_HAND) != null && player.func_184586_b(Hand.OFF_HAND).func_77973_b() instanceof GrapplehookItem) {
                grapplehookItemStack = player.func_184586_b(Hand.OFF_HAND);
            }
            if (grapplehookItemStack != null) {
                GrappleCustomization custom = CommonSetup.grapplingHookItem.getCustomization(grapplehookItemStack);
                double angle = Math.toRadians(custom.angle);
                double verticalangle = Math.toRadians(custom.verticalthrowangle);
                if (player.func_213453_ef()) {
                    angle = Math.toRadians(custom.sneakingangle);
                    verticalangle = Math.toRadians(custom.sneakingverticalthrowangle);
                }
                if (!custom.doublehook) {
                    angle = 0.0;
                }
                MainWindow resolution = event.getWindow();
                int w = resolution.func_198107_o();
                int h = resolution.func_198087_p();
                double fov = Math.toRadians(gamesettings.field_74334_X);
                double l = (double)h / 2.0 / Math.tan((fov *= (double)player.func_175156_o()) / 2.0);
                if (verticalangle != 0.0 || custom.doublehook && angle != 0.0) {
                    int offset = (int)(Math.tan(angle) * l);
                    int verticaloffset = (int)(-Math.tan(verticalangle) * l);
                    this.drawCrosshair(mStack, w / 2 + offset, h / 2 + verticaloffset);
                    if (angle != 0.0) {
                        this.drawCrosshair(mStack, w / 2 - offset, h / 2 + verticaloffset);
                    }
                }
                if (custom.rocket && custom.rocket_vertical_angle != 0.0) {
                    int verticaloffset = (int)(-Math.tan(Math.toRadians(custom.rocket_vertical_angle)) * l);
                    this.drawCrosshair(mStack, w / 2, h / 2 + verticaloffset);
                }
            }
            if ((rocketFuel = ClientControllerManager.instance.rocketFuel) < 1.0) {
                MainWindow resolution = event.getWindow();
                int w = resolution.func_198107_o();
                int h = resolution.func_198087_p();
                int totalbarlength = w / 8;
                RenderSystem.pushMatrix();
                RenderSystem.disableLighting();
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                this.drawRect(w / 2 - totalbarlength / 2, h * 3 / 4, totalbarlength, 2, 50, 100);
                this.drawRect(w / 2 - totalbarlength / 2, h * 3 / 4, (int)((double)totalbarlength * rocketFuel), 2, 200, 255);
                RenderSystem.enableTexture();
                RenderSystem.popMatrix();
            }
        }
    }

    private void drawCrosshair(MatrixStack mStack, int x, int y) {
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Minecraft.func_71410_x().field_71456_v.func_238474_b_(mStack, (int)((float)x - 7.5f), (int)((float)y - 7.5f), 0, 0, 15, 15);
    }

    public void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)(x + 0), (double)(y + height), (double)this.zLevel).func_225583_a_((float)(textureX + 0) * f, (float)(textureY + height) * f1).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), (double)this.zLevel).func_225583_a_((float)(textureX + width) * f, (float)(textureY + height) * f1).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + 0), (double)this.zLevel).func_225583_a_((float)(textureX + width) * f, (float)(textureY + 0) * f1).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + 0), (double)(y + 0), (double)this.zLevel).func_225583_a_((float)(textureX + 0) * f, (float)(textureY + 0) * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawRect(int x, int y, int width, int height, int g, int a) {
        Tessellator tessellator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glLineWidth((float)4.0f);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)(x + 0), (double)(y + height), (double)this.zLevel).func_225586_a_(g, g, g, a).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), (double)this.zLevel).func_225586_a_(g, g, g, a).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + 0), (double)this.zLevel).func_225586_a_(g, g, g, a).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + 0), (double)(y + 0), (double)this.zLevel).func_225586_a_(g, g, g, a).func_181675_d();
        tessellator.func_78381_a();
    }
}

