/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.client;

import com.yyon.grapplinghook.client.ClientControllerManager;
import com.yyon.grapplinghook.client.ClientEventHandlers;
import com.yyon.grapplinghook.client.ClientProxy;
import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.client.CrosshairRenderer;
import com.yyon.grapplinghook.client.NonConflictingKeyBinding;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.controllers.AirfrictionController;
import com.yyon.grapplinghook.controllers.ForcefieldController;
import com.yyon.grapplinghook.entities.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.entities.grapplehook.RenderGrapplehookEntity;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    public static ClientSetup instance = null;
    public CrosshairRenderer crosshairRenderer;
    public ClientEventHandlers clientEventHandlers;
    public ClientControllerManager clientControllerManager;
    public static ArrayList<KeyBinding> keyBindings = new ArrayList();
    public static KeyBinding key_boththrow = ClientSetup.createKeyBinding(new NonConflictingKeyBinding("key.boththrow.desc", InputMappings.Type.MOUSE, 1, "key.grapplemod.category"));
    public static KeyBinding key_leftthrow = ClientSetup.createKeyBinding(new NonConflictingKeyBinding("key.leftthrow.desc", InputMappings.field_197958_a.func_197937_c(), "key.grapplemod.category"));
    public static KeyBinding key_rightthrow = ClientSetup.createKeyBinding(new NonConflictingKeyBinding("key.rightthrow.desc", InputMappings.field_197958_a.func_197937_c(), "key.grapplemod.category"));
    public static KeyBinding key_motoronoff = ClientSetup.createKeyBinding(new NonConflictingKeyBinding("key.motoronoff.desc", 340, "key.grapplemod.category"));
    public static KeyBinding key_jumpanddetach = ClientSetup.createKeyBinding(new NonConflictingKeyBinding("key.jumpanddetach.desc", 32, "key.grapplemod.category"));
    public static KeyBinding key_slow = ClientSetup.createKeyBinding(new NonConflictingKeyBinding("key.slow.desc", 340, "key.grapplemod.category"));
    public static KeyBinding key_climb = ClientSetup.createKeyBinding(new NonConflictingKeyBinding("key.climb.desc", 340, "key.grapplemod.category"));
    public static KeyBinding key_climbup = ClientSetup.createKeyBinding(new NonConflictingKeyBinding("key.climbup.desc", InputMappings.field_197958_a.func_197937_c(), "key.grapplemod.category"));
    public static KeyBinding key_climbdown = ClientSetup.createKeyBinding(new NonConflictingKeyBinding("key.climbdown.desc", InputMappings.field_197958_a.func_197937_c(), "key.grapplemod.category"));
    public static KeyBinding key_enderlaunch = ClientSetup.createKeyBinding(new NonConflictingKeyBinding("key.enderlaunch.desc", InputMappings.Type.MOUSE, 0, "key.grapplemod.category"));
    public static KeyBinding key_rocket = ClientSetup.createKeyBinding(new NonConflictingKeyBinding("key.rocket.desc", InputMappings.Type.MOUSE, 0, "key.grapplemod.category"));
    public static KeyBinding key_slide = ClientSetup.createKeyBinding(new NonConflictingKeyBinding("key.slide.desc", 340, "key.grapplemod.category"));

    public static KeyBinding createKeyBinding(KeyBinding k) {
        keyBindings.add(k);
        return k;
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        instance = new ClientSetup();
        instance.onClientSetup();
    }

    public void onClientSetup() {
        for (int i = 0; i < keyBindings.size(); ++i) {
            ClientRegistry.registerKeyBinding((KeyBinding)keyBindings.get(i));
        }
        RenderingRegistry.registerEntityRenderingHandler(CommonSetup.grapplehookEntityType, (IRenderFactory)new GrapplehookEntityRenderFactory());
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> ((ClientProxy)ClientProxyInterface.proxy)::onConfigScreen);
        this.registerPropertyOverride();
        this.crosshairRenderer = new CrosshairRenderer();
        this.clientControllerManager = new ClientControllerManager();
        this.clientEventHandlers = new ClientEventHandlers();
    }

    public void registerPropertyOverride() {
        ItemModelsProperties.func_239418_a_((Item)CommonSetup.grapplingHookItem, (ResourceLocation)new ResourceLocation("rocket"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
                return CommonSetup.grapplingHookItem.getPropertyRocket(stack, (World)world, entity) ? 1.0f : 0.0f;
            }
        });
        ItemModelsProperties.func_239418_a_((Item)CommonSetup.grapplingHookItem, (ResourceLocation)new ResourceLocation("double"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
                return CommonSetup.grapplingHookItem.getPropertyDouble(stack, (World)world, entity) ? 1.0f : 0.0f;
            }
        });
        ItemModelsProperties.func_239418_a_((Item)CommonSetup.grapplingHookItem, (ResourceLocation)new ResourceLocation("motor"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
                return CommonSetup.grapplingHookItem.getPropertyMotor(stack, (World)world, entity) ? 1.0f : 0.0f;
            }
        });
        ItemModelsProperties.func_239418_a_((Item)CommonSetup.grapplingHookItem, (ResourceLocation)new ResourceLocation("smart"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
                return CommonSetup.grapplingHookItem.getPropertySmart(stack, (World)world, entity) ? 1.0f : 0.0f;
            }
        });
        ItemModelsProperties.func_239418_a_((Item)CommonSetup.grapplingHookItem, (ResourceLocation)new ResourceLocation("enderstaff"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
                return CommonSetup.grapplingHookItem.getPropertyEnderstaff(stack, (World)world, entity) ? 1.0f : 0.0f;
            }
        });
        ItemModelsProperties.func_239418_a_((Item)CommonSetup.grapplingHookItem, (ResourceLocation)new ResourceLocation("magnet"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
                return CommonSetup.grapplingHookItem.getPropertyMagnet(stack, (World)world, entity) ? 1.0f : 0.0f;
            }
        });
        ItemModelsProperties.func_239418_a_((Item)CommonSetup.grapplingHookItem, (ResourceLocation)new ResourceLocation("attached"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
                if (entity == null) {
                    return 0.0f;
                }
                return ClientControllerManager.controllers.containsKey(entity.func_145782_y()) && !(ClientControllerManager.controllers.get(entity.func_145782_y()) instanceof AirfrictionController) ? 1.0f : 0.0f;
            }
        });
        ItemModelsProperties.func_239418_a_((Item)CommonSetup.forcefieldItem, (ResourceLocation)new ResourceLocation("attached"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
                if (entity == null) {
                    return 0.0f;
                }
                return ClientControllerManager.controllers.containsKey(entity.func_145782_y()) && ClientControllerManager.controllers.get(entity.func_145782_y()) instanceof ForcefieldController ? 1.0f : 0.0f;
            }
        });
        ItemModelsProperties.func_239418_a_((Item)CommonSetup.grapplingHookItem, (ResourceLocation)new ResourceLocation("hook"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
                return CommonSetup.grapplingHookItem.getPropertyHook(stack, (World)world, entity) ? 1.0f : 0.0f;
            }
        });
    }

    private static class GrapplehookEntityRenderFactory
    implements IRenderFactory<GrapplehookEntity> {
        private GrapplehookEntityRenderFactory() {
        }

        public EntityRenderer<? super GrapplehookEntity> createRenderFor(EntityRendererManager manager) {
            return new RenderGrapplehookEntity(manager, CommonSetup.grapplingHookItem);
        }
    }
}

