/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.client;

import com.yyon.grapplinghook.blocks.modifierblock.GuiModifier;
import com.yyon.grapplinghook.blocks.modifierblock.TileEntityGrappleModifier;
import com.yyon.grapplinghook.client.ClientControllerManager;
import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.client.ClientSetup;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.controllers.GrappleController;
import com.yyon.grapplinghook.items.GrapplehookItem;
import com.yyon.grapplinghook.network.BaseMessageClient;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import com.yyon.grapplinghook.utils.GrapplemodUtils;
import com.yyon.grapplinghook.utils.Vec;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class ClientProxy
extends ClientProxyInterface {
    public ResourceLocation doubleJumpSoundLoc = new ResourceLocation("grapplemod", "doublejump");
    public ResourceLocation slideSoundLoc = new ResourceLocation("grapplemod", "slide");
    List<ItemStack> grapplingHookVariants = null;

    @Override
    public void startRocket(PlayerEntity player, GrappleCustomization custom) {
        ClientControllerManager.instance.startRocket(player, custom);
    }

    @Override
    public String getKeyname(ClientProxyInterface.McKeys keyenum) {
        KeyBinding binding = null;
        GameSettings gs = Minecraft.func_71410_x().field_71474_y;
        if (keyenum == ClientProxyInterface.McKeys.keyBindAttack) {
            binding = gs.field_74312_F;
        } else if (keyenum == ClientProxyInterface.McKeys.keyBindBack) {
            binding = gs.field_74368_y;
        } else if (keyenum == ClientProxyInterface.McKeys.keyBindForward) {
            binding = gs.field_74351_w;
        } else if (keyenum == ClientProxyInterface.McKeys.keyBindJump) {
            binding = gs.field_74314_A;
        } else if (keyenum == ClientProxyInterface.McKeys.keyBindLeft) {
            binding = gs.field_74370_x;
        } else if (keyenum == ClientProxyInterface.McKeys.keyBindRight) {
            binding = gs.field_74366_z;
        } else if (keyenum == ClientProxyInterface.McKeys.keyBindSneak) {
            binding = gs.field_228046_af_;
        } else if (keyenum == ClientProxyInterface.McKeys.keyBindUseItem) {
            binding = gs.field_74313_G;
        }
        if (binding == null) {
            return "";
        }
        String displayname = binding.func_238171_j_().getString();
        if (displayname.equals("Button 1")) {
            return "Left Click";
        }
        if (displayname.equals("Button 2")) {
            return "Right Click";
        }
        return displayname;
    }

    @Override
    public void openModifierScreen(TileEntityGrappleModifier tileent) {
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiModifier(tileent));
    }

    @Override
    public String localize(String string) {
        return I18n.func_135052_a((String)string, (Object[])new Object[0]);
    }

    @Override
    public void onMessageReceivedClient(BaseMessageClient msg, NetworkEvent.Context ctx) {
        msg.processMessage(ctx);
    }

    @Override
    public void playSlideSound(Entity entity) {
        this.playSound(this.slideSoundLoc, GrappleConfig.getClientConf().sounds.slide_sound_volume);
    }

    @Override
    public void playDoubleJumpSound(Entity entity) {
        this.playSound(this.doubleJumpSoundLoc, GrappleConfig.getClientConf().sounds.doublejump_sound_volume * 0.7f);
    }

    @Override
    public void playWallrunJumpSound(Entity entity) {
        this.playSound(this.doubleJumpSoundLoc, GrappleConfig.getClientConf().sounds.wallrunjump_sound_volume * 0.7f);
    }

    @Override
    public void fillGrappleVariants(ItemGroup tab, NonNullList<ItemStack> items) {
        if (!Minecraft.func_71410_x().func_228025_l_() || Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71439_g.field_70170_p == null || Minecraft.func_71410_x().field_71439_g.field_70170_p.func_199532_z() == null) {
            return;
        }
        if (this.grapplingHookVariants == null) {
            this.grapplingHookVariants = new ArrayList<ItemStack>();
            RecipeManager recipemanager = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_199532_z();
            recipemanager.func_215378_c().filter(loc -> loc.func_110624_b().equals("grapplemod")).forEach(loc -> {
                ItemStack stack = ((IRecipe)recipemanager.func_215367_a(loc).get()).func_77571_b();
                if (stack.func_77973_b() instanceof GrapplehookItem && !CommonSetup.grapplingHookItem.getCustomization(stack).equals(new GrappleCustomization())) {
                    this.grapplingHookVariants.add(stack);
                }
            });
        }
        items.addAll(this.grapplingHookVariants);
    }

    public Screen onConfigScreen(Minecraft mc, Screen screen) {
        return (Screen)AutoConfig.getConfigScreen(GrappleConfig.class, (Screen)screen).get();
    }

    @Override
    public void resetLauncherTime(int playerid) {
        ClientControllerManager.instance.resetLauncherTime(playerid);
    }

    @Override
    public void launchPlayer(PlayerEntity player) {
        ClientControllerManager.instance.launchPlayer(player);
    }

    @Override
    public void updateRocketRegen(double rocket_active_time, double rocket_refuel_ratio) {
        ClientControllerManager.instance.updateRocketRegen(rocket_active_time, rocket_refuel_ratio);
    }

    @Override
    public double getRocketFunctioning() {
        return ClientControllerManager.instance.getRocketFunctioning();
    }

    @Override
    public boolean isWallRunning(Entity entity, Vec motion) {
        return ClientControllerManager.instance.isWallRunning(entity, motion);
    }

    @Override
    public boolean isSliding(Entity entity, Vec motion) {
        return ClientControllerManager.instance.isSliding(entity, motion);
    }

    @Override
    public GrappleController createControl(int id, int hookEntityId, int entityid, World world, Vec pos, BlockPos blockpos, GrappleCustomization custom) {
        return ClientControllerManager.instance.createControl(id, hookEntityId, entityid, world, pos, blockpos, custom);
    }

    @Override
    public boolean isKeyDown(ClientProxyInterface.GrappleKeys key) {
        if (key == ClientProxyInterface.GrappleKeys.key_boththrow) {
            return ClientSetup.key_boththrow.func_151470_d();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_leftthrow) {
            return ClientSetup.key_leftthrow.func_151470_d();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_rightthrow) {
            return ClientSetup.key_rightthrow.func_151470_d();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_motoronoff) {
            return ClientSetup.key_motoronoff.func_151470_d();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_jumpanddetach) {
            return ClientSetup.key_jumpanddetach.func_151470_d();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_slow) {
            return ClientSetup.key_slow.func_151470_d();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_climb) {
            return ClientSetup.key_climb.func_151470_d();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_climbup) {
            return ClientSetup.key_climbup.func_151470_d();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_climbdown) {
            return ClientSetup.key_climbdown.func_151470_d();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_enderlaunch) {
            return ClientSetup.key_enderlaunch.func_151470_d();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_rocket) {
            return ClientSetup.key_rocket.func_151470_d();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_slide) {
            return ClientSetup.key_slide.func_151470_d();
        }
        return false;
    }

    @Override
    public GrappleController unregisterController(int entityId) {
        return ClientControllerManager.unregisterController(entityId);
    }

    @Override
    public double getTimeSinceLastRopeJump(World world) {
        return GrapplemodUtils.getTime(world) - ClientControllerManager.prevRopeJumpTime;
    }

    @Override
    public void resetRopeJumpTime(World world) {
        ClientControllerManager.prevRopeJumpTime = GrapplemodUtils.getTime(world);
    }

    @Override
    public boolean isKeyDown(ClientProxyInterface.McKeys keyenum) {
        if (keyenum == ClientProxyInterface.McKeys.keyBindAttack) {
            return Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d();
        }
        if (keyenum == ClientProxyInterface.McKeys.keyBindBack) {
            return Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d();
        }
        if (keyenum == ClientProxyInterface.McKeys.keyBindForward) {
            return Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d();
        }
        if (keyenum == ClientProxyInterface.McKeys.keyBindJump) {
            return Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        }
        if (keyenum == ClientProxyInterface.McKeys.keyBindLeft) {
            return Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d();
        }
        if (keyenum == ClientProxyInterface.McKeys.keyBindRight) {
            return Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d();
        }
        if (keyenum == ClientProxyInterface.McKeys.keyBindSneak) {
            return Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_151470_d();
        }
        if (keyenum == ClientProxyInterface.McKeys.keyBindUseItem) {
            return Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d();
        }
        return false;
    }

    @Override
    public boolean isMovingSlowly(Entity entity) {
        if (entity instanceof ClientPlayerEntity) {
            return ((ClientPlayerEntity)entity).func_228354_I_();
        }
        return false;
    }

    @Override
    public void playSound(ResourceLocation loc, float volume) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SimpleSound(loc, SoundCategory.PLAYERS, volume, 1.0f, false, 0, ISound.AttenuationType.NONE, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), false));
    }

    @Override
    public int getWallrunTicks() {
        return ClientControllerManager.instance.ticksWallRunning;
    }

    @Override
    public void setWallrunTicks(int newWallrunTicks) {
        ClientControllerManager.instance.ticksWallRunning = newWallrunTicks;
    }
}

