/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.client;

import com.yyon.grapplinghook.client.ClientControllerManager;
import com.yyon.grapplinghook.client.ClientSetup;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.controllers.AirfrictionController;
import com.yyon.grapplinghook.controllers.ForcefieldController;
import com.yyon.grapplinghook.controllers.GrappleController;
import com.yyon.grapplinghook.items.KeypressItem;
import com.yyon.grapplinghook.utils.Vec;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEventHandlers {
    public static ClientEventHandlers instance = null;
    public boolean[] prevKeys = new boolean[]{false, false, false, false, false};
    public float currentCameraTilt = 0.0f;

    public ClientEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && !Minecraft.func_71410_x().func_147113_T()) {
            ClientControllerManager.instance.onClientTick((PlayerEntity)player);
            if (Minecraft.func_71410_x().field_71462_r == null) {
                boolean[] keys = new boolean[]{ClientSetup.key_enderlaunch.func_151470_d(), ClientSetup.key_leftthrow.func_151470_d(), ClientSetup.key_rightthrow.func_151470_d(), ClientSetup.key_boththrow.func_151470_d(), ClientSetup.key_rocket.func_151470_d()};
                for (int i = 0; i < keys.length; ++i) {
                    boolean iskeydown = keys[i];
                    boolean prevkey = this.prevKeys[i];
                    if (iskeydown != prevkey) {
                        KeypressItem.Keys key = KeypressItem.Keys.values()[i];
                        ItemStack stack = this.getKeypressStack((PlayerEntity)player);
                        if (stack != null && !this.isLookingAtModifierBlock((PlayerEntity)player)) {
                            if (iskeydown) {
                                ((KeypressItem)stack.func_77973_b()).onCustomKeyDown(stack, (PlayerEntity)player, key, true);
                            } else {
                                ((KeypressItem)stack.func_77973_b()).onCustomKeyUp(stack, (PlayerEntity)player, key, true);
                            }
                        }
                    }
                    this.prevKeys[i] = iskeydown;
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPos() != null && ClientControllerManager.controllerPos.containsKey(event.getPos())) {
            GrappleController control = ClientControllerManager.controllerPos.get(event.getPos());
            control.unattach();
            ClientControllerManager.controllerPos.remove(event.getPos());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOutEvent(ClientPlayerNetworkEvent.LoggedOutEvent e) {
        GrappleConfig.setServerOptions(null);
    }

    @SubscribeEvent
    public void onKeyInputEvent(InputEvent.KeyInputEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (!Minecraft.func_71410_x().func_228025_l_() || player == null) {
            return;
        }
        GrappleController controller = null;
        if (ClientControllerManager.controllers.containsKey(player.func_145782_y())) {
            controller = ClientControllerManager.controllers.get(player.func_145782_y());
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() && controller != null && controller instanceof AirfrictionController && ((AirfrictionController)controller).wasSliding) {
            controller.slidingJump();
        }
        ClientControllerManager.instance.checkSlide((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onInputUpdate(InputUpdateEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (!Minecraft.func_71410_x().func_228025_l_() || player == null) {
            return;
        }
        int id = player.func_145782_y();
        if (ClientControllerManager.controllers.containsKey(id)) {
            MovementInput input = event.getMovementInput();
            GrappleController control = ClientControllerManager.controllers.get(id);
            control.receivePlayerMovementMessage(input.field_78902_a, input.field_192832_b, input.field_78901_c, input.field_228350_h_);
            boolean overrideMovement = true;
            if (Minecraft.func_71410_x().field_71439_g.func_233570_aj_() && !(control instanceof AirfrictionController) && !(control instanceof ForcefieldController)) {
                overrideMovement = false;
            }
            if (overrideMovement) {
                input.field_78901_c = false;
                input.field_187256_d = false;
                input.field_187255_c = false;
                input.field_187257_e = false;
                input.field_187258_f = false;
                input.field_192832_b = 0.0f;
                input.field_78902_a = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        float cameraDiff;
        GrappleController controller;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (!Minecraft.func_71410_x().func_228025_l_() || player == null) {
            return;
        }
        int id = player.func_145782_y();
        int targetCameraTilt = 0;
        if (ClientControllerManager.controllers.containsKey(id) && (controller = ClientControllerManager.controllers.get(id)) instanceof AirfrictionController) {
            Vec walldirection;
            AirfrictionController afcontroller = (AirfrictionController)controller;
            if (afcontroller.wasWallrunning && (walldirection = afcontroller.getWallDirection()) != null) {
                int dir;
                Vec lookdirection = Vec.lookVec((Entity)player);
                targetCameraTilt = dir = lookdirection.cross((Vec)walldirection).y > 0.0 ? 1 : -1;
            }
        }
        if (this.currentCameraTilt != (float)targetCameraTilt && (cameraDiff = (float)targetCameraTilt - this.currentCameraTilt) != 0.0f) {
            float speed;
            float anim_s = GrappleConfig.getClientConf().camera.wallrun_camera_animation_s;
            float f = speed = anim_s == 0.0f ? 9999.0f : 1.0f / (anim_s * 20.0f);
            this.currentCameraTilt = speed > Math.abs(cameraDiff) ? (float)targetCameraTilt : (this.currentCameraTilt += speed * (float)(cameraDiff > 0.0f ? 1 : -1));
        }
        if (this.currentCameraTilt != 0.0f) {
            event.setRoll(event.getRoll() + this.currentCameraTilt * GrappleConfig.getClientConf().camera.wallrun_camera_tilt_degrees);
        }
    }

    public ItemStack getKeypressStack(PlayerEntity player) {
        if (player != null) {
            Item item;
            ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
            if (stack != null && (item = stack.func_77973_b()) instanceof KeypressItem) {
                return stack;
            }
            stack = player.func_184586_b(Hand.OFF_HAND);
            if (stack != null && (item = stack.func_77973_b()) instanceof KeypressItem) {
                return stack;
            }
        }
        return null;
    }

    public boolean isLookingAtModifierBlock(PlayerEntity player) {
        RayTraceResult raytraceresult = Minecraft.func_71410_x().field_71476_x;
        if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult bray = (BlockRayTraceResult)raytraceresult;
            BlockPos pos = bray.func_216350_a();
            BlockState state = player.field_70170_p.func_180495_p(pos);
            return state.func_177230_c() == CommonSetup.grappleModifierBlock;
        }
        return false;
    }
}

