/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.client;

import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.client.ClientSetup;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.controllers.AirfrictionController;
import com.yyon.grapplinghook.controllers.ForcefieldController;
import com.yyon.grapplinghook.controllers.GrappleController;
import com.yyon.grapplinghook.entities.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.items.EnderStaffItem;
import com.yyon.grapplinghook.items.GrapplehookItem;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import com.yyon.grapplinghook.utils.GrapplemodUtils;
import com.yyon.grapplinghook.utils.Vec;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;

public class ClientControllerManager {
    public static ClientControllerManager instance;
    public static HashMap<Integer, GrappleController> controllers;
    public HashMap<Integer, Long> enderLaunchTimer = new HashMap();
    public double rocketFuel = 1.0;
    public double rocketIncreaseTick = 0.0;
    public double rocketDecreaseTick = 0.0;
    public int ticksWallRunning = 0;
    boolean prevJumpButton = false;
    int ticksSinceLastOnGround = 0;
    boolean alreadyUsedDoubleJump = false;
    public static HashMap<BlockPos, GrappleController> controllerPos;
    public static long prevRopeJumpTime;

    public ClientControllerManager() {
        instance = this;
    }

    public void onClientTick(PlayerEntity player) {
        long timer;
        if (player.func_233570_aj_() || controllers.containsKey(player.func_145782_y()) && ClientControllerManager.controllers.get((Object)Integer.valueOf((int)player.func_145782_y())).controllerId == GrapplemodUtils.GRAPPLEID) {
            this.ticksWallRunning = 0;
        }
        if (this.isWallRunning((Entity)player, Vec.motionVec((Entity)player))) {
            Object controller;
            if (!controllers.containsKey(player.func_145782_y()) && ((GrappleController)(controller = this.createControl(GrapplemodUtils.AIRID, -1, player.func_145782_y(), player.field_70170_p, new Vec(0.0, 0.0, 0.0), null, null))).getWallDirection() == null) {
                ((GrappleController)controller).unattach();
            }
            if (controllers.containsKey(player.func_145782_y())) {
                this.ticksSinceLastOnGround = 0;
                this.alreadyUsedDoubleJump = false;
            }
        }
        this.checkDoubleJump();
        this.checkSlide(player);
        this.rocketFuel += this.rocketIncreaseTick;
        try {
            for (GrappleController controller : controllers.values()) {
                controller.doClientTick();
            }
        }
        catch (ConcurrentModificationException e) {
            System.out.println("ConcurrentModificationException caught");
        }
        if (this.rocketFuel > 1.0) {
            this.rocketFuel = 1.0;
        }
        if (player.func_233570_aj_() && this.enderLaunchTimer.containsKey(player.func_145782_y()) && (timer = GrapplemodUtils.getTime(player.field_70170_p) - this.enderLaunchTimer.get(player.func_145782_y())) > 10L) {
            this.resetLauncherTime(player.func_145782_y());
        }
    }

    public void checkSlide(PlayerEntity player) {
        if (ClientSetup.key_slide.func_151470_d() && !controllers.containsKey(player.func_145782_y()) && this.isSliding((Entity)player, Vec.motionVec((Entity)player))) {
            this.createControl(GrapplemodUtils.AIRID, -1, player.func_145782_y(), player.field_70170_p, new Vec(0.0, 0.0, 0.0), null, null);
        }
    }

    public void launchPlayer(PlayerEntity player) {
        long prevtime = this.enderLaunchTimer.containsKey(player.func_145782_y()) ? this.enderLaunchTimer.get(player.func_145782_y()) : 0L;
        long timer = GrapplemodUtils.getTime(player.field_70170_p) - prevtime;
        if (timer > (long)GrappleConfig.getConf().enderstaff.ender_staff_recharge && (player.func_184586_b(Hand.MAIN_HAND) != null && (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof EnderStaffItem || player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof GrapplehookItem) || player.func_184586_b(Hand.OFF_HAND) != null && (player.func_184586_b(Hand.OFF_HAND).func_77973_b() instanceof EnderStaffItem || player.func_184586_b(Hand.OFF_HAND).func_77973_b() instanceof GrapplehookItem))) {
            this.enderLaunchTimer.put(player.func_145782_y(), GrapplemodUtils.getTime(player.field_70170_p));
            Vec facing = Vec.lookVec((Entity)player);
            GrappleCustomization custom = null;
            if (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof GrapplehookItem) {
                custom = ((GrapplehookItem)player.func_184586_b(Hand.MAIN_HAND).func_77973_b()).getCustomization(player.func_184586_b(Hand.MAIN_HAND));
            } else if (player.func_184586_b(Hand.OFF_HAND).func_77973_b() instanceof GrapplehookItem) {
                custom = ((GrapplehookItem)player.func_184586_b(Hand.OFF_HAND).func_77973_b()).getCustomization(player.func_184586_b(Hand.OFF_HAND));
            }
            if (!controllers.containsKey(player.func_145782_y())) {
                player.func_230245_c_(false);
                this.createControl(GrapplemodUtils.AIRID, -1, player.func_145782_y(), player.field_70170_p, new Vec(0.0, 0.0, 0.0), null, custom);
            }
            facing.mult_ip(GrappleConfig.getConf().enderstaff.ender_staff_strength);
            ClientControllerManager.receiveEnderLaunch(player.func_145782_y(), facing.x, facing.y, facing.z);
            ClientProxyInterface.proxy.playSound(new ResourceLocation("grapplemod", "enderstaff"), GrappleConfig.getClientConf().sounds.enderstaff_sound_volume * 0.5f);
        }
    }

    public void resetLauncherTime(int playerid) {
        if (this.enderLaunchTimer.containsKey(playerid)) {
            this.enderLaunchTimer.put(playerid, 0L);
        }
    }

    public void updateRocketRegen(double rocket_active_time, double rocket_refuel_ratio) {
        this.rocketDecreaseTick = 0.025 / rocket_active_time;
        this.rocketIncreaseTick = 0.025 / rocket_active_time / rocket_refuel_ratio;
    }

    public double getRocketFunctioning() {
        this.rocketFuel -= this.rocketIncreaseTick;
        this.rocketFuel -= this.rocketDecreaseTick;
        if (this.rocketFuel >= 0.0) {
            return 1.0;
        }
        this.rocketFuel = 0.0;
        return this.rocketIncreaseTick / this.rocketDecreaseTick / 2.0;
    }

    public boolean isWallRunning(Entity entity, Vec motion) {
        if (entity.field_70123_F && !entity.func_233570_aj_() && !entity.func_213453_ef()) {
            if (entity instanceof LivingEntity && ((LivingEntity)entity).func_70617_f_()) {
                return false;
            }
            for (ItemStack stack : entity.func_184193_aE()) {
                double current_speed;
                BlockRayTraceResult raytraceresult;
                Map enchantments;
                if (stack == null || !(enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack)).containsKey((Object)CommonSetup.wallrunEnchantment)) continue;
                if ((Integer)enchantments.get((Object)CommonSetup.wallrunEnchantment) < 1 || ClientSetup.key_jumpanddetach.func_151470_d() || Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() || (raytraceresult = GrapplemodUtils.rayTraceBlocks(entity.field_70170_p, Vec.positionVec(entity), Vec.positionVec(entity).add(new Vec(0.0, -1.0, 0.0)))) != null || !((current_speed = Math.sqrt(Math.pow(motion.x, 2.0) + Math.pow(motion.z, 2.0))) >= GrappleConfig.getConf().enchantments.wallrun.wallrun_min_speed)) break;
                return true;
            }
        }
        return false;
    }

    public void checkDoubleJump() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_233570_aj_()) {
            this.ticksSinceLastOnGround = 0;
            this.alreadyUsedDoubleJump = false;
        } else {
            ++this.ticksSinceLastOnGround;
        }
        boolean isjumpbuttondown = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        if (!(!isjumpbuttondown || this.prevJumpButton || player.func_70090_H() || player.func_180799_ab() || this.ticksSinceLastOnGround <= 3 || this.alreadyUsedDoubleJump || !this.wearingDoubleJumpEnchant((Entity)player) || controllers.containsKey(player.func_145782_y()) && !(controllers.get(player.func_145782_y()) instanceof AirfrictionController))) {
            GrappleController controller;
            if (!controllers.containsKey(player.func_145782_y())) {
                this.createControl(GrapplemodUtils.AIRID, -1, player.func_145782_y(), player.field_70170_p, new Vec(0.0, 0.0, 0.0), null, null);
            }
            if ((controller = controllers.get(player.func_145782_y())) instanceof AirfrictionController) {
                this.alreadyUsedDoubleJump = true;
                controller.doubleJump();
            }
            ClientProxyInterface.proxy.playDoubleJumpSound(controller.entity);
        }
        this.prevJumpButton = isjumpbuttondown;
    }

    public boolean wearingDoubleJumpEnchant(Entity entity) {
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75100_b) {
            return false;
        }
        for (ItemStack stack : entity.func_184193_aE()) {
            Map enchantments;
            if (stack == null || !(enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack)).containsKey((Object)CommonSetup.doubleJumpEnchantment) || (Integer)enchantments.get((Object)CommonSetup.doubleJumpEnchantment) < 1) continue;
            return true;
        }
        return false;
    }

    public static boolean isWearingSlidingEnchant(Entity entity) {
        for (ItemStack stack : entity.func_184193_aE()) {
            Map enchantments;
            if (stack == null || !(enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack)).containsKey((Object)CommonSetup.slidingEnchantment) || (Integer)enchantments.get((Object)CommonSetup.slidingEnchantment) < 1) continue;
            return true;
        }
        return false;
    }

    public boolean isSliding(Entity entity, Vec motion) {
        if (entity.func_70090_H() || entity.func_180799_ab()) {
            return false;
        }
        if (entity.func_233570_aj_() && ClientSetup.key_slide.func_151470_d() && ClientControllerManager.isWearingSlidingEnchant(entity)) {
            double speed;
            GrappleController controller;
            boolean was_sliding = false;
            int id = entity.func_145782_y();
            if (controllers.containsKey(id) && (controller = controllers.get(id)) instanceof AirfrictionController) {
                AirfrictionController afc = (AirfrictionController)controller;
                if (afc.wasSliding) {
                    was_sliding = true;
                }
            }
            if ((speed = motion.removeAlong(new Vec(0.0, 1.0, 0.0)).length()) > GrappleConfig.getConf().enchantments.slide.sliding_end_min_speed && (was_sliding || speed > GrappleConfig.getConf().enchantments.slide.sliding_min_speed)) {
                return true;
            }
        }
        return false;
    }

    public GrappleController createControl(int controllerId, int grapplehookEntityId, int playerId, World world, Vec pos, BlockPos blockPos, GrappleCustomization custom) {
        GrapplehookEntity grapplehookEntity = null;
        Entity grapplehookEntityUncast = world.func_73045_a(grapplehookEntityId);
        if (grapplehookEntityUncast != null && grapplehookEntityUncast instanceof GrapplehookEntity) {
            grapplehookEntity = (GrapplehookEntity)grapplehookEntityUncast;
        }
        boolean multi = custom != null && custom.doublehook;
        GrappleController currentcontroller = controllers.get(playerId);
        if (!(currentcontroller == null || multi && currentcontroller.custom != null && currentcontroller.custom.doublehook)) {
            currentcontroller.unattach();
        }
        GrappleController control = null;
        if (controllerId == GrapplemodUtils.GRAPPLEID) {
            if (!multi) {
                control = new GrappleController(grapplehookEntityId, playerId, world, pos, controllerId, custom);
            } else {
                control = controllers.get(playerId);
                boolean created = false;
                if (control != null && control.getClass().equals(GrappleController.class)) {
                    GrappleController c = control;
                    if (control.custom.doublehook && grapplehookEntity != null && grapplehookEntity instanceof GrapplehookEntity) {
                        GrapplehookEntity multiHookEntity = grapplehookEntity;
                        created = true;
                        c.addHookEntity(multiHookEntity);
                        return control;
                    }
                }
                if (!created) {
                    control = new GrappleController(grapplehookEntityId, playerId, world, pos, controllerId, custom);
                }
            }
        } else if (controllerId == GrapplemodUtils.REPELID) {
            control = new ForcefieldController(grapplehookEntityId, playerId, world, pos, controllerId);
        } else if (controllerId == GrapplemodUtils.AIRID) {
            control = new AirfrictionController(grapplehookEntityId, playerId, world, pos, controllerId, custom);
        } else {
            return null;
        }
        if (control == null) {
            return null;
        }
        if (blockPos != null) {
            controllerPos.put(blockPos, control);
        }
        ClientControllerManager.registerController(playerId, control);
        Entity e = world.func_73045_a(playerId);
        if (e != null && e instanceof ClientPlayerEntity) {
            ClientPlayerEntity p = (ClientPlayerEntity)e;
            control.receivePlayerMovementMessage(p.field_71158_b.field_78902_a, p.field_71158_b.field_192832_b, p.field_71158_b.field_78901_c, p.field_71158_b.field_228350_h_);
        }
        return control;
    }

    public static void registerController(int entityId, GrappleController controller) {
        if (controllers.containsKey(entityId)) {
            controllers.get(entityId).unattach();
        }
        controllers.put(entityId, controller);
    }

    public static GrappleController unregisterController(int entityId) {
        if (controllers.containsKey(entityId)) {
            GrappleController controller = controllers.get(entityId);
            controllers.remove(entityId);
            BlockPos pos = null;
            for (BlockPos blockpos : controllerPos.keySet()) {
                GrappleController otherController = controllerPos.get(blockpos);
                if (otherController != controller) continue;
                pos = blockpos;
            }
            if (pos != null) {
                controllerPos.remove(pos);
            }
            return controller;
        }
        return null;
    }

    public static void receiveGrappleDetach(int id) {
        GrappleController controller = controllers.get(id);
        if (controller != null) {
            controller.receiveGrappleDetach();
        }
    }

    public static void receiveGrappleDetachHook(int id, int hookid) {
        GrappleController controller = controllers.get(id);
        if (controller != null) {
            controller.receiveGrappleDetachHook(hookid);
        }
    }

    public static void receiveEnderLaunch(int id, double x, double y, double z) {
        GrappleController controller = controllers.get(id);
        if (controller != null) {
            controller.receiveEnderLaunch(x, y, z);
        } else {
            System.out.println("Couldn't find controller");
        }
    }

    public void startRocket(PlayerEntity player, GrappleCustomization custom) {
        GrappleController controller;
        if (!custom.rocket) {
            return;
        }
        if (!controllers.containsKey(player.func_145782_y())) {
            controller = this.createControl(GrapplemodUtils.AIRID, -1, player.func_145782_y(), player.field_70170_p, new Vec(0.0, 0.0, 0.0), null, custom);
        } else {
            controller = controllers.get(player.func_145782_y());
            if (controller.custom == null || !controller.custom.rocket) {
                if (controller.custom == null) {
                    controller.custom = custom;
                }
                controller.custom.rocket = true;
                controller.custom.rocket_active_time = custom.rocket_active_time;
                controller.custom.rocket_force = custom.rocket_force;
                controller.custom.rocket_refuel_ratio = custom.rocket_refuel_ratio;
                this.updateRocketRegen(custom.rocket_active_time, custom.rocket_refuel_ratio);
            }
        }
        RocketSound sound = new RocketSound(controller, new SoundEvent(new ResourceLocation("grapplemod", "rocket")), SoundCategory.PLAYERS);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
    }

    static {
        controllers = new HashMap();
        controllerPos = new HashMap();
        prevRopeJumpTime = 0L;
    }

    public static class RocketSound
    extends TickableSound {
        GrappleController controller;
        boolean stopping = false;
        public float changespeed;

        protected RocketSound(GrappleController controller, SoundEvent p_i46532_1_, SoundCategory p_i46532_2_) {
            super(p_i46532_1_, p_i46532_2_);
            this.field_147659_g = true;
            this.controller = controller;
            controller.rocket_key = true;
            controller.rocket_on = 1.0;
            this.field_147662_b = this.changespeed = GrappleConfig.getClientConf().sounds.rocket_sound_volume * 0.5f * 0.2f;
            this.field_147665_h = 0;
            this.field_147666_i = ISound.AttenuationType.NONE;
            this.field_217862_m = false;
            this.field_204201_l = false;
        }

        public void func_73660_a() {
            float diff;
            if (!this.controller.rocket_key || !this.controller.attached) {
                this.stopping = true;
            }
            float targetvolume = (float)this.controller.rocket_on * GrappleConfig.getClientConf().sounds.rocket_sound_volume * 0.5f;
            if (this.stopping) {
                targetvolume = 0.0f;
            }
            this.field_147662_b = (diff = Math.abs(targetvolume - this.field_147662_b)) > this.changespeed ? (this.field_147662_b += this.changespeed * (float)(this.field_147662_b > targetvolume ? -1 : 1)) : targetvolume;
            if (this.field_147662_b == 0.0f && this.stopping) {
                this.func_239509_o_();
            }
            this.field_147660_d = this.controller.entity.func_226277_ct_();
            this.field_147661_e = this.controller.entity.func_226278_cu_();
            this.field_147658_f = this.controller.entity.func_226281_cx_();
        }
    }
}

