/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.blocks.modifierblock;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.yyon.grapplinghook.blocks.modifierblock.TileEntityGrappleModifier;
import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiModifier
extends Screen {
    private static final ResourceLocation texture = new ResourceLocation("grapplemod", "textures/gui/guimodifier_bg.png");
    int xSize = 221;
    int ySize = 221;
    protected int guiLeft;
    protected int guiTop;
    int posy;
    int id;
    HashMap<Widget, String> options;
    TileEntityGrappleModifier tileEnt;
    GrappleCustomization customization;
    GrappleCustomization.upgradeCategories category = null;

    public GuiModifier(TileEntityGrappleModifier tileent) {
        super((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.title.desc")));
        this.tileEnt = tileent;
        this.customization = tileent.customization;
    }

    public void func_231158_b_(Minecraft p_231158_1_, int p_231158_2_, int p_231158_3_) {
        super.func_231158_b_(p_231158_1_, p_231158_2_, p_231158_3_);
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.mainScreen();
    }

    public void mainScreen() {
        this.clearScreen();
        this.func_230480_a_((Widget)new Button(this.guiLeft + 10, this.guiTop + this.ySize - 20 - 10, 50, 20, (ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.close.desc")), new Button.IPressable(){

            public void onPress(Button p_onPress_1_) {
                GuiModifier.this.func_231175_as__();
            }
        }));
        this.func_230480_a_((Widget)new Button(this.guiLeft + this.xSize - 50 - 10, this.guiTop + this.ySize - 20 - 10, 50, 20, (ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.reset.desc")), new Button.IPressable(){

            public void onPress(Button p_onPress_1_) {
                GuiModifier.this.customization = new GrappleCustomization();
                GuiModifier.this.mainScreen();
            }
        }));
        this.func_230480_a_((Widget)new Button(this.guiLeft + 10 + 75, this.guiTop + this.ySize - 20 - 10, 50, 20, (ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.helpbutton.desc")), new Button.IPressable(){

            public void onPress(Button p_onPress_1_) {
                GuiModifier.this.helpScreen();
            }
        }));
        int y = 0;
        int x = 0;
        for (int i = 0; i < GrappleCustomization.upgradeCategories.size(); ++i) {
            GrappleCustomization.upgradeCategories category = GrappleCustomization.upgradeCategories.fromInt(i);
            if (category == GrappleCustomization.upgradeCategories.LIMITS) continue;
            if (i == GrappleCustomization.upgradeCategories.size() / 2) {
                y = 0;
                ++x;
            }
            this.func_230480_a_((Widget)new Button(this.guiLeft + 10 + 105 * x, this.guiTop + 15 + 30 * y, 95, 20, (ITextComponent)new StringTextComponent(category.getName()), (Button.IPressable)new PressCategory(category)));
            ++y;
        }
        this.func_230480_a_(new TextWidget((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.apply.desc")), this.guiLeft + 10, this.guiTop + this.ySize - 20 - 10 - 10));
    }

    public void clearScreen() {
        this.field_230710_m_.clear();
        this.category = null;
        this.posy = 10;
        this.id = 10;
        this.options = new HashMap();
        this.field_230705_e_.clear();
        this.func_230480_a_(new BackgroundWidget(this.guiLeft, this.guiTop, this.xSize, this.ySize));
    }

    public void notAllowedScreen(GrappleCustomization.upgradeCategories category) {
        this.clearScreen();
        this.func_230480_a_((Widget)new Button(this.guiLeft + 10, this.guiTop + this.ySize - 20 - 10, 50, 20, (ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.back.desc")), (Button.IPressable)new PressBack()));
        this.category = category;
        this.func_230480_a_(new TextWidget((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.unlock1.desc")), this.guiLeft + 10, this.guiTop + 10));
        this.func_230480_a_(new TextWidget((ITextComponent)new StringTextComponent(this.category.getName()), this.guiLeft + 10, this.guiTop + 25));
        this.func_230480_a_(new TextWidget((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.unlock2.desc")), this.guiLeft + 10, this.guiTop + 40));
        this.func_230480_a_(new TextWidget((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.unlock3.desc")), this.guiLeft + 10, this.guiTop + 55));
        this.func_230480_a_(new TextWidget(new ItemStack((IItemProvider)this.category.getItem()).func_151000_E(), this.guiLeft + 10, this.guiTop + 70));
        this.func_230480_a_(new TextWidget((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.unlock4.desc")), this.guiLeft + 10, this.guiTop + 85));
    }

    public void helpScreen() {
        this.clearScreen();
        this.func_230480_a_((Widget)new Button(this.guiLeft + 10, this.guiTop + this.ySize - 20 - 10, 50, 20, (ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.back.desc")), (Button.IPressable)new PressBack()));
        this.func_230480_a_(new TextWidget((ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.help.desc")), this.guiLeft + 10, this.guiTop + 10));
    }

    public void addCheckbox(String option) {
        String text = ClientProxyInterface.proxy.localize(this.customization.getName(option));
        String desc = ClientProxyInterface.proxy.localize(this.customization.getDescription(option));
        GuiCheckbox checkbox = new GuiCheckbox(10 + this.guiLeft, this.posy + this.guiTop, this.xSize - 20, 20, (ITextComponent)new StringTextComponent(text), this.customization.getBoolean(option), option, (ITextComponent)new StringTextComponent(desc));
        this.posy += 22;
        this.func_230480_a_((Widget)checkbox);
        this.options.put((Widget)checkbox, option);
    }

    public void addSlider(String option) {
        double d = this.customization.getDouble(option);
        d = Math.floor(d * 10.0 + 0.5) / 10.0;
        double max = this.customization.getMax(option, this.getLimits());
        double min = this.customization.getMin(option, this.getLimits());
        String text = ClientProxyInterface.proxy.localize(this.customization.getName(option));
        String desc = ClientProxyInterface.proxy.localize(this.customization.getDescription(option));
        GuiSlider slider = new GuiSlider(10 + this.guiLeft, this.posy + this.guiTop, this.xSize - 20, 20, (ITextComponent)new StringTextComponent(text), min, max, d, option, (ITextComponent)new StringTextComponent(desc));
        this.posy += 22;
        this.func_230480_a_((Widget)slider);
        this.options.put((Widget)slider, option);
    }

    public void showCategoryScreen(GrappleCustomization.upgradeCategories category) {
        this.clearScreen();
        this.func_230480_a_((Widget)new Button(this.guiLeft + 10, this.guiTop + this.ySize - 20 - 10, 50, 20, (ITextComponent)new StringTextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.back.desc")), (Button.IPressable)new PressBack()));
        this.category = category;
        if (category == GrappleCustomization.upgradeCategories.ROPE) {
            this.addSlider("maxlen");
            this.addCheckbox("phaserope");
            this.addCheckbox("sticky");
        } else if (category == GrappleCustomization.upgradeCategories.THROW) {
            this.addSlider("hookgravity");
            this.addSlider("throwspeed");
            this.addCheckbox("reelin");
            this.addSlider("verticalthrowangle");
            this.addSlider("sneakingverticalthrowangle");
            this.addCheckbox("detachonkeyrelease");
        } else if (category == GrappleCustomization.upgradeCategories.MOTOR) {
            this.addCheckbox("motor");
            this.addSlider("motormaxspeed");
            this.addSlider("motoracceleration");
            this.addCheckbox("motorwhencrouching");
            this.addCheckbox("motorwhennotcrouching");
            this.addCheckbox("smartmotor");
            this.addCheckbox("motordampener");
            this.addCheckbox("pullbackwards");
        } else if (category == GrappleCustomization.upgradeCategories.SWING) {
            this.addSlider("playermovementmult");
        } else if (category == GrappleCustomization.upgradeCategories.STAFF) {
            this.addCheckbox("enderstaff");
        } else if (category == GrappleCustomization.upgradeCategories.FORCEFIELD) {
            this.addCheckbox("repel");
            this.addSlider("repelforce");
        } else if (category == GrappleCustomization.upgradeCategories.MAGNET) {
            this.addCheckbox("attract");
            this.addSlider("attractradius");
        } else if (category == GrappleCustomization.upgradeCategories.DOUBLE) {
            this.addCheckbox("doublehook");
            this.addCheckbox("smartdoublemotor");
            this.addSlider("angle");
            this.addSlider("sneakingangle");
            this.addCheckbox("oneropepull");
        } else if (category == GrappleCustomization.upgradeCategories.ROCKET) {
            this.addCheckbox("rocket");
            this.addSlider("rocket_force");
            this.addSlider("rocket_active_time");
            this.addSlider("rocket_refuel_ratio");
            this.addSlider("rocket_vertical_angle");
        }
        this.updateEnabled();
    }

    public void func_231175_as__() {
        this.tileEnt.setCustomizationClient(this.customization);
        super.func_231175_as__();
    }

    public void updateEnabled() {
        for (Widget b : this.options.keySet()) {
            String option = this.options.get(b);
            boolean enabled = true;
            String desc = ClientProxyInterface.proxy.localize(this.customization.getDescription(option));
            if (!this.customization.isOptionValid(option)) {
                desc = ClientProxyInterface.proxy.localize("grapplemodifier.incompatability.desc") + "\n" + desc;
                enabled = false;
            }
            int level = this.customization.optionEnabled(option);
            if (this.getLimits() < level) {
                desc = level == 1 ? ClientProxyInterface.proxy.localize("grapplemodifier.limits.desc") + "\n" + desc : ClientProxyInterface.proxy.localize("grapplemodifier.locked.desc") + "\n" + desc;
                enabled = false;
            }
            b.field_230693_o_ = enabled;
            if (b instanceof GuiSlider) {
                ((GuiSlider)b).tooltip = new StringTextComponent(desc);
                b.func_230986_a_(enabled ? 1.0f : 0.5f);
            }
            if (!(b instanceof GuiCheckbox)) continue;
            ((GuiCheckbox)b).tooltip = new StringTextComponent(desc);
            b.func_230986_a_(enabled ? 1.0f : 0.5f);
        }
    }

    public int getLimits() {
        if (this.tileEnt.isUnlocked(GrappleCustomization.upgradeCategories.LIMITS) || Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            return 1;
        }
        return 0;
    }

    class GuiSlider
    extends AbstractSlider {
        double min;
        double max;
        double val;
        String text;
        String option;
        public ITextComponent tooltip;

        public GuiSlider(int x, int y, int w, int h, ITextComponent text, double min, double max, double val, String option, ITextComponent tooltip) {
            super(x, y, w, h, text, (val - min) / (max - min));
            this.min = min;
            this.max = max;
            this.val = val;
            this.text = text.getString();
            this.option = option;
            this.tooltip = tooltip;
            this.func_230979_b_();
        }

        protected void func_230979_b_() {
            this.func_238482_a_((ITextComponent)new StringTextComponent(this.text + ": " + String.format("%.1f", this.val)));
        }

        protected void func_230972_a_() {
            this.val = this.field_230683_b_ * (this.max - this.min) + this.min;
            GuiModifier.this.customization.setDouble(this.option, this.val);
        }

        public void func_230431_b_(MatrixStack p_230431_1_, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            super.func_230431_b_(p_230431_1_, p_230431_2_, p_230431_3_, p_230431_4_);
            if (this.func_230449_g_()) {
                GuiModifier.this.func_238652_a_(p_230431_1_, this.tooltip, p_230431_2_, p_230431_3_);
            }
        }
    }

    class GuiCheckbox
    extends CheckboxButton {
        String option;
        public ITextComponent tooltip;

        public GuiCheckbox(int x, int y, int w, int h, ITextComponent text, boolean val, String option, ITextComponent tooltip) {
            super(x, y, w, h, text, val);
            this.option = option;
            this.tooltip = tooltip;
        }

        public void func_230930_b_() {
            super.func_230930_b_();
            GuiModifier.this.customization.setBoolean(this.option, this.func_212942_a());
            GuiModifier.this.updateEnabled();
        }

        public void func_230431_b_(MatrixStack p_230431_1_, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            super.func_230431_b_(p_230431_1_, p_230431_2_, p_230431_3_, p_230431_4_);
            if (this.func_230449_g_()) {
                GuiModifier.this.func_238652_a_(p_230431_1_, this.tooltip, p_230431_2_, p_230431_3_);
            }
        }
    }

    class TextWidget
    extends Widget {
        public TextWidget(int p_i232254_1_, int p_i232254_2_, int p_i232254_3_, int p_i232254_4_, ITextComponent p_i232254_5_) {
            super(p_i232254_1_, p_i232254_2_, p_i232254_3_, p_i232254_4_, p_i232254_5_);
        }

        public TextWidget(ITextComponent text, int x, int y) {
            this(x, y, 50, 15 * text.getString().split("\n").length + 5, text);
        }

        public void func_230431_b_(MatrixStack p_230431_1_, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontrenderer = minecraft.field_71466_p;
            minecraft.func_110434_K().func_110577_a(field_230687_i_);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int j = this.getFGColor();
            int lineno = 0;
            for (String s : this.func_230458_i_().getString().split("\n")) {
                TextWidget.func_238475_b_((MatrixStack)p_230431_1_, (FontRenderer)fontrenderer, (ITextComponent)new StringTextComponent(s), (int)this.field_230690_l_, (int)(this.field_230691_m_ + lineno * 15), (int)(j | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24));
                ++lineno;
            }
        }
    }

    class BackgroundWidget
    extends Widget {
        public BackgroundWidget(int p_i232254_1_, int p_i232254_2_, int p_i232254_3_, int p_i232254_4_, ITextComponent p_i232254_5_) {
            super(p_i232254_1_, p_i232254_2_, p_i232254_3_, p_i232254_4_, p_i232254_5_);
            this.field_230693_o_ = false;
        }

        public BackgroundWidget(int x, int y, int w, int h) {
            this(x, y, w, h, (ITextComponent)new StringTextComponent(""));
        }

        public void func_230431_b_(MatrixStack p_230431_1_, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_238474_b_(p_230431_1_, this.field_230690_l_, this.field_230691_m_, 0, 0, this.field_230688_j_, this.field_230689_k_);
        }
    }

    class PressBack
    implements Button.IPressable {
        PressBack() {
        }

        public void onPress(Button p_onPress_1_) {
            GuiModifier.this.mainScreen();
        }
    }

    class PressCategory
    implements Button.IPressable {
        GrappleCustomization.upgradeCategories category;

        public PressCategory(GrappleCustomization.upgradeCategories category) {
            this.category = category;
        }

        public void onPress(Button p_onPress_1_) {
            boolean unlocked;
            boolean bl = unlocked = GuiModifier.this.tileEnt.isUnlocked(this.category) || Minecraft.func_71410_x().field_71439_g.func_184812_l_();
            if (unlocked) {
                GuiModifier.this.showCategoryScreen(this.category);
            } else {
                GuiModifier.this.notAllowedScreen(this.category);
            }
        }
    }
}

