/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.blocks.modifierblock;

import com.yyon.grapplinghook.blocks.modifierblock.TileEntityGrappleModifier;
import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.items.GrapplehookItem;
import com.yyon.grapplinghook.items.upgrades.BaseUpgradeItem;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import com.yyon.grapplinghook.utils.Vec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockGrappleModifier
extends Block {
    public BlockGrappleModifier() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityGrappleModifier();
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder lootctx) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((IItemProvider)this.func_199767_j()));
        TileEntity ent = (TileEntity)lootctx.func_216019_b(LootParameters.field_216288_h);
        if (ent == null || !(ent instanceof TileEntityGrappleModifier)) {
            return drops;
        }
        TileEntityGrappleModifier tileent = (TileEntityGrappleModifier)ent;
        for (GrappleCustomization.upgradeCategories category : GrappleCustomization.upgradeCategories.values()) {
            if (!tileent.unlockedCategories.containsKey((Object)category) || !tileent.unlockedCategories.get((Object)category).booleanValue()) continue;
            drops.add(new ItemStack((IItemProvider)category.getItem()));
        }
        return drops;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult raytraceresult) {
        ItemStack helditemstack = playerIn.func_184586_b(Hand.MAIN_HAND);
        Item helditem = helditemstack.func_77973_b();
        if (helditem instanceof BaseUpgradeItem) {
            if (!worldIn.field_72995_K) {
                TileEntity ent = worldIn.func_175625_s(pos);
                TileEntityGrappleModifier tileent = (TileEntityGrappleModifier)ent;
                GrappleCustomization.upgradeCategories category = ((BaseUpgradeItem)helditem).field_77701_a;
                if (category != null) {
                    if (tileent.isUnlocked(category)) {
                        playerIn.func_145747_a((ITextComponent)new StringTextComponent("Already has upgrade: " + category.getName()), playerIn.func_110124_au());
                    } else {
                        if (!playerIn.func_184812_l_()) {
                            playerIn.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                        tileent.unlockCategory(category);
                        playerIn.func_145747_a((ITextComponent)new StringTextComponent("Applied upgrade: " + category.getName()), playerIn.func_110124_au());
                    }
                }
            }
        } else if (helditem instanceof GrapplehookItem) {
            if (!worldIn.field_72995_K) {
                TileEntity ent = worldIn.func_175625_s(pos);
                TileEntityGrappleModifier tileent = (TileEntityGrappleModifier)ent;
                GrappleCustomization custom = tileent.customization;
                CommonSetup.grapplingHookItem.setCustomOnServer(helditemstack, custom, playerIn);
                playerIn.func_145747_a((ITextComponent)new StringTextComponent("Applied configuration"), playerIn.func_110124_au());
            }
        } else if (helditem == Items.field_151175_af) {
            if (!worldIn.field_72995_K) {
                if (GrappleConfig.getConf().longfallboots.longfallbootsrecipe) {
                    Map enchantments;
                    boolean gaveitem = false;
                    if (helditemstack.func_77948_v() && (enchantments = EnchantmentHelper.func_82781_a((ItemStack)helditemstack)).containsKey(Enchantments.field_180309_e) && (Integer)enchantments.get(Enchantments.field_180309_e) >= 4) {
                        ItemStack newitemstack = new ItemStack((IItemProvider)CommonSetup.longFallBootsItem);
                        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)newitemstack);
                        playerIn.func_184611_a(Hand.MAIN_HAND, newitemstack);
                        gaveitem = true;
                    }
                    if (!gaveitem) {
                        playerIn.func_145747_a((ITextComponent)new StringTextComponent("Right click with diamond boots enchanted with feather falling IV to get long fall boots"), playerIn.func_110124_au());
                    }
                } else {
                    playerIn.func_145747_a((ITextComponent)new StringTextComponent("Making long fall boots this way was disabled in the config. It probably has been replaced by a crafting recipe."), playerIn.func_110124_au());
                }
            }
        } else if (helditem == Items.field_151045_i) {
            this.easterEgg(state, worldIn, pos, playerIn, hand, raytraceresult);
        } else if (worldIn.field_72995_K) {
            TileEntity ent = worldIn.func_175625_s(pos);
            TileEntityGrappleModifier tileent = (TileEntityGrappleModifier)ent;
            ClientProxyInterface.proxy.openModifierScreen(tileent);
        }
        return ActionResultType.SUCCESS;
    }

    public void easterEgg(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult raytraceresult) {
        int spacing = 3;
        Vec[] positions = new Vec[]{new Vec(-spacing * 2, 0.0, 0.0), new Vec(-spacing, 0.0, 0.0), new Vec(0.0, 0.0, 0.0), new Vec(spacing, 0.0, 0.0), new Vec(2 * spacing, 0.0, 0.0)};
        int[] colors = new int[]{6017018, 16100281, 0xFFFFFF, 16100281, 6017018};
        for (int i = 0; i < positions.length; ++i) {
            Vec newpos = new Vec((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
            Vec toPlayer = Vec.positionVec((Entity)playerIn).sub(newpos);
            double angle = toPlayer.length() == 0.0 ? 0.0 : toPlayer.getYaw();
            newpos = newpos.add(positions[i].rotateYaw(Math.toRadians(angle)));
            CompoundNBT explosion = new CompoundNBT();
            explosion.func_74774_a("Type", (byte)FireworkRocketItem.Shape.SMALL_BALL.func_196071_a());
            explosion.func_74757_a("Trail", true);
            explosion.func_74757_a("Flicker", false);
            explosion.func_74783_a("Colors", new int[]{colors[i]});
            explosion.func_74783_a("FadeColors", new int[0]);
            ListNBT list = new ListNBT();
            list.add((Object)explosion);
            CompoundNBT fireworks = new CompoundNBT();
            fireworks.func_218657_a("Explosions", (INBT)list);
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("Fireworks", (INBT)fireworks);
            ItemStack stack = new ItemStack((IItemProvider)Items.field_196152_dE);
            stack.func_77982_d(nbt);
            FireworkRocketEntity firework = new FireworkRocketEntity(worldIn, (Entity)playerIn, newpos.x, newpos.y, newpos.z, stack);
            CompoundNBT fireworksave = new CompoundNBT();
            firework.func_213281_b(fireworksave);
            fireworksave.func_74768_a("LifeTime", 15);
            firework.func_70037_a(fireworksave);
            worldIn.func_217376_c((Entity)firework);
        }
    }
}

