/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network.clientbound;

import com.yyon.grapplinghook.GrappleMod;
import com.yyon.grapplinghook.client.GrappleModClient;
import com.yyon.grapplinghook.entity.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.entity.grapplehook.SegmentHandler;
import com.yyon.grapplinghook.network.NetworkContext;
import com.yyon.grapplinghook.network.clientbound.BaseMessageClient;
import com.yyon.grapplinghook.util.GrappleCustomization;
import com.yyon.grapplinghook.util.Vec;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class GrappleAttachMessage
extends BaseMessageClient {
    public int id;
    public double x;
    public double y;
    public double z;
    public int controlId;
    public int entityId;
    public class_2338 blockPos;
    public LinkedList<Vec> segments;
    public LinkedList<class_2350> segmentTopSides;
    public LinkedList<class_2350> segmentBottomSides;
    public GrappleCustomization custom;

    public GrappleAttachMessage(class_2540 buf) {
        super(buf);
    }

    public GrappleAttachMessage(int id, double x, double y, double z, int controlid, int entityid, class_2338 blockpos, LinkedList<Vec> segments, LinkedList<class_2350> segmenttopsides, LinkedList<class_2350> segmentbottomsides, GrappleCustomization custom) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.controlId = controlid;
        this.entityId = entityid;
        this.blockPos = blockpos;
        this.segments = segments;
        this.segmentTopSides = segmenttopsides;
        this.segmentBottomSides = segmentbottomsides;
        this.custom = custom;
    }

    @Override
    public void decode(class_2540 buf) {
        this.id = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.controlId = buf.readInt();
        this.entityId = buf.readInt();
        int blockx = buf.readInt();
        int blocky = buf.readInt();
        int blockz = buf.readInt();
        this.blockPos = new class_2338(blockx, blocky, blockz);
        this.custom = new GrappleCustomization();
        this.custom.readFromBuf((ByteBuf)buf);
        int size = buf.readInt();
        this.segments = new LinkedList();
        this.segmentBottomSides = new LinkedList();
        this.segmentTopSides = new LinkedList();
        this.segments.add(new Vec(0.0, 0.0, 0.0));
        this.segmentBottomSides.add(null);
        this.segmentTopSides.add(null);
        for (int i = 1; i < size - 1; ++i) {
            this.segments.add(new Vec(buf.readDouble(), buf.readDouble(), buf.readDouble()));
            this.segmentBottomSides.add((class_2350)buf.method_10818(class_2350.class));
            this.segmentTopSides.add((class_2350)buf.method_10818(class_2350.class));
        }
        this.segments.add(new Vec(0.0, 0.0, 0.0));
        this.segmentBottomSides.add(null);
        this.segmentTopSides.add(null);
    }

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(this.id);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.controlId);
        buf.writeInt(this.entityId);
        buf.writeInt(this.blockPos.method_10263());
        buf.writeInt(this.blockPos.method_10264());
        buf.writeInt(this.blockPos.method_10260());
        this.custom.writeToBuf((ByteBuf)buf);
        buf.writeInt(this.segments.size());
        for (int i = 1; i < this.segments.size() - 1; ++i) {
            buf.writeDouble(this.segments.get((int)i).x);
            buf.writeDouble(this.segments.get((int)i).y);
            buf.writeDouble(this.segments.get((int)i).z);
            buf.method_10817((Enum)this.segmentBottomSides.get(i));
            buf.method_10817((Enum)this.segmentTopSides.get(i));
        }
    }

    @Override
    public class_2960 getChannel() {
        return GrappleMod.id("grapple_attach");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void processMessage(NetworkContext ctx) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            GrappleMod.LOGGER.warn("Network Message received in invalid context (World not present | GrappleAttach)");
            return;
        }
        class_1297 class_12972 = world.method_8469(this.id);
        if (class_12972 instanceof GrapplehookEntity) {
            GrapplehookEntity grapple = (GrapplehookEntity)class_12972;
            grapple.clientAttach(this.x, this.y, this.z);
            SegmentHandler segmenthandler = grapple.segmentHandler;
            segmenthandler.segments = this.segments;
            segmenthandler.segmentBottomSides = this.segmentBottomSides;
            segmenthandler.segmentTopSides = this.segmentTopSides;
            class_1297 holder = world.method_8469(this.entityId);
            if (holder == null) {
                GrappleMod.LOGGER.warn("Network Message received in invalid context (Holder does not exist | GrappleAttach)");
                return;
            }
            segmenthandler.forceSetPos(new Vec(this.x, this.y, this.z), Vec.positionVec(holder));
        }
        GrappleModClient.get().createControl(this.controlId, this.id, this.entityId, (class_1937)world, new Vec(this.x, this.y, this.z), this.blockPos, this.custom);
    }
}

