/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.entity.grapplehook;

import com.yyon.grapplinghook.entity.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.entity.grapplehook.SegmentHandler;
import com.yyon.grapplinghook.util.Vec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_811;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class GrapplehookEntityRenderer<T extends GrapplehookEntity>
extends class_897<T> {
    public static final Vector3f X_AXIS = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f Y_AXIS = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f Z_AXIS = new Vector3f(0.0f, 0.0f, 1.0f);
    protected static final boolean RENDER_GRAPPLE_HOOK = true;
    protected final class_1792 item;
    private static final class_2960 HOOK_TEXTURES = new class_2960("grapplemod", "textures/entity/hook.png");
    private static final class_2960 ROPE_TEXTURES = new class_2960("grapplemod", "textures/entity/rope.png");
    private static final class_1921 ROPE_RENDER = class_1921.method_23572((class_2960)ROPE_TEXTURES);
    class_5617.class_5618 context;

    public GrapplehookEntityRenderer(class_5617.class_5618 context, class_1792 itemIn) {
        super(context);
        this.item = itemIn;
        this.context = context;
    }

    public void render(T hookEntity, float entityYaw, float partialTicks, class_4587 matrix, class_4597 rendertype, int packedLight) {
        Vec hand_offset;
        if (hookEntity == null || !hookEntity.method_5805()) {
            return;
        }
        SegmentHandler segmenthandler = ((GrapplehookEntity)hookEntity).segmentHandler;
        class_1309 e = (class_1309)((GrapplehookEntity)hookEntity).shootingEntity;
        if (e == null || !e.method_5805()) {
            return;
        }
        int hand_right = (e.method_6068() == class_1306.field_6183 ? 1 : -1) * (((GrapplehookEntity)hookEntity).rightHand ? 1 : -1);
        float f = e.method_6055(partialTicks);
        float f1 = class_3532.method_15374((float)(class_3532.method_15355((float)f) * (float)Math.PI));
        if (this.field_4676.field_4692.method_31044().method_31034() && e == class_310.method_1551().field_1724) {
            double d7 = ((Integer)this.field_4676.field_4692.method_41808().method_41753()).intValue();
            hand_offset = new Vec((double)hand_right * -0.46 * (d7 /= 100.0), -0.18 * d7, 0.38).rotatePitch(-f1 * 0.7f).rotateYaw(-f1 * 0.5f).rotatePitch(-Vec.lerp(partialTicks, e.field_6004, e.method_36455()) * 0.01745329238474369).rotateYaw(Vec.lerp(partialTicks, e.field_5982, e.method_36454()) * 0.01745329238474369);
        } else {
            double crouchOffset = e.method_18276() ? -0.1875 : 0.0;
            hand_offset = new Vec((double)hand_right * -0.36, -0.65 + crouchOffset, 0.6).rotatePitch(f1 * 0.7f).rotateYaw(Vec.lerp(partialTicks, e.field_6220, e.field_6283) * 0.01745329238474369);
        }
        hand_offset.y += (double)e.method_5751();
        Vec hand_position = hand_offset.add(Vec.partialPositionVec((class_1297)e, partialTicks));
        Vec attach_dir = Vec.motionVec(hookEntity).mult(-1.0);
        if (attach_dir.length() == 0.0) {
            if (((GrapplehookEntity)hookEntity).attach_dir != null) {
                attach_dir = ((GrapplehookEntity)hookEntity).attach_dir;
            } else if (segmenthandler == null || segmenthandler.segments.size() <= 2) {
                attach_dir = this.getRelativeToEntity((GrapplehookEntity)hookEntity, new Vec(hand_position), partialTicks);
            } else {
                Vec from = segmenthandler.segments.get(1);
                Vec to = Vec.partialPositionVec(hookEntity, partialTicks);
                attach_dir = from.sub(to);
            }
        }
        attach_dir.normalize_ip();
        if (((GrapplehookEntity)hookEntity).attached && ((GrapplehookEntity)hookEntity).attach_dir != null) {
            attach_dir = ((GrapplehookEntity)hookEntity).attach_dir;
        }
        ((GrapplehookEntity)hookEntity).attach_dir = attach_dir;
        matrix.method_22903();
        matrix.method_22905(0.5f, 0.5f, 0.5f);
        matrix.method_22907(new Quaternionf().rotateAxis((float)(-attach_dir.getYaw()), (Vector3fc)Y_AXIS));
        matrix.method_22907(new Quaternionf().rotateAxis((float)attach_dir.getPitch() - 90.0f, (Vector3fc)X_AXIS));
        matrix.method_22907(new Quaternionf().rotateAxis(45.0f * (float)hand_right, (Vector3fc)Y_AXIS));
        matrix.method_22907(new Quaternionf().rotateAxis(-45.0f, (Vector3fc)Z_AXIS));
        class_1799 stack = this.getStackToRender();
        class_1087 bakedmodel = this.context.method_32168().method_4019(stack, hookEntity.method_37908(), null, hookEntity.method_5628());
        this.context.method_32168().method_23179(stack, class_811.field_4315, false, matrix, rendertype, packedLight, class_4608.field_21444, bakedmodel);
        matrix.method_22909();
        matrix.method_22903();
        class_4587.class_4665 matrixstack$entry = matrix.method_23760();
        Matrix4f matrix4f1 = matrixstack$entry.method_23761();
        Matrix3f matrix3f1 = matrixstack$entry.method_23762();
        class_4588 vertexbuffer = rendertype.getBuffer(ROPE_RENDER);
        if (segmenthandler == null) {
            this.drawSegment(new Vec(0.0, 0.0, 0.0), this.getRelativeToEntity((GrapplehookEntity)hookEntity, new Vec(hand_position), partialTicks), 1.0, vertexbuffer, matrix4f1, matrix3f1, packedLight);
        } else {
            for (int i = 0; i < segmenthandler.segments.size() - 1; ++i) {
                Vec from = segmenthandler.segments.get(i);
                Vec to = segmenthandler.segments.get(i + 1);
                if (i == 0) {
                    from = Vec.partialPositionVec(hookEntity, partialTicks);
                }
                if (i + 2 == segmenthandler.segments.size()) {
                    to = hand_position;
                }
                from = this.getRelativeToEntity((GrapplehookEntity)hookEntity, from, partialTicks);
                to = this.getRelativeToEntity((GrapplehookEntity)hookEntity, to, partialTicks);
                double taut = 1.0;
                if (i == segmenthandler.segments.size() - 2) {
                    taut = ((GrapplehookEntity)hookEntity).taut;
                }
                this.drawSegment(from, to, taut, vertexbuffer, matrix4f1, matrix3f1, packedLight);
            }
        }
        Vec hook_pos = Vec.partialPositionVec(hookEntity, partialTicks);
        Vec hand_closest = segmenthandler == null || segmenthandler.segments.size() <= 2 ? hook_pos : segmenthandler.segments.get(segmenthandler.segments.size() - 2);
        Vec diff = hand_closest.sub(hand_position);
        Vec forward = diff.changeLen(1.0);
        Vec up = forward.cross(new Vec(1.0, 0.0, 0.0));
        if (up.length() == 0.0) {
            up = forward.cross(new Vec(0.0, 0.0, 1.0));
        }
        up.changeLen_ip(0.025);
        Vec side = forward.cross(up);
        side.changeLen_ip(0.025);
        Vec[] corners = new Vec[]{up.mult(-1.0).add(side.mult(-1.0)), up.mult(-1.0).add(side), up.add(side), up.add(side.mult(-1.0))};
        float[][] uvs = new float[][]{{0.0f, 0.99f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.99f}};
        for (int size = 0; size < 4; ++size) {
            Vec corner = corners[size];
            Vec normal = corner.normalize();
            Vec cornerpos = this.getRelativeToEntity((GrapplehookEntity)hookEntity, hand_position, partialTicks).add(corner);
            vertexbuffer.method_22918(matrix4f1, (float)cornerpos.x, (float)cornerpos.y, (float)cornerpos.z).method_1336(255, 255, 255, 255).method_22913(uvs[size][0], uvs[size][1]).method_22922(class_4608.field_21444).method_22916(packedLight).method_23763(matrix3f1, (float)normal.x, (float)normal.y, (float)normal.z).method_1344();
        }
        matrix.method_22909();
        super.method_3936(hookEntity, entityYaw, partialTicks, matrix, rendertype, packedLight);
    }

    Vec getRelativeToEntity(GrapplehookEntity hookEntity, Vec inVec, float partialTicks) {
        return inVec.sub(Vec.partialPositionVec((class_1297)hookEntity, partialTicks));
    }

    public void drawSegment(Vec start, Vec finish, double taut, class_4588 vertexbuffer, Matrix4f matrix, Matrix3f matrix3, int p_225623_6_) {
        Vec diff;
        Vec forward;
        Vec up;
        if (start.sub(finish).length() < 0.05) {
            return;
        }
        int number_squares = 16;
        if (taut == 1.0) {
            number_squares = 1;
        }
        if ((up = (forward = (diff = finish.sub(start)).changeLen(1.0)).cross(new Vec(1.0, 0.0, 0.0))).length() == 0.0) {
            up = forward.cross(new Vec(0.0, 0.0, 1.0));
        }
        up.changeLen_ip(0.025);
        Vec side = forward.cross(up);
        side.changeLen_ip(0.025);
        Vec[] corners = new Vec[]{up.mult(-1.0).add(side.mult(-1.0)), up.add(side.mult(-1.0)), up.add(side), up.mult(-1.0).add(side)};
        for (int size = 0; size < 4; ++size) {
            Vec corner1 = corners[size];
            Vec corner2 = corners[(size + 1) % 4];
            Vec normal1 = corner1.normalize();
            Vec normal2 = corner2.normalize();
            for (int square_num = 0; square_num < number_squares; ++square_num) {
                float squarefrac1 = (float)square_num / (float)number_squares;
                Vec pos1 = start.add(diff.mult(squarefrac1));
                pos1.y += -(1.0 - taut) * (0.25 - Math.pow((double)squarefrac1 - 0.5, 2.0)) * 1.5;
                float squarefrac2 = ((float)square_num + 1.0f) / (float)number_squares;
                Vec pos2 = start.add(diff.mult(squarefrac2));
                pos2.y += -(1.0 - taut) * (0.25 - Math.pow((double)squarefrac2 - 0.5, 2.0)) * 1.5;
                Vec corner1pos1 = pos1.add(corner1);
                Vec corner2pos1 = pos1.add(corner2);
                Vec corner1pos2 = pos2.add(corner1);
                Vec corner2pos2 = pos2.add(corner2);
                vertexbuffer.method_22918(matrix, (float)corner1pos1.x, (float)corner1pos1.y, (float)corner1pos1.z).method_1336(255, 255, 255, 255).method_22913(0.0f, squarefrac1).method_22922(class_4608.field_21444).method_22916(p_225623_6_).method_23763(matrix3, (float)normal1.x, (float)normal1.y, (float)normal1.z).method_1344();
                vertexbuffer.method_22918(matrix, (float)corner2pos1.x, (float)corner2pos1.y, (float)corner2pos1.z).method_1336(255, 255, 255, 255).method_22913(1.0f, squarefrac1).method_22922(class_4608.field_21444).method_22916(p_225623_6_).method_23763(matrix3, (float)normal2.x, (float)normal2.y, (float)normal2.z).method_1344();
                vertexbuffer.method_22918(matrix, (float)corner2pos2.x, (float)corner2pos2.y, (float)corner2pos2.z).method_1336(255, 255, 255, 255).method_22913(1.0f, squarefrac2).method_22922(class_4608.field_21444).method_22916(p_225623_6_).method_23763(matrix3, (float)normal2.x, (float)normal2.y, (float)normal2.z).method_1344();
                vertexbuffer.method_22918(matrix, (float)corner1pos2.x, (float)corner1pos2.y, (float)corner1pos2.z).method_1336(255, 255, 255, 255).method_22913(0.0f, squarefrac2).method_22922(class_4608.field_21444).method_22916(p_225623_6_).method_23763(matrix3, (float)normal1.x, (float)normal1.y, (float)normal1.z).method_1344();
            }
        }
    }

    public boolean shouldRender(T entity, class_4604 frustum, double camX, double camY, double camZ) {
        return true;
    }

    public class_1799 getStackToRender() {
        class_1799 stack = new class_1799((class_1935)this.item);
        class_2487 tag = stack.method_7948();
        tag.method_10556("hook", true);
        stack.method_7980(tag);
        return stack;
    }

    @NotNull
    public class_2960 getTextureLocation(T entity) {
        return HOOK_TEXTURES;
    }
}

