/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.controller;

import com.yyon.grapplinghook.GrappleMod;
import com.yyon.grapplinghook.client.GrappleModClient;
import com.yyon.grapplinghook.client.keybind.GrappleKeys;
import com.yyon.grapplinghook.client.keybind.MCKeys;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.entity.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.network.NetworkManager;
import com.yyon.grapplinghook.network.serverbound.GrappleEndMessage;
import com.yyon.grapplinghook.network.serverbound.PlayerMovementMessage;
import com.yyon.grapplinghook.util.GrappleCustomization;
import com.yyon.grapplinghook.util.GrappleModUtils;
import com.yyon.grapplinghook.util.Vec;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;

public class GrappleController {
    public int entityId;
    public class_1937 world;
    public class_1297 entity;
    public HashSet<GrapplehookEntity> grapplehookEntities = new HashSet();
    public HashSet<Integer> grapplehookEntityIds = new HashSet();
    public boolean attached = true;
    public Vec motion;
    public double playerForward = 0.0;
    public double playerStrafe = 0.0;
    public boolean playerJump = false;
    public boolean playerSneak = false;
    public Vec playerMovementUnrotated = new Vec(0.0, 0.0, 0.0);
    public Vec playerMovement = new Vec(0.0, 0.0, 0.0);
    public int onGroundTimer = 0;
    public int maxOnGroundTimer = 3;
    public double maxLen;
    public double playerMovementMult = 0.0;
    public int controllerId;
    public GrappleCustomization custom = null;
    boolean prevOnGround = false;
    public double repelMaxPush = 0.3;
    public boolean rocket_key = false;
    public double rocket_on = 0.0;
    boolean isOnWall = false;
    Vec wallDirection = null;
    class_3965 wallrunRaytraceResult = null;
    int ticksSinceLastWallrunSoundEffect = 0;

    public GrappleController(int grapplehookEntityId, int entityId, class_1937 world, int controllerId, GrappleCustomization custom) {
        this.entityId = entityId;
        this.world = world;
        this.custom = custom;
        if (this.custom != null) {
            this.playerMovementMult = this.custom.playermovementmult;
            this.maxLen = custom.maxlen;
        }
        this.controllerId = controllerId;
        this.entity = world.method_8469(entityId);
        if (this.entity == null) {
            throw new IllegalStateException("Grapple Controller must have a holder entity.");
        }
        this.motion = Vec.motionVec(this.entity);
        Vec newmotion = new Vec(this.entity.method_19538().field_1352 - this.entity.field_6038, this.entity.method_19538().field_1351 - this.entity.field_5971, this.entity.method_19538().field_1350 - this.entity.field_5989);
        if (newmotion.x / this.motion.x < 2.0 && this.motion.x / newmotion.x < 2.0 && newmotion.y / this.motion.y < 2.0 && this.motion.y / newmotion.y < 2.0 && newmotion.z / this.motion.z < 2.0 && this.motion.z / newmotion.z < 2.0) {
            this.motion = newmotion;
        }
        this.onGroundTimer = 0;
        if (grapplehookEntityId != -1) {
            class_1297 grapplehookEntity = world.method_8469(grapplehookEntityId);
            if (grapplehookEntity != null && grapplehookEntity.method_5805() && grapplehookEntity instanceof GrapplehookEntity) {
                this.addHookEntity((GrapplehookEntity)grapplehookEntity);
            } else {
                GrappleMod.LOGGER.warn("no hook entity");
                this.unattach();
            }
        }
        if (custom != null && custom.rocket) {
            GrappleModClient.get().updateRocketRegen(custom.rocket_active_time, custom.rocket_refuel_ratio);
        }
    }

    public void unattach() {
        if (GrappleModClient.get().unregisterController(this.entityId) != null) {
            this.attached = false;
            if (this.controllerId != GrappleModUtils.AIR_FRICTION_ID) {
                NetworkManager.packetToServer(new GrappleEndMessage(this.entityId, this.grapplehookEntityIds));
                GrappleModClient.get().createControl(GrappleModUtils.AIR_FRICTION_ID, -1, this.entityId, this.entity.method_37908(), new Vec(0.0, 0.0, 0.0), null, this.custom);
            }
        }
    }

    public void doClientTick() {
        if (this.attached) {
            if (this.entity == null || !this.entity.method_5805()) {
                this.unattach();
            } else {
                this.updatePlayerPos();
            }
        }
    }

    public void receivePlayerMovementMessage(float strafe, float forward, boolean jump, boolean sneak) {
        this.playerForward = forward;
        this.playerStrafe = strafe;
        this.playerSneak = sneak;
        this.playerMovementUnrotated = new Vec(strafe, 0.0, forward);
        this.playerMovement = this.playerMovementUnrotated.rotateYaw((float)((double)this.entity.method_36454() * (Math.PI / 180)));
    }

    public void updatePlayerPos() {
        class_1297 entity = this.entity;
        if (this.attached && entity != null) {
            if (entity.method_5854() != null) {
                this.unattach();
                this.updateServerPos();
                return;
            }
            this.normalGround(false);
            this.normalCollisions(false);
            this.applyAirFriction();
            Vec playerpos = Vec.positionVec(entity);
            playerpos = playerpos.add(new Vec(0.0, entity.method_5751(), 0.0));
            Object additionalmotion = new Vec(0.0, 0.0, 0.0);
            Vec gravity = new Vec(0.0, -0.05, 0.0);
            this.motion.add_ip(gravity);
            boolean doJump = false;
            double jumpSpeed = 0.0;
            boolean isClimbing = false;
            boolean motor = false;
            if (this.custom.motor) {
                if (GrappleModClient.get().isKeyDown(GrappleKeys.key_motoronoff) && this.custom.motorwhencrouching) {
                    motor = true;
                } else if (!GrappleModClient.get().isKeyDown(GrappleKeys.key_motoronoff) && this.custom.motorwhennotcrouching) {
                    motor = true;
                }
            }
            boolean close = false;
            Vec averagemotiontowards = new Vec(0.0, 0.0, 0.0);
            double min_spherevec_dist = 99999.0;
            for (GrapplehookEntity hookEntity : this.grapplehookEntities) {
                Vec hookPos = Vec.positionVec((class_1297)hookEntity);
                if (this.custom.phaserope) {
                    hookEntity.segmentHandler.updatePos(hookPos, playerpos, hookEntity.r);
                } else {
                    hookEntity.segmentHandler.update(hookPos, playerpos, hookEntity.r, false);
                }
                Vec anchor = hookEntity.segmentHandler.getClosest(hookPos);
                double distToAnchor = hookEntity.segmentHandler.getDistToAnchor();
                double remaininglength = motor ? Math.max(this.custom.maxlen, hookEntity.r) - distToAnchor : hookEntity.r - distToAnchor;
                Vec oldspherevec = playerpos.sub(anchor);
                Vec spherevec = oldspherevec.changeLen(remaininglength);
                Iterator<GrapplehookEntity> spherechange = spherevec.sub(oldspherevec);
                if (spherevec.length() < min_spherevec_dist) {
                    min_spherevec_dist = spherevec.length();
                }
                averagemotiontowards.add_ip(spherevec.changeLen(-1.0));
                if (motor) {
                    hookEntity.r = distToAnchor + oldspherevec.length();
                }
                if (oldspherevec.length() >= remaininglength) {
                    if (oldspherevec.length() - remaininglength > GrappleConfig.getConf().grapplinghook.other.rope_snap_buffer) {
                        this.unattach();
                        this.updateServerPos();
                        return;
                    }
                    additionalmotion = spherechange;
                }
                double dist = oldspherevec.length();
                this.calcTaut(dist, hookEntity);
                if (entity instanceof class_1657) {
                    double timer;
                    class_1657 player = (class_1657)entity;
                    boolean isjumping = GrappleModClient.get().isKeyDown(GrappleKeys.key_jumpanddetach);
                    isjumping = isjumping && !this.playerJump;
                    this.playerJump = GrappleModClient.get().isKeyDown(GrappleKeys.key_jumpanddetach);
                    if (isjumping && this.onGroundTimer >= 0 && (timer = GrappleModClient.get().getTimeSinceLastRopeJump(this.entity.method_37908())) > GrappleConfig.getConf().grapplinghook.other.rope_jump_cooldown_s * 20.0) {
                        doJump = true;
                        jumpSpeed = this.getJumpPower((class_1297)player, spherevec, hookEntity);
                    }
                    if (GrappleModClient.get().isKeyDown(GrappleKeys.key_slow)) {
                        Vec motiontorwards = spherevec.changeLen(-0.1);
                        motiontorwards = new Vec(motiontorwards.x, 0.0, motiontorwards.z);
                        if (this.motion.dot(motiontorwards) < 0.0) {
                            this.motion.add_ip(motiontorwards);
                        }
                        Vec newmotion = this.dampenMotion(this.motion, motiontorwards);
                        this.motion = new Vec(newmotion.x, this.motion.y, newmotion.z);
                    }
                    if ((GrappleModClient.get().isKeyDown(GrappleKeys.key_climb) || GrappleModClient.get().isKeyDown(GrappleKeys.key_climbup) || GrappleModClient.get().isKeyDown(GrappleKeys.key_climbdown)) && !motor) {
                        isClimbing = true;
                        if (anchor.y > playerpos.y) {
                            double climbup = 0.0;
                            if (GrappleModClient.get().isKeyDown(GrappleKeys.key_climb)) {
                                climbup = this.playerForward;
                                if (GrappleModClient.get().isMovingSlowly(this.entity)) {
                                    climbup /= 0.3;
                                }
                                if (climbup > 1.0) {
                                    climbup = 1.0;
                                } else if (climbup < -1.0) {
                                    climbup = -1.0;
                                }
                            } else if (GrappleModClient.get().isKeyDown(GrappleKeys.key_climbup)) {
                                climbup = 1.0;
                            } else if (GrappleModClient.get().isKeyDown(GrappleKeys.key_climbdown)) {
                                climbup = -1.0;
                            }
                            if (climbup != 0.0 && (dist + distToAnchor < this.maxLen || climbup > 0.0 || this.maxLen == 0.0)) {
                                hookEntity.r = dist + distToAnchor;
                                hookEntity.r -= climbup * GrappleConfig.getConf().grapplinghook.other.climb_speed;
                                if (hookEntity.r < distToAnchor) {
                                    hookEntity.r = dist + distToAnchor;
                                }
                                Vec additionalmovementdown = spherevec.changeLen(-climbup * GrappleConfig.getConf().grapplinghook.other.climb_speed).proj(new Vec(0.0, 1.0, 0.0));
                                if (additionalmovementdown.y < 0.0) {
                                    ((Vec)additionalmotion).add_ip(additionalmovementdown);
                                }
                            }
                        }
                    }
                }
                if (dist + distToAnchor < 2.0) {
                    close = true;
                }
                if (!(anchor.sub(playerpos.add(this.motion)).length() > remaininglength)) continue;
                this.motion = this.motion.removeAlong(spherevec);
            }
            averagemotiontowards.changeLen_ip(1.0);
            Vec facing = new Vec(entity.method_5720()).normalize();
            if (motor) {
                double sidewayspull;
                Vec currentsideways;
                Vec sideways;
                Vec facingside;
                Vec facingxy;
                Vec anchor;
                Vec hookPos;
                boolean dopull = true;
                if (this.custom.doublehook && this.grapplehookEntities.size() == 1) {
                    boolean isdouble = true;
                    for (GrapplehookEntity hookEntity : this.grapplehookEntities) {
                        if (hookEntity.isDouble) continue;
                        isdouble = false;
                    }
                    if (isdouble && !this.custom.oneropepull) {
                        dopull = false;
                    }
                }
                Vec totalpull = new Vec(0.0, 0.0, 0.0);
                double accel = this.custom.motoracceleration / (double)this.grapplehookEntities.size();
                double minabssidewayspull = 999.0;
                boolean firstpull = true;
                boolean pullispositive = true;
                boolean pullissameway = true;
                for (GrapplehookEntity hookEntity : this.grapplehookEntities) {
                    hookPos = Vec.positionVec((class_1297)hookEntity);
                    anchor = hookEntity.segmentHandler.getClosest(hookPos);
                    Vec spherevec = playerpos.sub(anchor);
                    Vec pull = spherevec.mult(-1.0);
                    hookEntity.pull = accel;
                    totalpull.add_ip(pull.changeLen(accel));
                    pull.changeLen_ip(hookEntity.pull);
                    if (!(pull.dot(facing) > 0.0) && !this.custom.pullbackwards || !this.custom.smartdoublemotor || this.grapplehookEntities.size() <= 1) continue;
                    facingxy = new Vec(facing.x, 0.0, facing.z);
                    facingside = facingxy.cross(new Vec(0.0, 1.0, 0.0)).normalize();
                    sideways = pull.proj(facingside);
                    currentsideways = this.motion.proj(facingside);
                    sideways.add_ip(currentsideways);
                    sidewayspull = sideways.dot(facingside);
                    if (Math.abs(sidewayspull) < minabssidewayspull) {
                        minabssidewayspull = Math.abs(sidewayspull);
                    }
                    if (firstpull) {
                        firstpull = false;
                        pullispositive = sidewayspull >= 0.0;
                        continue;
                    }
                    if (pullispositive == sidewayspull >= 0.0) continue;
                    pullissameway = false;
                }
                if (this.custom.smartdoublemotor && this.grapplehookEntities.size() > 1) {
                    totalpull = new Vec(0.0, 0.0, 0.0);
                    for (GrapplehookEntity hookEntity : this.grapplehookEntities) {
                        hookPos = Vec.positionVec((class_1297)hookEntity);
                        anchor = hookEntity.segmentHandler.getClosest(hookPos);
                        Vec spherevec = playerpos.sub(anchor);
                        Vec pull = spherevec.mult(-1.0);
                        pull.changeLen_ip(hookEntity.pull);
                        if (pull.dot(facing) > 0.0 || this.custom.pullbackwards) {
                            facingxy = new Vec(facing.x, 0.0, facing.z);
                            facingside = facingxy.cross(new Vec(0.0, 1.0, 0.0)).normalize();
                            sideways = pull.proj(facingside);
                            currentsideways = this.motion.proj(facingside);
                            sideways.add_ip(currentsideways);
                            sidewayspull = sideways.dot(facingside);
                            if (pullissameway) {
                                if (Math.abs(sidewayspull) > minabssidewayspull + 0.05) {
                                    hookEntity.pull = 0.0;
                                }
                            } else {
                                hookEntity.pull = hookEntity.pull * minabssidewayspull / Math.abs(sidewayspull);
                            }
                            totalpull.add_ip(pull.changeLen(hookEntity.pull));
                            continue;
                        }
                        if (!hookEntity.isDouble || this.custom.oneropepull) continue;
                        dopull = false;
                    }
                }
                double pullmult = 1.0;
                if (this.custom.smartmotor && totalpull.y > 0.0 && this.onGroundTimer <= 0 && !entity.method_24828()) {
                    double pulll;
                    Vec pullxzvector = new Vec(totalpull.x, 0.0, totalpull.z);
                    double pullxz = pullxzvector.length();
                    double motionxz = this.motion.proj(pullxzvector).dot(pullxzvector.normalize());
                    double facingxz = facing.proj(pullxzvector).dot(pullxzvector.normalize());
                    pullmult = (facingxz * (this.motion.y + gravity.y) - motionxz * facing.y) / (facing.y * pullxz - facingxz * totalpull.y);
                    if (facing.y * pullxz - facingxz * totalpull.y == 0.0) {
                        pullmult = 9999.0;
                    }
                    if ((pulll = pullmult * totalpull.length()) > this.custom.motoracceleration) {
                        pulll = this.custom.motoracceleration;
                    }
                    if (pulll < 0.0) {
                        pulll = 0.0;
                    }
                    pullmult = pulll / totalpull.length();
                }
                if (this.motion.dot(totalpull) > 0.0 && this.motion.proj(totalpull).length() + totalpull.mult(pullmult).length() > this.custom.motormaxspeed && (pullmult = (this.custom.motormaxspeed - this.motion.proj(totalpull).length()) / totalpull.length()) < 0.0) {
                    pullmult = 0.0;
                }
                if (this.custom.motordampener && totalpull.length() != 0.0) {
                    this.motion = this.dampenMotion(this.motion, totalpull);
                }
                if (dopull) {
                    for (GrapplehookEntity hookEntity : this.grapplehookEntities) {
                        Vec hookPos2 = Vec.positionVec((class_1297)hookEntity);
                        Vec anchor2 = hookEntity.segmentHandler.getClosest(hookPos2);
                        Vec spherevec = playerpos.sub(anchor2);
                        Vec pull = spherevec.mult(-1.0);
                        pull.changeLen_ip(hookEntity.pull * pullmult);
                        if (!(pull.dot(facing) > 0.0) && !this.custom.pullbackwards || !(hookEntity.pull > 0.0)) continue;
                        this.motion.add_ip(pull);
                    }
                }
                if (close && this.grapplehookEntities.size() <= 1 && (entity.field_5976 || entity.field_5992 || entity.method_24828())) {
                    this.motion.mult_ip(0.6);
                }
            }
            if (this.custom.repel) {
                Vec blockpush = this.checkRepel(playerpos, entity.method_37908());
                blockpush.mult_ip(this.custom.repelforce * 0.5);
                blockpush = new Vec(blockpush.x * 0.5, blockpush.y * 2.0, blockpush.z * 0.5);
                this.motion.add_ip(blockpush);
            }
            if (this.custom.rocket) {
                this.motion.add_ip(this.rocket(entity));
            }
            if (!doJump && !isClimbing) {
                this.applyPlayerMovement();
            }
            if (doJump) {
                if (jumpSpeed <= 0.0) {
                    jumpSpeed = 0.0;
                }
                if (jumpSpeed > GrappleConfig.getConf().grapplinghook.other.rope_jump_power) {
                    jumpSpeed = GrappleConfig.getConf().grapplinghook.other.rope_jump_power;
                }
                this.doJump(entity, jumpSpeed, averagemotiontowards, min_spherevec_dist);
                GrappleModClient.get().resetRopeJumpTime(this.entity.method_37908());
                return;
            }
            Vec newmotion = this.motion.add((Vec)additionalmotion);
            if (Double.isNaN(newmotion.x) || Double.isNaN(newmotion.y) || Double.isNaN(newmotion.z)) {
                newmotion = new Vec(0.0, 0.0, 0.0);
                this.motion = new Vec(0.0, 0.0, 0.0);
                GrappleMod.LOGGER.warn("error: motion is NaN");
            }
            entity.method_18800(newmotion.x, newmotion.y, newmotion.z);
            this.updateServerPos();
        }
    }

    public void calcTaut(double dist, GrapplehookEntity hookEntity) {
        if (hookEntity != null) {
            if (dist < hookEntity.r) {
                double taut = 1.0 - (hookEntity.r - dist) / 5.0;
                if (taut < 0.0) {
                    taut = 0.0;
                }
                hookEntity.taut = taut;
            } else {
                hookEntity.taut = 1.0;
            }
        }
    }

    public void normalCollisions(boolean sliding) {
        if (this.entity.field_5976) {
            if (this.entity.method_18798().field_1352 == 0.0 && (!sliding || this.tryStepUp(new Vec(this.motion.x, 0.0, 0.0)))) {
                this.motion.x = 0.0;
            }
            if (this.entity.method_18798().field_1350 == 0.0 && (!sliding || this.tryStepUp(new Vec(0.0, 0.0, this.motion.z)))) {
                this.motion.z = 0.0;
            }
        }
        if (sliding && !this.entity.field_5976) {
            if (this.entity.method_19538().field_1352 - this.entity.field_6038 == 0.0) {
                this.motion.x = 0.0;
            }
            if (this.entity.method_19538().field_1350 - this.entity.field_5989 == 0.0) {
                this.motion.z = 0.0;
            }
        }
        if (this.entity.field_5992) {
            if (this.entity.method_24828()) {
                if (!sliding && class_310.method_1551().field_1690.field_1903.method_1434()) {
                    this.motion.y = this.entity.method_18798().field_1351;
                } else if (this.motion.y < 0.0) {
                    this.motion.y = 0.0;
                }
            } else if (this.motion.y > 0.0 && this.entity.field_5971 == this.entity.method_19538().field_1351) {
                this.motion.y = 0.0;
            }
        }
    }

    public boolean tryStepUp(Vec collisionmotion) {
        if (collisionmotion.length() == 0.0) {
            return false;
        }
        Vec moveoffset = collisionmotion.changeLen(0.05).add(0.0, (double)this.entity.method_49476() + 0.01, 0.0);
        Iterable collisions = this.entity.method_37908().method_8600(this.entity, this.entity.method_5829().method_989(moveoffset.x, moveoffset.y, moveoffset.z));
        if (!collisions.iterator().hasNext()) {
            if (!this.entity.method_24828()) {
                Vec pos = Vec.positionVec(this.entity);
                pos.add_ip(moveoffset);
                pos.setPos(this.entity);
                this.entity.field_6038 = pos.x;
                this.entity.field_5971 = pos.y;
                this.entity.field_5989 = pos.z;
            }
            this.entity.field_5976 = false;
            return false;
        }
        return true;
    }

    public void normalGround(boolean sliding) {
        if (this.entity.method_24828()) {
            this.onGroundTimer = this.maxOnGroundTimer;
        } else if (this.onGroundTimer > 0) {
            --this.onGroundTimer;
        }
        if ((this.entity.method_24828() || this.onGroundTimer > 0) && !sliding) {
            this.motion = Vec.motionVec(this.entity);
            if (GrappleModClient.get().isKeyDown(MCKeys.keyBindJump)) {
                this.motion.y += 0.05;
            }
        }
        this.prevOnGround = this.entity.method_24828();
    }

    private double getJumpPower(class_1297 player, double jumppower) {
        double maxjump = GrappleConfig.getConf().grapplinghook.other.rope_jump_power;
        if (this.onGroundTimer > 0) {
            this.onGroundTimer = 20;
            return 0.0;
        }
        if (player.method_24828()) {
            jumppower = 0.0;
        }
        if (player.field_5976 || player.field_5992) {
            jumppower = maxjump;
        }
        if (jumppower < 0.0) {
            jumppower = 0.0;
        }
        return jumppower;
    }

    public void doJump(class_1297 player, double jumppower, Vec averagemotiontowards, double min_spherevec_dist) {
        if (jumppower > 0.0) {
            if (GrappleConfig.getConf().grapplinghook.other.rope_jump_at_angle && min_spherevec_dist > 1.0) {
                this.motion.add_ip(averagemotiontowards.changeLen(jumppower));
            } else {
                this.motion.y = jumppower > player.method_18798().field_1351 + jumppower ? jumppower : (this.motion.y += jumppower);
            }
            this.motion.setMotion(player);
        }
        this.unattach();
        this.updateServerPos();
    }

    public double getJumpPower(class_1297 player, Vec spherevec, GrapplehookEntity hookEntity) {
        double current_speed;
        double maxjump = GrappleConfig.getConf().grapplinghook.other.rope_jump_power;
        Vec jump = new Vec(0.0, maxjump, 0.0);
        if (spherevec != null && !GrappleConfig.getConf().grapplinghook.other.rope_jump_at_angle) {
            jump = jump.proj(spherevec);
        }
        double jumppower = jump.y;
        if (spherevec != null && spherevec.y > 0.0) {
            jumppower = 0.0;
        }
        if (hookEntity != null && hookEntity.r < 1.0 && player.method_19538().field_1351 < hookEntity.method_19538().field_1351) {
            jumppower = maxjump;
        }
        jumppower = this.getJumpPower(player, jumppower);
        double d = current_speed = GrappleConfig.getConf().grapplinghook.other.rope_jump_at_angle ? -this.motion.distAlong(spherevec) : this.motion.y;
        if (current_speed > 0.0) {
            jumppower -= current_speed;
        }
        if (jumppower < 0.0) {
            jumppower = 0.0;
        }
        return jumppower;
    }

    public Vec dampenMotion(Vec motion, Vec forward) {
        Vec newmotion = motion.proj(forward);
        double dampening = 0.05;
        return newmotion.mult(dampening).add(motion.mult(1.0 - dampening));
    }

    public void updateServerPos() {
        NetworkManager.packetToServer(new PlayerMovementMessage(this.entityId, this.entity.method_19538().field_1352, this.entity.method_19538().field_1351, this.entity.method_19538().field_1350, this.entity.method_18798().field_1352, this.entity.method_18798().field_1351, this.entity.method_18798().field_1350));
    }

    public void receiveGrappleDetach() {
        this.unattach();
    }

    public void receiveEnderLaunch(double x, double y, double z) {
        this.motion.add_ip(x, y, z);
        this.motion.setMotion(this.entity);
    }

    public void applyAirFriction() {
        double dragforce = 0.005f;
        if (this.entity.method_5799() || this.entity.method_5771()) {
            dragforce = 0.25;
        }
        double vel = this.motion.length();
        dragforce = vel * dragforce;
        Vec airfric = new Vec(this.motion.x, this.motion.y, this.motion.z);
        airfric.changeLen_ip(-dragforce);
        this.motion.add_ip(airfric);
    }

    public void applyPlayerMovement() {
        this.motion.add_ip(this.playerMovement.changeLen(0.015 + this.motion.length() * 0.01).mult(this.playerMovementMult));
    }

    public void addHookEntity(GrapplehookEntity hookEntity) {
        this.grapplehookEntities.add(hookEntity);
        hookEntity.r = hookEntity.segmentHandler.getDist(Vec.positionVec((class_1297)hookEntity), Vec.positionVec(this.entity).add(new Vec(0.0, this.entity.method_5751(), 0.0)));
        this.grapplehookEntityIds.add(hookEntity.method_5628());
    }

    public Vec checkRepel(Vec p, class_1937 w) {
        p = p.add(0.0, 0.75, 0.0);
        Vec v = new Vec(0.0, 0.0, 0.0);
        double t = (1.0 + Math.sqrt(5.0)) / 2.0;
        class_2338 pos = class_2338.method_49637((double)p.x, (double)p.y, (double)p.z);
        if (this.hasBlock(pos, w)) {
            v.add_ip(0.0, 1.0, 0.0);
        } else {
            v.add_ip(this.vecDist(p, new Vec(-1.0, t, 0.0), w));
            v.add_ip(this.vecDist(p, new Vec(1.0, t, 0.0), w));
            v.add_ip(this.vecDist(p, new Vec(-1.0, -t, 0.0), w));
            v.add_ip(this.vecDist(p, new Vec(1.0, -t, 0.0), w));
            v.add_ip(this.vecDist(p, new Vec(0.0, -1.0, t), w));
            v.add_ip(this.vecDist(p, new Vec(0.0, 1.0, t), w));
            v.add_ip(this.vecDist(p, new Vec(0.0, 1.0, t), w));
            v.add_ip(this.vecDist(p, new Vec(0.0, -1.0, -t), w));
            v.add_ip(this.vecDist(p, new Vec(0.0, 1.0, -t), w));
            v.add_ip(this.vecDist(p, new Vec(t, 0.0, -1.0), w));
            v.add_ip(this.vecDist(p, new Vec(t, 0.0, 1.0), w));
            v.add_ip(this.vecDist(p, new Vec(-t, 0.0, -1.0), w));
            v.add_ip(this.vecDist(p, new Vec(-t, 0.0, 1.0), w));
        }
        if (v.length() > this.repelMaxPush) {
            v.changeLen_ip(this.repelMaxPush);
        }
        return v;
    }

    public Vec vecDist(Vec p, Vec v, class_1937 w) {
        for (double i = 0.5; i < 10.0; i += 0.5) {
            Vec v2 = v.changeLen(i);
            class_2338 pos = class_2338.method_49637((double)(p.x + v2.x), (double)(p.y + v2.y), (double)(p.z + v2.z));
            if (!this.hasBlock(pos, w)) continue;
            Vec v3 = new Vec((double)pos.method_10263() + 0.5 - p.x, (double)pos.method_10264() + 0.5 - p.y, (double)pos.method_10260() + 0.5 - p.z);
            v3.changeLen_ip(-1.0 / Math.pow(v3.length(), 2.0));
            return v3;
        }
        return new Vec(0.0, 0.0, 0.0);
    }

    public boolean hasBlock(class_2338 pos, class_1937 w) {
        class_2680 blockstate = w.method_8320(pos);
        return !blockstate.method_26215();
    }

    public void receiveGrappleDetachHook(int hookid) {
        if (this.grapplehookEntityIds.contains(hookid)) {
            this.grapplehookEntityIds.remove(hookid);
        } else {
            GrappleMod.LOGGER.warn("Error: controller received hook detach, but hook id not in grapplehookEntityIds");
        }
        GrapplehookEntity hookToRemove = null;
        for (GrapplehookEntity hookEntity : this.grapplehookEntities) {
            if (hookEntity.method_5628() != hookid) continue;
            hookToRemove = hookEntity;
            break;
        }
        if (hookToRemove != null) {
            this.grapplehookEntities.remove(hookToRemove);
        } else {
            GrappleMod.LOGGER.warn("Error: controller received hook detach, but hook entity not in grapplehookEntities");
        }
    }

    public Vec rocket(class_1297 entity) {
        if (GrappleModClient.get().isKeyDown(GrappleKeys.key_rocket)) {
            this.rocket_on = GrappleModClient.get().getRocketFunctioning();
            double rocket_force = this.custom.rocket_force * 0.225 * this.rocket_on;
            double yaw = entity.method_36454();
            double pitch = -entity.method_36455();
            Vec force = new Vec(0.0, 0.0, rocket_force);
            force = force.rotatePitch(Math.toRadians(pitch += this.custom.rocket_vertical_angle));
            force = force.rotateYaw(Math.toRadians(yaw));
            this.rocket_key = true;
            return force;
        }
        this.rocket_key = false;
        this.rocket_on = 0.0;
        return new Vec(0.0, 0.0, 0.0);
    }

    public Vec getNearbyWall(Vec tryfirst, Vec trysecond, double extra) {
        float entitywidth = this.entity.method_17681();
        for (Vec direction : new Vec[]{tryfirst, trysecond, tryfirst.mult(-1.0), trysecond.mult(-1.0)}) {
            class_3965 raytraceresult = GrappleModUtils.rayTraceBlocks(this.entity, this.entity.method_37908(), Vec.positionVec(this.entity), Vec.positionVec(this.entity).add(direction.changeLen((double)(entitywidth / 2.0f) + extra)));
            if (raytraceresult == null) continue;
            this.wallrunRaytraceResult = raytraceresult;
            return direction;
        }
        return null;
    }

    public Vec getWallDirection() {
        Vec tryfirst = new Vec(0.0, 0.0, 0.0);
        Vec trysecond = new Vec(0.0, 0.0, 0.0);
        if (Math.abs(this.motion.x) > Math.abs(this.motion.z)) {
            tryfirst.x = this.motion.x > 0.0 ? 1.0 : -1.0;
            trysecond.z = this.motion.z > 0.0 ? 1.0 : -1.0;
        } else {
            tryfirst.z = this.motion.z > 0.0 ? 1.0 : -1.0;
            trysecond.x = this.motion.x > 0.0 ? 1.0 : -1.0;
        }
        return this.getNearbyWall(tryfirst, trysecond, 0.05);
    }

    public Vec getCorner(int cornernum, Vec facing, Vec sideways) {
        Vec corner = new Vec(0.0, 0.0, 0.0);
        if (cornernum / 2 == 0) {
            corner.add_ip(facing);
        } else {
            corner.add_ip(facing.mult(-1.0));
        }
        if (cornernum % 2 == 0) {
            corner.add_ip(sideways);
        } else {
            corner.add_ip(sideways.mult(-1.0));
        }
        return corner;
    }

    public boolean wallNearby(double dist) {
        float entitywidth = this.entity.method_17681();
        Vec v1 = new Vec((double)(entitywidth / 2.0f) + dist, 0.0, 0.0);
        Vec v2 = new Vec(0.0, 0.0, (double)(entitywidth / 2.0f) + dist);
        for (int i = 0; i < 4; ++i) {
            Vec corner1 = this.getCorner(i, v1, v2);
            Vec corner2 = this.getCorner((i + 1) % 4, v1, v2);
            class_3965 raytraceresult = GrappleModUtils.rayTraceBlocks(this.entity, this.entity.method_37908(), Vec.positionVec(this.entity).add(corner1), Vec.positionVec(this.entity).add(corner2));
            if (raytraceresult == null) continue;
            return true;
        }
        return false;
    }

    public boolean isWallRunning() {
        double current_speed = Math.sqrt(Math.pow(this.motion.x, 2.0) + Math.pow(this.motion.z, 2.0));
        if (current_speed <= GrappleConfig.getConf().enchantments.wallrun.wallrun_min_speed) {
            this.isOnWall = false;
            return false;
        }
        if (this.isOnWall) {
            GrappleModClient.get().setWallrunTicks(GrappleModClient.get().getWallrunTicks() + 1);
        }
        if ((double)GrappleModClient.get().getWallrunTicks() < GrappleConfig.getConf().enchantments.wallrun.max_wallrun_time * 40.0) {
            if (!this.playerSneak) {
                if (this.isOnWall && !this.entity.method_24828() && this.entity.field_5976) {
                    return !(this.entity instanceof class_1309) || !((class_1309)this.entity).method_6101();
                }
                if (GrappleModClient.get().isWallRunning(this.entity, this.motion)) {
                    this.isOnWall = true;
                    return true;
                }
            }
            this.isOnWall = false;
        }
        if (GrappleModClient.get().getWallrunTicks() > 0 && (this.entity.method_24828() || !this.entity.field_5976 && !this.wallNearby(0.2))) {
            this.ticksSinceLastWallrunSoundEffect = 0;
        }
        return false;
    }

    public boolean applyWallrun() {
        boolean wallrun = this.isWallRunning();
        if (this.playerJump) {
            if (wallrun) {
                return false;
            }
            this.playerJump = false;
        }
        if (wallrun && !GrappleModClient.get().isKeyDown(GrappleKeys.key_jumpanddetach)) {
            double vel;
            double dragforce;
            Vec wallside = this.getWallDirection();
            if (wallside != null) {
                this.wallDirection = wallside;
            }
            if (this.wallDirection == null) {
                return false;
            }
            if (!this.playerJump) {
                this.motion.y = 0.0;
            }
            if ((dragforce = GrappleConfig.getConf().enchantments.wallrun.wallrun_drag) > (vel = this.motion.length())) {
                dragforce = vel;
            }
            Vec wallfric = new Vec(this.motion);
            if (wallside != null) {
                wallfric.removeAlong(wallside);
            }
            wallfric.changeLen_ip(-dragforce);
            this.motion.add_ip(wallfric);
            ++this.ticksSinceLastWallrunSoundEffect;
            if ((double)this.ticksSinceLastWallrunSoundEffect > GrappleConfig.getClientConf().sounds.wallrun_sound_effect_time_s * 20.0 * GrappleConfig.getConf().enchantments.wallrun.wallrun_max_speed / (vel + 1.0E-8) && this.wallrunRaytraceResult != null) {
                class_2338 blockpos = this.wallrunRaytraceResult.method_17777();
                class_2680 blockState = this.entity.method_37908().method_8320(blockpos);
                class_2248 blockIn = blockState.method_26204();
                class_2498 soundtype = blockIn.method_9573(blockState);
                this.entity.method_5783(soundtype.method_10594(), soundtype.method_10597() * 0.3f * GrappleConfig.getClientConf().sounds.wallrun_sound_volume, soundtype.method_10599());
                this.ticksSinceLastWallrunSoundEffect = 0;
            }
        }
        boolean isjumping = GrappleModClient.get().isKeyDown(GrappleKeys.key_jumpanddetach) && this.isOnWall;
        isjumping = isjumping && !this.playerJump;
        boolean bl = this.playerJump = GrappleModClient.get().isKeyDown(GrappleKeys.key_jumpanddetach) && this.isOnWall;
        if (isjumping && wallrun) {
            GrappleModClient.get().setWallrunTicks(0);
            Vec jump = new Vec(0.0, GrappleConfig.getConf().enchantments.wallrun.wall_jump_up, 0.0);
            if (this.wallDirection != null) {
                jump.add_ip(this.wallDirection.mult(-GrappleConfig.getConf().enchantments.wallrun.wall_jump_side));
            }
            this.motion.add_ip(jump);
            wallrun = false;
            GrappleModClient.get().playWallrunJumpSound();
        }
        return wallrun;
    }

    public Vec wallrunPressAgainstWall() {
        if (this.wallDirection != null) {
            return this.wallDirection.changeLen(0.05);
        }
        return new Vec(0.0, 0.0, 0.0);
    }

    public void doubleJump() {
        if (-this.motion.y > GrappleConfig.getConf().enchantments.doublejump.dont_doublejump_if_falling_faster_than) {
            return;
        }
        if (this.motion.y < 0.0 && !GrappleConfig.getConf().enchantments.doublejump.doublejump_relative_to_falling) {
            this.motion.y = 0.0;
        }
        this.motion.y += GrappleConfig.getConf().enchantments.doublejump.doublejumpforce;
        this.motion.setMotion(this.entity);
        this.entity.method_38785();
    }

    public void applySlidingFriction() {
        double dragforce = GrappleConfig.getConf().enchantments.slide.sliding_friction;
        if (dragforce > this.motion.length()) {
            dragforce = this.motion.length();
        }
        Vec airfric = new Vec(this.motion.x, this.motion.y, this.motion.z);
        airfric.changeLen_ip(-dragforce);
        this.motion.add_ip(airfric);
    }

    public void slidingJump() {
        this.motion.y = GrappleConfig.getConf().enchantments.slide.slidingjumpforce;
    }
}

