/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.client;

import com.yyon.grapplinghook.GrappleMod;
import com.yyon.grapplinghook.client.GrappleModClient;
import com.yyon.grapplinghook.client.keybind.GrappleModKeyBindings;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.controller.AirfrictionController;
import com.yyon.grapplinghook.controller.ForcefieldController;
import com.yyon.grapplinghook.controller.GrappleController;
import com.yyon.grapplinghook.enchantment.DoubleJumpEnchantment;
import com.yyon.grapplinghook.enchantment.SlidingEnchantment;
import com.yyon.grapplinghook.enchantment.WallrunEnchantment;
import com.yyon.grapplinghook.entity.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.item.EnderStaffItem;
import com.yyon.grapplinghook.item.GrapplehookItem;
import com.yyon.grapplinghook.util.GrappleCustomization;
import com.yyon.grapplinghook.util.GrappleModUtils;
import com.yyon.grapplinghook.util.Vec;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.class_746;

public class ClientControllerManager {
    public static ClientControllerManager instance;
    public static HashMap<Integer, GrappleController> controllers;
    public static HashMap<class_2338, GrappleController> controllerPos;
    public static long prevRopeJumpTime;
    public HashMap<Integer, Long> enderLaunchTimer = new HashMap();
    public double rocketFuel = 1.0;
    public double rocketIncreaseTick = 0.0;
    public double rocketDecreaseTick = 0.0;
    public int ticksWallRunning = 0;
    private boolean prevJumpButton = false;
    private int ticksSinceLastOnGround = 0;
    private boolean alreadyUsedDoubleJump = false;

    public ClientControllerManager() {
        instance = this;
    }

    public void onClientTick(class_1657 player) {
        long timer;
        if (player.method_24828() || controllers.containsKey(player.method_5628()) && ClientControllerManager.controllers.get((Object)Integer.valueOf((int)player.method_5628())).controllerId == GrappleModUtils.GRAPPLE_ID) {
            this.ticksWallRunning = 0;
        }
        if (this.isWallRunning((class_1297)player, Vec.motionVec((class_1297)player))) {
            Object controller;
            if (!controllers.containsKey(player.method_5628()) && (controller = this.createControl(GrappleModUtils.AIR_FRICTION_ID, -1, player.method_5628(), player.method_37908(), null, null)) != null && ((GrappleController)controller).getWallDirection() == null) {
                ((GrappleController)controller).unattach();
            }
            if (controllers.containsKey(player.method_5628())) {
                this.ticksSinceLastOnGround = 0;
                this.alreadyUsedDoubleJump = false;
            }
        }
        this.checkDoubleJump();
        this.checkSlide(player);
        this.rocketFuel += this.rocketIncreaseTick;
        try {
            for (GrappleController controller : controllers.values()) {
                controller.doClientTick();
            }
        }
        catch (ConcurrentModificationException e) {
            GrappleMod.LOGGER.warn("ConcurrentModificationException caught");
        }
        if (this.rocketFuel > 1.0) {
            this.rocketFuel = 1.0;
        }
        if (player.method_24828() && this.enderLaunchTimer.containsKey(player.method_5628()) && (timer = GrappleModUtils.getTime(player.method_37908()) - this.enderLaunchTimer.get(player.method_5628())) > 10L) {
            this.resetLauncherTime(player.method_5628());
        }
    }

    public void checkSlide(class_1657 player) {
        if (GrappleModKeyBindings.key_slide.method_1434() && !controllers.containsKey(player.method_5628()) && this.isSliding((class_1297)player, Vec.motionVec((class_1297)player))) {
            this.createControl(GrappleModUtils.AIR_FRICTION_ID, -1, player.method_5628(), player.method_37908(), null, null);
        }
    }

    public void launchPlayer(class_1657 player) {
        long previousTime = this.enderLaunchTimer.containsKey(player.method_5628()) ? this.enderLaunchTimer.get(player.method_5628()) : 0L;
        long timer = GrappleModUtils.getTime(player.method_37908()) - previousTime;
        if (timer > (long)GrappleConfig.getConf().enderstaff.ender_staff_recharge) {
            boolean isOffHolding;
            class_1799 mainHandStack = player.method_5998(class_1268.field_5808);
            class_1799 offHandStack = player.method_5998(class_1268.field_5810);
            class_1792 mainHandItem = mainHandStack.method_7909();
            class_1792 offHandItem = offHandStack.method_7909();
            boolean isMainHolding = mainHandItem instanceof EnderStaffItem || mainHandItem instanceof GrapplehookItem;
            boolean bl = isOffHolding = offHandItem instanceof EnderStaffItem || offHandItem instanceof GrapplehookItem;
            if (!isMainHolding && !isOffHolding) {
                return;
            }
            class_1799 usedStack = isMainHolding ? mainHandStack : offHandStack;
            class_1792 usedItem = isMainHolding ? mainHandItem : offHandItem;
            this.enderLaunchTimer.put(player.method_5628(), GrappleModUtils.getTime(player.method_37908()));
            Vec facing = Vec.lookVec((class_1297)player);
            GrappleCustomization custom = null;
            if (usedItem instanceof GrapplehookItem) {
                GrapplehookItem grapple = (GrapplehookItem)usedItem;
                custom = grapple.getCustomization(usedStack);
            }
            if (!controllers.containsKey(player.method_5628())) {
                player.method_24830(false);
                this.createControl(GrappleModUtils.AIR_FRICTION_ID, -1, player.method_5628(), player.method_37908(), null, custom);
            }
            facing.mult_ip(GrappleConfig.getConf().enderstaff.ender_staff_strength);
            ClientControllerManager.receiveEnderLaunch(player.method_5628(), facing.x, facing.y, facing.z);
            GrappleModClient.get().playSound(new class_2960("grapplemod", "enderstaff"), GrappleConfig.getClientConf().sounds.enderstaff_sound_volume * 0.5f);
        }
    }

    public void resetLauncherTime(int playerId) {
        if (this.enderLaunchTimer.containsKey(playerId)) {
            this.enderLaunchTimer.put(playerId, 0L);
        }
    }

    public void updateRocketRegen(double rocketActiveTime, double rocketRefuelRatio) {
        this.rocketDecreaseTick = 0.025 / rocketActiveTime;
        this.rocketIncreaseTick = 0.025 / rocketActiveTime / rocketRefuelRatio;
    }

    public double getRocketFunctioning() {
        this.rocketFuel -= this.rocketIncreaseTick;
        this.rocketFuel -= this.rocketDecreaseTick;
        if (this.rocketFuel >= 0.0) {
            return 1.0;
        }
        this.rocketFuel = 0.0;
        return this.rocketIncreaseTick / this.rocketDecreaseTick / 2.0;
    }

    public boolean isWallRunning(class_1297 entity, Vec motion) {
        if (!entity.field_5976 || entity.method_24828() || entity.method_18276()) {
            return false;
        }
        if (entity instanceof class_1309 && ((class_1309)entity).method_6101()) {
            return false;
        }
        block0: for (class_1799 stack : entity.method_5661()) {
            if (stack == null) continue;
            Map enchantments = class_1890.method_8222((class_1799)stack);
            for (class_1887 enchant : enchantments.keySet()) {
                double currentSpeed;
                if (!(enchant instanceof WallrunEnchantment) || (Integer)enchantments.get(enchant) < 1 || GrappleModKeyBindings.key_jumpanddetach.method_1434() || class_310.method_1551().field_1690.field_1903.method_1434()) continue;
                class_3965 rayTraceResult = GrappleModUtils.rayTraceBlocks(entity, entity.method_37908(), Vec.positionVec(entity), Vec.positionVec(entity).add(new Vec(0.0, -1.0, 0.0)));
                if (rayTraceResult != null || !((currentSpeed = Math.sqrt(Math.pow(motion.x, 2.0) + Math.pow(motion.z, 2.0))) >= GrappleConfig.getConf().enchantments.wallrun.wallrun_min_speed)) continue block0;
                return true;
            }
        }
        return false;
    }

    public void checkDoubleJump() {
        GrappleController grappleController;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (player.method_24828()) {
            this.ticksSinceLastOnGround = 0;
            this.alreadyUsedDoubleJump = false;
        } else {
            ++this.ticksSinceLastOnGround;
        }
        boolean isJumpButtonDown = class_310.method_1551().field_1690.field_1903.method_1434();
        List<Supplier<Boolean>> conditions = List.of(() -> isJumpButtonDown, () -> !this.prevJumpButton, () -> ClientControllerManager.lambda$checkDoubleJump$2((class_1657)player), () -> ClientControllerManager.lambda$checkDoubleJump$3((class_1657)player), () -> this.ticksSinceLastOnGround > 3, () -> this.lambda$checkDoubleJump$5((class_1657)player), () -> !this.alreadyUsedDoubleJump);
        boolean allConditionsMet = GrappleModUtils.and(conditions);
        if (allConditionsMet && !controllers.containsKey(player.method_5628())) {
            this.createControl(GrappleModUtils.AIR_FRICTION_ID, -1, player.method_5628(), player.method_37908(), null, null);
            GrappleModClient.get().playDoubleJumpSound();
            GrappleMod.LOGGER.info("Branch 1");
        }
        if (allConditionsMet && (grappleController = controllers.get(player.method_5628())) instanceof AirfrictionController) {
            AirfrictionController ctrl = (AirfrictionController)grappleController;
            this.alreadyUsedDoubleJump = true;
            ctrl.doubleJump();
            GrappleModClient.get().playDoubleJumpSound();
            GrappleMod.LOGGER.info("Branch 2");
        }
        this.prevJumpButton = isJumpButtonDown;
    }

    public boolean wearingDoubleJumpEnchant(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_31549().field_7479) {
                return false;
            }
        }
        for (class_1799 stack : entity.method_5661()) {
            if (stack == null) continue;
            Map enchantments = class_1890.method_8222((class_1799)stack);
            for (class_1887 enchant : enchantments.keySet()) {
                if (!(enchant instanceof DoubleJumpEnchantment) || (Integer)enchantments.get(enchant) < 1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWearingSlidingEnchant(class_1297 entity) {
        for (class_1799 stack : entity.method_5661()) {
            if (stack == null) continue;
            Map enchantments = class_1890.method_8222((class_1799)stack);
            for (class_1887 enchant : enchantments.keySet()) {
                if (!(enchant instanceof SlidingEnchantment) || (Integer)enchantments.get(enchant) < 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSliding(class_1297 entity, Vec motion) {
        if (entity.method_5799() || entity.method_5771()) {
            return false;
        }
        if (entity.method_24828() && GrappleModKeyBindings.key_slide.method_1434()) {
            double speed;
            if (!ClientControllerManager.isWearingSlidingEnchant(entity)) {
                return false;
            }
            boolean wasSliding = false;
            int id = entity.method_5628();
            GrappleController controller = controllers.get(id);
            if (controller instanceof AirfrictionController) {
                AirfrictionController afc = (AirfrictionController)controller;
                if (afc.wasSliding) {
                    wasSliding = true;
                }
            }
            return (speed = motion.removeAlong(new Vec(0.0, 1.0, 0.0)).length()) > GrappleConfig.getConf().enchantments.slide.sliding_end_min_speed && (wasSliding || speed > GrappleConfig.getConf().enchantments.slide.sliding_min_speed);
        }
        return false;
    }

    public GrappleController createControl(int controllerId, int grapplehookEntityId, int playerId, class_1937 world, class_2338 blockPos, GrappleCustomization custom) {
        GrappleController control;
        block11: {
            GrapplehookEntity g;
            class_1297 class_12972 = world.method_8469(grapplehookEntityId);
            GrapplehookEntity grapplehookEntity = class_12972 instanceof GrapplehookEntity ? (g = (GrapplehookEntity)class_12972) : null;
            boolean multi = custom != null && custom.doublehook;
            GrappleController currentController = controllers.get(playerId);
            if (!(currentController == null || multi && currentController.custom != null && currentController.custom.doublehook)) {
                currentController.unattach();
            }
            try {
                if (controllerId == GrappleModUtils.GRAPPLE_ID) {
                    if (!multi) {
                        control = new GrappleController(grapplehookEntityId, playerId, world, controllerId, custom);
                    } else {
                        control = controllers.get(playerId);
                        GrappleController finalControl = control;
                        List<Supplier<Boolean>> conditions = List.of(() -> finalControl != null, () -> finalControl.getClass().equals(GrappleController.class), () -> finalControl.custom.doublehook, () -> grapplehookEntity != null);
                        if (GrappleModUtils.and(conditions)) {
                            control.addHookEntity(grapplehookEntity);
                            return control;
                        }
                        control = new GrappleController(grapplehookEntityId, playerId, world, controllerId, custom);
                    }
                    break block11;
                }
                if (controllerId == GrappleModUtils.REPEL_ID) {
                    control = new ForcefieldController(grapplehookEntityId, playerId, world, controllerId);
                    break block11;
                }
                if (controllerId == GrappleModUtils.AIR_FRICTION_ID) {
                    control = new AirfrictionController(grapplehookEntityId, playerId, world, controllerId, custom);
                    break block11;
                }
                return null;
            }
            catch (IllegalStateException err) {
                GrappleMod.LOGGER.warn("Invalid State while creating a grappling hook controller. This may cause problems! Report to 'GrappleMod: Restitched' if the mod acts weird or this is spammed.", (Throwable)err);
                return null;
            }
        }
        if (blockPos != null) {
            controllerPos.put(blockPos, control);
        }
        ClientControllerManager.registerController(playerId, control);
        class_1297 e = world.method_8469(playerId);
        if (e instanceof class_746) {
            class_746 p = (class_746)e;
            control.receivePlayerMovementMessage(p.field_3913.field_3907, p.field_3913.field_3905, p.field_3913.field_3904, p.field_3913.field_3903);
        }
        return control;
    }

    public static void registerController(int entityId, GrappleController controller) {
        if (controllers.containsKey(entityId)) {
            controllers.get(entityId).unattach();
        }
        controllers.put(entityId, controller);
    }

    public static GrappleController unregisterController(int entityId) {
        if (!controllers.containsKey(entityId)) {
            return null;
        }
        GrappleController controller = controllers.get(entityId);
        controllers.remove(entityId);
        class_2338 pos = null;
        for (class_2338 blockpos : controllerPos.keySet()) {
            GrappleController otherController = controllerPos.get(blockpos);
            if (otherController != controller) continue;
            pos = blockpos;
        }
        if (pos != null) {
            controllerPos.remove(pos);
        }
        return controller;
    }

    public static void receiveGrappleDetach(int id) {
        GrappleController controller = controllers.get(id);
        if (controller != null) {
            controller.receiveGrappleDetach();
        }
    }

    public static void receiveGrappleDetachHook(int id, int hookId) {
        GrappleController controller = controllers.get(id);
        if (controller != null) {
            controller.receiveGrappleDetachHook(hookId);
        }
    }

    public static void receiveEnderLaunch(int id, double x, double y, double z) {
        GrappleController controller = controllers.get(id);
        if (controller == null) {
            GrappleMod.LOGGER.warn("Couldn't find controller");
            return;
        }
        controller.receiveEnderLaunch(x, y, z);
    }

    public void startRocket(class_1657 player, GrappleCustomization custom) {
        GrappleController controller;
        if (!custom.rocket) {
            return;
        }
        if (controllers.containsKey(player.method_5628())) {
            controller = controllers.get(player.method_5628());
            if (controller.custom == null || !controller.custom.rocket) {
                if (controller.custom == null) {
                    controller.custom = custom;
                }
                controller.custom.rocket = true;
                controller.custom.rocket_active_time = custom.rocket_active_time;
                controller.custom.rocket_force = custom.rocket_force;
                controller.custom.rocket_refuel_ratio = custom.rocket_refuel_ratio;
                this.updateRocketRegen(custom.rocket_active_time, custom.rocket_refuel_ratio);
            }
        } else {
            controller = this.createControl(GrappleModUtils.AIR_FRICTION_ID, -1, player.method_5628(), player.method_37908(), null, custom);
            if (controller == null) {
                return;
            }
        }
        RocketSound sound = new RocketSound(controller, class_3414.method_47908((class_2960)new class_2960("grapplemod", "rocket")), class_3419.field_15248);
        class_310.method_1551().method_1483().method_4873((class_1113)sound);
    }

    private /* synthetic */ Boolean lambda$checkDoubleJump$5(class_1657 player) {
        return this.wearingDoubleJumpEnchant((class_1297)player);
    }

    private static /* synthetic */ Boolean lambda$checkDoubleJump$3(class_1657 player) {
        return !player.method_5771();
    }

    private static /* synthetic */ Boolean lambda$checkDoubleJump$2(class_1657 player) {
        return !player.method_5799();
    }

    static {
        controllers = new HashMap();
        controllerPos = new HashMap();
        prevRopeJumpTime = 0L;
    }

    public static class RocketSound
    extends class_1101 {
        GrappleController controller;
        boolean stopping = false;
        public float changeSpeed;

        protected RocketSound(GrappleController controller, class_3414 soundEvent, class_3419 soundSource) {
            super(soundEvent, soundSource, class_5819.method_43047());
            this.field_5446 = true;
            this.controller = controller;
            controller.rocket_key = true;
            controller.rocket_on = 1.0;
            this.field_5442 = this.changeSpeed = GrappleConfig.getClientConf().sounds.rocket_sound_volume * 0.5f * 0.2f;
            this.field_5451 = 0;
            this.field_5440 = class_1113.class_1114.field_5478;
            this.field_18936 = false;
        }

        public void method_16896() {
            float diff;
            if (!this.controller.rocket_key || !this.controller.attached) {
                this.stopping = true;
            }
            float targetvolume = (float)this.controller.rocket_on * GrappleConfig.getClientConf().sounds.rocket_sound_volume * 0.5f;
            if (this.stopping) {
                targetvolume = 0.0f;
            }
            float f = (diff = Math.abs(targetvolume - this.field_5442)) > this.changeSpeed ? this.field_5442 + this.changeSpeed * (float)(this.field_5442 > targetvolume ? -1 : 1) : (this.field_5442 = targetvolume);
            if (this.field_5442 == 0.0f && this.stopping) {
                this.method_24876();
            }
            this.field_5439 = this.controller.entity.method_23317();
            this.field_5450 = this.controller.entity.method_23318();
            this.field_5449 = this.controller.entity.method_23321();
        }
    }
}

