/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.gear_core.set;

import com.google.common.collect.HashMultimap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.fzzyhmstrs.fzzy_core.trinket_util.TrinketChecker;
import me.fzzyhmstrs.fzzy_core.trinket_util.TrinketUtil;
import me.fzzyhmstrs.gear_core.interfaces.ActiveGearSetsTracking;
import me.fzzyhmstrs.gear_core.set.GearSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_634;
import net.minecraft.class_6860;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\bG\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ/\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u001f\u0010 \u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b \u0010!J\u001d\u0010%\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u001d\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010(\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001d\u00a2\u0006\u0004\b(\u0010)J-\u00101\u001a\u00020\u00022\u0006\u0010+\u001a\u00020*2\u0006\u0010-\u001a\u00020,2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u001d\u00a2\u0006\u0004\b1\u00102J\u0015\u00103\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b3\u00104J\r\u00105\u001a\u00020\u0002\u00a2\u0006\u0004\b5\u0010\u0004J\r\u00106\u001a\u00020\u0002\u00a2\u0006\u0004\b6\u0010\u0004J\u0017\u00109\u001a\u00020\u00022\u0006\u00108\u001a\u000207H\u0016\u00a2\u0006\u0004\b9\u0010:J\u0015\u0010;\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b;\u00104R\u0014\u0010<\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0014\u0010>\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010=R \u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@R \u0010A\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010@R \u0010C\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070B8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010DR \u0010F\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020E0B8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010D\u00a8\u0006H"}, d2={"Lme/fzzyhmstrs/gear_core/set/GearSets;", "Lnet/fabricmc/fabric/api/resource/SimpleSynchronousResourceReloadListener;", "", "cacheSets", "()V", "Lcom/google/common/collect/HashMultimap;", "Lnet/minecraft/class_1792;", "Lme/fzzyhmstrs/gear_core/set/GearSet;", "getCachedSets", "()Lcom/google/common/collect/HashMultimap;", "Lnet/minecraft/class_2960;", "getFabricId", "()Lnet/minecraft/class_2960;", "id", "getGearSet", "(Lnet/minecraft/class_2960;)Lme/fzzyhmstrs/gear_core/set/GearSet;", "", "getGearSets", "()Ljava/util/Map;", "", "amount", "Lnet/minecraft/class_1282;", "source", "Lnet/minecraft/class_1309;", "entity", "attacker", "processOnAttack", "(FLnet/minecraft/class_1282;Lnet/minecraft/class_1309;Lnet/minecraft/class_1309;)F", "processOnDamaged", "Lnet/minecraft/class_1657;", "playerEntity", "victim", "processOnKilledOther", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_1309;)V", "Lnet/minecraft/class_1268;", "hand", "user", "processOnUse", "(Lnet/minecraft/class_1268;Lnet/minecraft/class_1657;)V", "target", "processPostHit", "(Lnet/minecraft/class_1309;Lnet/minecraft/class_1657;)V", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_2680;", "state", "Lnet/minecraft/class_2338;", "pos", "miner", "processPostMine", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2680;Lnet/minecraft/class_2338;Lnet/minecraft/class_1657;)V", "processTick", "(Lnet/minecraft/class_1309;)V", "registerClient", "registerServer", "Lnet/minecraft/class_3300;", "manager", "reload", "(Lnet/minecraft/class_3300;)V", "updateActiveSets", "ACTIVE_SET_UPDATE", "Lnet/minecraft/class_2960;", "GEAR_SET_SENDER", "cachedSets", "Lcom/google/common/collect/HashMultimap;", "cachedSetsToSend", "", "gearSets", "Ljava/util/Map;", "", "setsToSend", "<init>", "gear_core"})
public final class GearSets
implements SimpleSynchronousResourceReloadListener {
    @NotNull
    public static final GearSets INSTANCE = new GearSets();
    @NotNull
    private static final Map<class_2960, GearSet> gearSets = new LinkedHashMap();
    @NotNull
    private static final HashMultimap<class_1792, GearSet> cachedSets;
    @NotNull
    private static final Map<class_2960, String> setsToSend;
    @NotNull
    private static final HashMultimap<class_2960, class_2960> cachedSetsToSend;
    @NotNull
    private static final class_2960 GEAR_SET_SENDER;
    @NotNull
    private static final class_2960 ACTIVE_SET_UPDATE;

    private GearSets() {
    }

    public final void registerServer() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)this);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register(GearSets::registerServer$lambda-1);
        ServerPlayConnectionEvents.JOIN.register(GearSets::registerServer$lambda-3);
    }

    public final void registerClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)GEAR_SET_SENDER, GearSets::registerClient$lambda-6);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ACTIVE_SET_UPDATE, GearSets::registerClient$lambda-8);
        ItemTooltipCallback.EVENT.register(GearSets::registerClient$lambda-9);
    }

    public void method_14491(@NotNull class_3300 manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Map files = manager.method_14488("gear_core_sets", GearSets::reload$lambda-10);
        Gson gson = new Gson();
        for (Map.Entry mutableEntry : files.entrySet()) {
            try {
                String string;
                Object k;
                BufferedReader reader = ((class_3298)mutableEntry.getValue()).method_43039();
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                System.out.println((Object)("reading set: " + mutableEntry.getKey()));
                Object k2 = mutableEntry.getKey();
                Intrinsics.checkNotNullExpressionValue(k2, (String)"mutableEntry.key");
                class_2960 class_29602 = (class_2960)k2;
                Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
                GearSet gearSet = GearSet.Companion.fromJson(class_29602, json);
                Map<class_2960, Object> map = gearSets;
                Object k3 = mutableEntry.getKey();
                Intrinsics.checkNotNullExpressionValue(k3, (String)"mutableEntry.key");
                map.put((class_2960)k3, gearSet);
                if (FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER) continue;
                map = setsToSend;
                Intrinsics.checkNotNullExpressionValue(mutableEntry.getKey(), (String)"mutableEntry.key");
                Intrinsics.checkNotNullExpressionValue((Object)gson.toJson((JsonElement)json), (String)"gson.toJson(json)");
                map.put((class_2960)k, (GearSet)((Object)string));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        cachedSets.clear();
        cachedSetsToSend.clear();
    }

    private final HashMultimap<class_1792, GearSet> getCachedSets() {
        if (cachedSets.isEmpty() && !gearSets.isEmpty()) {
            this.cacheSets();
        }
        return cachedSets;
    }

    private final void cacheSets() {
        cachedSets.clear();
        cachedSetsToSend.clear();
        System.out.println((Object)"Caching sets");
        for (class_1792 item : class_7923.field_41178) {
            for (GearSet set : gearSets.values()) {
                Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
                if (!set.test(item)) continue;
                cachedSets.put((Object)item, (Object)set);
                if (FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER) continue;
                cachedSetsToSend.put((Object)class_7923.field_41178.method_10221((Object)item), (Object)set.getId());
            }
        }
    }

    @Nullable
    public final GearSet getGearSet(@NotNull class_2960 id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return gearSets.get(id);
    }

    @NotNull
    public final Map<class_2960, GearSet> getGearSets() {
        return gearSets;
    }

    public final void updateActiveSets(@NotNull class_1309 entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        HashMap<GearSet, Integer> oldActiveMap = ((ActiveGearSetsTracking)entity).gear_core_getActiveSets();
        for (GearSet gearSet : oldActiveMap.keySet()) {
            gearSet.removeAttributesFromEntity(entity);
        }
        HashMap<GearSet, Integer> newActiveMap = new HashMap<GearSet, Integer>();
        for (class_1304 slot : class_1304.values()) {
            class_1799 stack = entity.method_6118(slot);
            if (stack.method_7960()) continue;
            Set gearSets = this.getCachedSets().get((Object)stack.method_7909());
            for (GearSet gearSet : gearSets) {
                Integer n = newActiveMap.get(gearSet);
                if (n == null) {
                    n = 0;
                }
                int num = ((Number)n).intValue();
                Map map = newActiveMap;
                Intrinsics.checkNotNullExpressionValue((Object)gearSet, (String)"gearSet");
                map.put(gearSet, num + 1);
            }
        }
        if (TrinketChecker.INSTANCE.getTrinketsLoaded()) {
            List list = TrinketUtil.INSTANCE.getTrinketStacks(entity);
            for (class_1799 stack : list) {
                Set gearSets = this.getCachedSets().get((Object)stack.method_7909());
                for (GearSet gearSet : gearSets) {
                    Integer n = newActiveMap.get(gearSet);
                    if (n == null) {
                        n = 0;
                    }
                    int num = ((Number)n).intValue();
                    Map map = newActiveMap;
                    Intrinsics.checkNotNullExpressionValue((Object)gearSet, (String)"gearSet");
                    map.put(gearSet, num + 1);
                }
            }
        }
        for (Map.Entry entry : newActiveMap.entrySet()) {
            GearSet gearSet = (GearSet)entry.getKey();
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"entry.value");
            gearSet.addAttributesToEntity(entity, ((Number)v).intValue());
        }
        ((ActiveGearSetsTracking)entity).gear_core_setActiveSets(newActiveMap);
        if (entity instanceof class_3222) {
            ServerPlayNetworking.send((class_3222)((class_3222)entity), (class_2960)ACTIVE_SET_UPDATE, (class_2540)PacketByteBufs.create());
        }
    }

    public final void processPostHit(@NotNull class_1309 target, @NotNull class_1657 attacker) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)attacker, (String)"attacker");
        HashMap<GearSet, Integer> activeGearSets = ((ActiveGearSetsTracking)attacker).gear_core_getActiveSets();
        Intrinsics.checkNotNullExpressionValue(activeGearSets, (String)"activeGearSets");
        for (Map.Entry activeGearSet : ((Map)activeGearSets).entrySet()) {
            GearSet gearSet = (GearSet)activeGearSet.getKey();
            Object v = activeGearSet.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"activeGearSet.value");
            gearSet.processPostHit(((Number)v).intValue(), target, attacker);
        }
    }

    public final void processPostMine(@NotNull class_1937 world, @NotNull class_2680 state, @NotNull class_2338 pos, @NotNull class_1657 miner) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)miner, (String)"miner");
        HashMap<GearSet, Integer> activeGearSets = ((ActiveGearSetsTracking)miner).gear_core_getActiveSets();
        Intrinsics.checkNotNullExpressionValue(activeGearSets, (String)"activeGearSets");
        for (Map.Entry activeGearSet : ((Map)activeGearSets).entrySet()) {
            GearSet gearSet = (GearSet)activeGearSet.getKey();
            Object v = activeGearSet.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"activeGearSet.value");
            gearSet.processPostMine(((Number)v).intValue(), world, state, pos, miner);
        }
    }

    public final void processOnUse(@NotNull class_1268 hand, @NotNull class_1657 user) {
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        HashMap<GearSet, Integer> activeGearSets = ((ActiveGearSetsTracking)user).gear_core_getActiveSets();
        Intrinsics.checkNotNullExpressionValue(activeGearSets, (String)"activeGearSets");
        for (Map.Entry activeGearSet : ((Map)activeGearSets).entrySet()) {
            GearSet gearSet = (GearSet)activeGearSet.getKey();
            Object v = activeGearSet.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"activeGearSet.value");
            gearSet.processOnUse(((Number)v).intValue(), hand, user);
        }
    }

    public final float processOnAttack(float amount, @NotNull class_1282 source, @NotNull class_1309 entity, @Nullable class_1309 attacker) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        HashMap<GearSet, Integer> activeGearSets = ((ActiveGearSetsTracking)entity).gear_core_getActiveSets();
        float newAmount = amount;
        Intrinsics.checkNotNullExpressionValue(activeGearSets, (String)"activeGearSets");
        for (Map.Entry activeGearSet : ((Map)activeGearSets).entrySet()) {
            GearSet gearSet = (GearSet)activeGearSet.getKey();
            Object v = activeGearSet.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"activeGearSet.value");
            newAmount = gearSet.processOnAttack(((Number)v).intValue(), newAmount, source, entity, attacker);
        }
        return newAmount;
    }

    public final float processOnDamaged(float amount, @NotNull class_1282 source, @NotNull class_1309 entity, @Nullable class_1309 attacker) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        HashMap<GearSet, Integer> activeGearSets = ((ActiveGearSetsTracking)entity).gear_core_getActiveSets();
        float newAmount = amount;
        Intrinsics.checkNotNullExpressionValue(activeGearSets, (String)"activeGearSets");
        for (Map.Entry activeGearSet : ((Map)activeGearSets).entrySet()) {
            GearSet gearSet = (GearSet)activeGearSet.getKey();
            Object v = activeGearSet.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"activeGearSet.value");
            newAmount = gearSet.processOnDamaged(((Number)v).intValue(), newAmount, source, entity, attacker);
        }
        return newAmount;
    }

    public final void processOnKilledOther(@NotNull class_1657 playerEntity, @Nullable class_1309 victim) {
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        HashMap<GearSet, Integer> activeGearSets = ((ActiveGearSetsTracking)playerEntity).gear_core_getActiveSets();
        Intrinsics.checkNotNullExpressionValue(activeGearSets, (String)"activeGearSets");
        for (Map.Entry activeGearSet : ((Map)activeGearSets).entrySet()) {
            GearSet gearSet = (GearSet)activeGearSet.getKey();
            Object v = activeGearSet.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"activeGearSet.value");
            gearSet.processOnKilledOther(((Number)v).intValue(), playerEntity, victim);
        }
    }

    public final void processTick(@NotNull class_1309 entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        HashMap<GearSet, Integer> activeGearSets = ((ActiveGearSetsTracking)entity).gear_core_getActiveSets();
        Intrinsics.checkNotNullExpressionValue(activeGearSets, (String)"activeGearSets");
        for (Map.Entry activeGearSet : ((Map)activeGearSets).entrySet()) {
            GearSet gearSet = (GearSet)activeGearSet.getKey();
            Object v = activeGearSet.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"activeGearSet.value");
            gearSet.processTick(((Number)v).intValue(), entity);
        }
    }

    @NotNull
    public class_2960 getFabricId() {
        return new class_2960("gear_core", "gear_sets_loader");
    }

    /*
     * WARNING - void declaration
     */
    private static final void registerServer$lambda-1(MinecraftServer server, class_6860 class_68602, boolean bl) {
        INSTANCE.getCachedSets();
        int maxIndex = setsToSend.size() - 1;
        for (class_3222 player : server.method_3760().method_14571()) {
            Iterable $this$forEachIndexed$iv = setsToSend.entrySet();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void entry;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Map.Entry entry2 = (Map.Entry)item$iv;
                int index = n;
                boolean bl2 = false;
                class_2540 buf = PacketByteBufs.create();
                buf.method_10812((class_2960)entry.getKey());
                buf.method_10814((String)entry.getValue());
                buf.writeBoolean(index == maxIndex);
                if (index == maxIndex) {
                    buf.writeInt(cachedSetsToSend.asMap().size());
                    for (Map.Entry cachedSet : cachedSetsToSend.asMap().entrySet()) {
                        buf.method_10812((class_2960)cachedSet.getKey());
                        buf.writeInt(((Collection)cachedSet.getValue()).size());
                        for (class_2960 set : (Collection)cachedSet.getValue()) {
                            buf.method_10812(set);
                        }
                    }
                }
                ServerPlayNetworking.send((class_3222)player, (class_2960)GEAR_SET_SENDER, (class_2540)buf);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void registerServer$lambda-3(class_3244 handler, PacketSender packetSender, MinecraftServer minecraftServer) {
        INSTANCE.getCachedSets();
        int maxIndex = setsToSend.size() - 1;
        Iterable $this$forEachIndexed$iv = setsToSend.entrySet();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entry;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Map.Entry entry2 = (Map.Entry)item$iv;
            int index = n;
            boolean bl = false;
            class_2540 buf = PacketByteBufs.create();
            buf.method_10812((class_2960)entry.getKey());
            buf.method_10814((String)entry.getValue());
            buf.writeBoolean(index == maxIndex);
            if (index == maxIndex) {
                buf.writeInt(cachedSetsToSend.asMap().size());
                for (Map.Entry cachedSet : cachedSetsToSend.asMap().entrySet()) {
                    buf.method_10812((class_2960)cachedSet.getKey());
                    buf.writeInt(((Collection)cachedSet.getValue()).size());
                    for (class_2960 set : (Collection)cachedSet.getValue()) {
                        buf.method_10812(set);
                    }
                }
            }
            ServerPlayNetworking.send((class_3222)handler.field_14140, (class_2960)GEAR_SET_SENDER, (class_2540)buf);
        }
    }

    private static final void registerClient$lambda-6$lambda-5(class_2960 $id, String $jsonString, boolean $bl, HashMultimap $syncedCachedSets) {
        try {
            System.out.println((Object)("Parsing Client set " + $id));
            JsonObject json = JsonParser.parseString((String)$jsonString).getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)$id, (String)"id");
            Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
            gearSets.put($id, GearSet.Companion.fromJson($id, json));
            if ($bl) {
                cachedSets.clear();
                for (Map.Entry entry : $syncedCachedSets.entries()) {
                    GearSet set;
                    class_1792 item;
                    if (gearSets.get(entry.getValue()) == null) continue;
                    Object object = class_7923.field_41178.method_10223((class_2960)entry.getKey());
                    class_1792 it = (class_1792)object;
                    boolean bl = false;
                    if ((class_1792)(!Intrinsics.areEqual((Object)it, (Object)class_1802.field_8162) ? object : null) == null) continue;
                    cachedSets.put((Object)item, (Object)set);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final void registerClient$lambda-6(class_310 client, class_634 class_6342, class_2540 buf, PacketSender packetSender) {
        HashMultimap hashMultimap;
        class_2960 id = buf.method_10810();
        String jsonString = buf.method_19772();
        boolean bl = buf.readBoolean();
        if (bl) {
            HashMultimap hashMultimap2 = HashMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)hashMultimap2, (String)"create()");
            HashMultimap hashMap = hashMultimap2;
            int size1 = buf.readInt();
            int i = 1;
            if (i <= size1) {
                while (true) {
                    class_2960 itemId = buf.method_10810();
                    int j = 1;
                    int size2 = buf.readInt();
                    if (j <= size2) {
                        while (true) {
                            class_2960 setId = buf.method_10810();
                            hashMap.put((Object)itemId, (Object)setId);
                            if (j == size2) break;
                            ++j;
                        }
                    }
                    if (i == size1) break;
                    ++i;
                }
            }
            hashMultimap = hashMap;
        } else {
            hashMultimap = HashMultimap.create();
        }
        HashMultimap syncedCachedSets = hashMultimap;
        client.execute(() -> GearSets.registerClient$lambda-6$lambda-5(id, jsonString, bl, syncedCachedSets));
    }

    private static final void registerClient$lambda-8$lambda-7(class_310 $client) {
        class_746 class_7462 = $client.field_1724;
        if (class_7462 == null) {
            return;
        }
        class_746 player = class_7462;
        INSTANCE.updateActiveSets((class_1309)player);
    }

    private static final void registerClient$lambda-8(class_310 client, class_634 class_6342, class_2540 class_25402, PacketSender packetSender) {
        client.execute(() -> GearSets.registerClient$lambda-8$lambda-7(client));
    }

    private static final void registerClient$lambda-9(class_1799 stack, class_1836 context, List tooltip) {
        class_746 class_7462 = class_310.method_1551().field_1724;
        if (class_7462 == null) {
            return;
        }
        class_746 player = class_7462;
        Set displaySets = cachedSets.get((Object)stack.method_7909());
        if (displaySets.isEmpty()) {
            return;
        }
        HashMap<GearSet, Integer> activeSets = ((ActiveGearSetsTracking)player).gear_core_getActiveSets();
        for (GearSet displaySet : displaySets) {
            Integer n = activeSets.get(displaySet);
            if (n == null) {
                n = 0;
            }
            int lvl = ((Number)n).intValue();
            Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Intrinsics.checkNotNullExpressionValue((Object)tooltip, (String)"tooltip");
            displaySet.appendTooltip(lvl, stack, context, tooltip);
        }
    }

    private static final boolean reload$lambda-10(class_2960 path) {
        String string = path.method_12832();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path.path");
        return StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null);
    }

    static {
        HashMultimap hashMultimap = HashMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"create()");
        cachedSets = hashMultimap;
        setsToSend = new LinkedHashMap();
        HashMultimap hashMultimap2 = HashMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashMultimap2, (String)"create()");
        cachedSetsToSend = hashMultimap2;
        GEAR_SET_SENDER = new class_2960("gear_core", "gear_set_sender");
        ACTIVE_SET_UPDATE = new class_2960("gear_core", "active_set_update");
    }
}

