/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.powerpots.pot;

import dev.ftb.powerpots.pot.PotEnergyStorage;
import dev.ftb.powerpots.pot.PotTier;
import java.util.Random;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.util.InventoryUtils;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.BotanyPots;
import net.darkhax.botanypots.block.BlockBotanyPot;
import net.darkhax.botanypots.block.tileentity.TileEntityBotanyPot;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.network.BreakEffectsMessage;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.NotNull;

public class PowerPotTileBase
extends TileEntityBotanyPot {
    private InternalInventoryHandler inventory;
    private final LazyOptional<InternalInventoryHandler> inventoryLazy;
    private final PotEnergyStorage energy;
    private final LazyOptional<PotEnergyStorage> energyLazy;
    @Nullable
    private SoilInfo soil;
    private ItemStack soilStack = ItemStack.field_190927_a;
    @Nullable
    private CropInfo crop;
    private ItemStack cropStack = ItemStack.field_190927_a;
    private int totalGrowthTicks;
    private int currentGrowthTicks;
    private int autoHarvestCooldown;
    private ChunkPos chunkPos;
    private PotTier tier;

    public PowerPotTileBase(PotTier tier) {
        this.tier = tier;
        this.inventory = new InternalInventoryHandler(this);
        this.inventoryLazy = LazyOptional.of(() -> this.inventory);
        this.energy = new PotEnergyStorage(this, (Integer)tier.config.maxEnergy.get());
        this.energyLazy = LazyOptional.of(() -> this.energy);
    }

    public boolean canSetSoil(@Nullable SoilInfo newSoil) {
        return newSoil == null || this.getSoil() == null;
    }

    public void setSoil(@Nullable SoilInfo newSoil, ItemStack stack) {
        this.soil = newSoil;
        this.soilStack = stack;
        this.resetGrowthTime();
        if (!this.field_145850_b.field_72995_K) {
            this.sync(false);
            this.field_145850_b.func_72863_F().func_212863_j_().func_215568_a(this.field_174879_c);
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        this.field_145850_b.func_225524_e_().func_215568_a(this.field_174879_c);
    }

    public boolean canSetCrop(@Nullable CropInfo newCrop) {
        return newCrop == null || this.getSoil() != null && this.getCrop() == null;
    }

    public void setCrop(@Nullable CropInfo newCrop, ItemStack stack) {
        this.crop = newCrop;
        this.cropStack = stack;
        this.resetGrowthTime();
        if (!this.field_145850_b.field_72995_K) {
            this.sync(false);
        }
    }

    @Nullable
    public SoilInfo getSoil() {
        return this.soil;
    }

    @Nullable
    public CropInfo getCrop() {
        return this.crop;
    }

    public int getTotalGrowthTicks() {
        return this.totalGrowthTicks;
    }

    public int getCurrentGrowthTicks() {
        return this.currentGrowthTicks;
    }

    public boolean canHarvest() {
        return this.crop != null && this.getTotalGrowthTicks() > 0 && this.getCurrentGrowthTicks() >= this.getTotalGrowthTicks();
    }

    public void resetGrowthTime() {
        int requiredGrowthTicks = BotanyPotHelper.getRequiredGrowthTicks((CropInfo)this.getCrop(), (SoilInfo)this.getSoil());
        this.totalGrowthTicks = requiredGrowthTicks - (int)((double)requiredGrowthTicks * (Double)this.tier.config.speedModifier.get());
        this.currentGrowthTicks = 0;
        if (this.soil != null) {
            this.soil = BotanyPotHelper.getSoil((ResourceLocation)this.soil.func_199560_c());
            if (this.soil == null) {
                this.crop = null;
            }
        }
        if (this.crop != null) {
            this.crop = BotanyPotHelper.getCrop((ResourceLocation)this.crop.func_199560_c());
        }
        this.autoHarvestCooldown = 5;
        this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        if (!this.field_145850_b.field_72995_K) {
            this.sync(false);
        }
    }

    public void addGrowth(int ticksToGrow) {
        this.currentGrowthTicks += ticksToGrow;
        if (this.currentGrowthTicks > this.totalGrowthTicks) {
            this.currentGrowthTicks = this.totalGrowthTicks;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sync(false);
        }
    }

    public float getGrowthPercent() {
        if (this.totalGrowthTicks == -1 || this.currentGrowthTicks == -1) {
            return 0.0f;
        }
        return (float)this.currentGrowthTicks / (float)this.totalGrowthTicks;
    }

    public void onTileTick() {
        int i;
        IItemHandler foundInventory;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.hasInternalItems() && (foundInventory = InventoryUtils.getInventory((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (Direction)Direction.UP)) != EmptyHandler.INSTANCE) {
            for (i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stackInSlot = this.inventory.getStackInSlot(i);
                ItemStack itemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)foundInventory, (ItemStack)stackInSlot, (boolean)false);
                this.inventory.extractItem(i, stackInSlot.func_190916_E() - itemStack.func_190916_E(), false);
            }
        }
        if (this.hasSoilAndCrop()) {
            if (this.isDoneGrowing()) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
                this.attemptAutoHarvest();
            } else {
                int energyAvailable;
                boolean hasSpace = false;
                for (i = 0; i < this.inventory.getSlots(); ++i) {
                    if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
                    hasSpace = true;
                    break;
                }
                if ((energyAvailable = this.energy.consumeEnergy((Integer)this.tier.config.perTickEnergy.get(), true)) >= (Integer)this.tier.config.perTickEnergy.get() && hasSpace) {
                    this.energy.consumeEnergy((Integer)this.tier.config.perTickEnergy.get(), false);
                    ++this.currentGrowthTicks;
                }
            }
        } else if (this.totalGrowthTicks != -1 || this.currentGrowthTicks != 0) {
            this.resetGrowthTime();
        }
    }

    public boolean hasSoilAndCrop() {
        return this.soil != null && this.crop != null;
    }

    public boolean isDoneGrowing() {
        return this.hasSoilAndCrop() && this.totalGrowthTicks > 0 && this.currentGrowthTicks >= this.totalGrowthTicks;
    }

    private boolean hasInternalItems() {
        boolean hasItems = false;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            hasItems = true;
            break;
        }
        return hasItems;
    }

    private void attemptAutoHarvest() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof BlockBotanyPot && ((BlockBotanyPot)block).isHopper()) {
            if (this.autoHarvestCooldown > 0) {
                --this.autoHarvestCooldown;
                return;
            }
            IItemHandler foundInventory = InventoryUtils.getInventory((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (Direction)Direction.UP);
            if (!this.field_145850_b.field_72995_K) {
                boolean didAutoHarvest = false;
                if (foundInventory != EmptyHandler.INSTANCE) {
                    didAutoHarvest = this.extractToInventory(foundInventory);
                }
                if (!didAutoHarvest) {
                    for (ItemStack item : BotanyPotHelper.generateDrop((Random)this.field_145850_b.field_73012_v, (CropInfo)this.getCrop())) {
                        item.func_190920_e(((Integer)this.tier.config.itemsPerOutput.get()).intValue());
                        for (int i = 0; i < this.inventory.getSlots() && !item.func_190926_b(); ++i) {
                            ItemStack itemStack = this.inventory.internalInsertItem(i, item.func_77946_l(), false);
                            if (itemStack.func_190916_E() >= item.func_190916_E()) continue;
                            item.func_190920_e(itemStack.func_190916_E());
                            didAutoHarvest = true;
                        }
                    }
                }
                if (didAutoHarvest) {
                    this.onCropHarvest();
                    this.resetGrowthTime();
                }
            }
        }
    }

    private boolean extractToInventory(IItemHandler inventory) {
        boolean didExtract = false;
        for (ItemStack item : BotanyPotHelper.generateDrop((Random)this.field_145850_b.field_73012_v, (CropInfo)this.getCrop())) {
            item.func_190920_e(((Integer)this.tier.config.itemsPerOutput.get()).intValue());
            boolean extracted = PowerPotTileBase.extractItemsToInventory(inventory, item);
            if (!extracted || didExtract) continue;
            didExtract = true;
        }
        return didExtract;
    }

    public static boolean extractItemsToInventory(IItemHandler inventory, ItemStack item) {
        boolean didInsert = false;
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            if (!inventory.isItemValid(slot, item) || inventory.insertItem(slot, item, true).func_190916_E() == item.func_190916_E() && (!(inventory instanceof InternalInventoryHandler) || ((InternalInventoryHandler)inventory).internalInsertItem(slot, item, true).func_190916_E() == item.func_190916_E())) continue;
            ItemStack excess = inventory instanceof InternalInventoryHandler ? ((InternalInventoryHandler)inventory).internalInsertItem(slot, item.func_77946_l(), false) : inventory.insertItem(slot, item.func_77946_l(), false);
            if (excess.func_190916_E() < item.func_190916_E()) {
                didInsert = true;
                item.func_190920_e(excess.func_190916_E());
            }
            if (excess.func_190926_b()) break;
        }
        return didInsert;
    }

    public void onCropHarvest() {
        IChunk chunk;
        if (this.hasSoilAndCrop() && (chunk = this.field_145850_b.func_217349_x(this.field_174879_c)) instanceof Chunk) {
            BotanyPots.NETWORK.sendToChunk((Chunk)chunk, (Object)new BreakEffectsMessage(this.field_174879_c, this.crop.getDisplayState()[0].getState()));
        }
        MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.CropGrowEvent.Post(this.field_145850_b, this.field_174879_c, this.getState(), this.getState()));
    }

    public void serialize(CompoundNBT dataTag) {
        if (this.soil != null) {
            dataTag.func_74778_a("Soil", this.soil.func_199560_c().toString());
            if (this.crop != null) {
                dataTag.func_74778_a("Crop", this.crop.func_199560_c().toString());
                dataTag.func_74768_a("GrowthTicks", this.currentGrowthTicks);
            }
        }
        this.energyLazy.ifPresent(e -> dataTag.func_74768_a("energy", e.serializeNBT().func_74762_e("energy")));
        this.inventoryLazy.ifPresent(e -> dataTag.func_218657_a("inventory", (INBT)e.serializeNBT()));
        dataTag.func_218657_a("CropStack", (INBT)this.cropStack.serializeNBT());
        dataTag.func_218657_a("SoilStack", (INBT)this.soilStack.serializeNBT());
    }

    public void deserialize(CompoundNBT dataTag) {
        this.soil = null;
        this.crop = null;
        this.energyLazy.ifPresent(e -> e.deserializeNBT(dataTag));
        this.inventoryLazy.ifPresent(e -> e.deserializeNBT(dataTag));
        if (dataTag.func_74764_b("CropStack")) {
            this.cropStack = ItemStack.func_199557_a((CompoundNBT)dataTag.func_74775_l("CropStack"));
        }
        if (dataTag.func_74764_b("SoilStack")) {
            this.soilStack = ItemStack.func_199557_a((CompoundNBT)dataTag.func_74775_l("SoilStack"));
        }
        if (dataTag.func_74764_b("Soil")) {
            String rawSoilId = dataTag.func_74779_i("Soil");
            ResourceLocation soilId = ResourceLocation.func_208304_a((String)rawSoilId);
            if (soilId != null) {
                SoilInfo foundSoil = BotanyPotHelper.getSoil((ResourceLocation)soilId);
                if (foundSoil != null) {
                    this.soil = foundSoil;
                    if (dataTag.func_74764_b("Crop")) {
                        String rawCropId = dataTag.func_74779_i("Crop");
                        ResourceLocation cropId = ResourceLocation.func_208304_a((String)rawCropId);
                        if (cropId != null) {
                            CropInfo cropInfo = BotanyPotHelper.getCrop((ResourceLocation)cropId);
                            if (cropInfo != null) {
                                this.crop = cropInfo;
                                this.currentGrowthTicks = dataTag.func_74762_e("GrowthTicks");
                                int growthTicksForSoil = this.crop.getGrowthTicksForSoil(this.soil);
                                this.totalGrowthTicks = growthTicksForSoil - (int)((double)growthTicksForSoil * (Double)this.tier.config.speedModifier.get());
                            } else {
                                BotanyPots.LOGGER.error("Botany Pot at {} had a crop of type {} but that crop does not exist. The crop will be discarded.", (Object)this.field_174879_c, (Object)rawCropId);
                            }
                        } else {
                            BotanyPots.LOGGER.error("Botany Pot at {} has an invalid crop Id of {}. The crop will be discarded.", (Object)this.field_174879_c, (Object)rawCropId);
                        }
                    }
                } else {
                    BotanyPots.LOGGER.error("Botany Pot at {} had a soil of type {} which no longer exists. Soil and crop will be discarded.", (Object)this.field_174879_c, (Object)rawSoilId);
                }
            } else {
                BotanyPots.LOGGER.error("Botany Pot at {} has invalid soil type {}. Soil and crop will be discarded.", (Object)this.field_174879_c, (Object)rawSoilId);
            }
        }
    }

    public ItemStack getSoilStack() {
        return this.soilStack;
    }

    public ItemStack getCropStack() {
        return this.cropStack;
    }

    public ChunkPos getChunkPos() {
        if (this.chunkPos == null) {
            this.chunkPos = new ChunkPos(this.field_174879_c);
        }
        return this.chunkPos;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return BotanyPots.CLIENT_CONFIG.getRenderDistance();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyLazy.cast();
        }
        if (!this.func_145837_r() && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryLazy.cast();
        }
        return super.getCapability(cap, side);
    }

    static class InternalInventoryHandler
    extends ItemStackHandler {
        PowerPotTileBase tile;

        public InternalInventoryHandler(PowerPotTileBase tile) {
            super(6);
            this.tile = tile;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack internalInsertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            this.tile.sync(false);
        }
    }
}

