/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.powerpots.pot;

import dev.ftb.powerpots.PowerPots;
import dev.ftb.powerpots.pot.PotTier;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockBotanyPot;
import net.darkhax.botanypots.block.tileentity.TileEntityBotanyPot;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.CapabilityItemHandler;

public class PowerPotBlock
extends BlockBotanyPot
implements IWaterLoggable {
    private final VoxelShape NORTH = Stream.of(Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.func_208617_a((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)6.0, (double)4.0), Block.func_208617_a((double)3.0, (double)1.0, (double)12.0, (double)13.0, (double)6.0, (double)13.0), Block.func_208617_a((double)12.0, (double)1.0, (double)4.0, (double)13.0, (double)6.0, (double)12.0), Block.func_208617_a((double)3.0, (double)1.0, (double)4.0, (double)4.0, (double)6.0, (double)12.0), Block.func_208617_a((double)2.0, (double)0.0, (double)5.0, (double)3.0, (double)2.0, (double)11.0), Block.func_208617_a((double)3.0, (double)0.0, (double)5.0, (double)4.0, (double)1.0, (double)11.0), Block.func_208617_a((double)2.0, (double)2.0, (double)6.0, (double)3.0, (double)4.0, (double)11.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private final VoxelShape SOUTH = Stream.of(Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.func_208617_a((double)3.0, (double)1.0, (double)12.0, (double)13.0, (double)6.0, (double)13.0), Block.func_208617_a((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)6.0, (double)4.0), Block.func_208617_a((double)3.0, (double)1.0, (double)4.0, (double)4.0, (double)6.0, (double)12.0), Block.func_208617_a((double)12.0, (double)1.0, (double)4.0, (double)13.0, (double)6.0, (double)12.0), Block.func_208617_a((double)13.0, (double)0.0, (double)5.0, (double)14.0, (double)2.0, (double)11.0), Block.func_208617_a((double)12.0, (double)0.0, (double)5.0, (double)13.0, (double)1.0, (double)11.0), Block.func_208617_a((double)13.0, (double)2.0, (double)5.0, (double)14.0, (double)4.0, (double)10.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private final VoxelShape EAST = Stream.of(Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.func_208617_a((double)12.0, (double)1.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.func_208617_a((double)3.0, (double)1.0, (double)3.0, (double)4.0, (double)6.0, (double)13.0), Block.func_208617_a((double)4.0, (double)1.0, (double)12.0, (double)12.0, (double)6.0, (double)13.0), Block.func_208617_a((double)4.0, (double)1.0, (double)3.0, (double)12.0, (double)6.0, (double)4.0), Block.func_208617_a((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)2.0, (double)3.0), Block.func_208617_a((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)1.0, (double)4.0), Block.func_208617_a((double)5.0, (double)2.0, (double)2.0, (double)10.0, (double)4.0, (double)3.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private final VoxelShape WEST = Stream.of(Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.func_208617_a((double)3.0, (double)1.0, (double)3.0, (double)4.0, (double)6.0, (double)13.0), Block.func_208617_a((double)12.0, (double)1.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.func_208617_a((double)4.0, (double)1.0, (double)3.0, (double)12.0, (double)6.0, (double)4.0), Block.func_208617_a((double)4.0, (double)1.0, (double)12.0, (double)12.0, (double)6.0, (double)13.0), Block.func_208617_a((double)5.0, (double)0.0, (double)13.0, (double)11.0, (double)2.0, (double)14.0), Block.func_208617_a((double)5.0, (double)0.0, (double)12.0, (double)11.0, (double)1.0, (double)13.0), Block.func_208617_a((double)6.0, (double)2.0, (double)13.0, (double)11.0, (double)4.0, (double)14.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private final PotTier tier;

    public PowerPotBlock(PotTier tile) {
        super(true);
        this.tier = tile;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J, BlockStateProperties.field_208198_y});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        if (state == null) {
            state = this.func_176223_P();
        }
        return (BlockState)((BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a))).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Deprecated
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction value = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        if (value == Direction.NORTH) {
            return this.NORTH;
        }
        if (value == Direction.EAST) {
            return this.EAST;
        }
        if (value == Direction.SOUTH) {
            return this.SOUTH;
        }
        return this.WEST;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction direction, BlockState neighborState, IWorld level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)stateIn.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            level.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)level));
        }
        return super.func_196271_a(stateIn, direction, neighborState, level, currentPos, neighborPos);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity;
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c() && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityBotanyPot) {
            TileEntityBotanyPot pot = (TileEntityBotanyPot)tileEntity;
            if (pot.getSoil() != null) {
                PowerPotBlock.dropItem((ItemStack)pot.getSoilStack(), (World)worldIn, (BlockPos)pos);
            }
            if (pot.getCrop() != null) {
                PowerPotBlock.dropItem((ItemStack)pot.getCropStack(), (World)worldIn, (BlockPos)pos);
            }
            tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(e -> {
                for (int i = 0; i < e.getSlots(); ++i) {
                    if (e.getStackInSlot(i).func_190926_b()) continue;
                    PowerPotBlock.dropItem((ItemStack)e.getStackInSlot(i), (World)worldIn, (BlockPos)pos);
                }
            });
        }
        if (!(!state.hasTileEntity() || state.func_203425_a(newState.func_177230_c()) && newState.hasTileEntity())) {
            worldIn.func_175713_t(pos);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBotanyPot) {
            TileEntityBotanyPot pot = (TileEntityBotanyPot)tile;
            if (player.func_225608_bj_()) {
                CropInfo crop = pot.getCrop();
                if (crop != null) {
                    ItemStack seedStack = pot.getCropStack();
                    if (!seedStack.func_190926_b() && pot.canSetCrop(null)) {
                        pot.setCrop(null, ItemStack.field_190927_a);
                        PowerPotBlock.dropItem((ItemStack)seedStack.func_77946_l(), (World)world, (BlockPos)pos);
                        tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(e -> {
                            for (int i = 0; i < e.getSlots(); ++i) {
                                if (e.getStackInSlot(i).func_190926_b()) continue;
                                PowerPotBlock.dropItem((ItemStack)e.getStackInSlot(i), (World)world, (BlockPos)pos);
                                e.extractItem(i, e.getStackInSlot(i).func_190916_E(), false);
                            }
                        });
                        return ActionResultType.SUCCESS;
                    }
                } else {
                    ItemStack soilStack;
                    SoilInfo soil = pot.getSoil();
                    if (soil != null && !(soilStack = pot.getSoilStack()).func_190926_b() && pot.canSetSoil(null)) {
                        pot.setSoil(null, ItemStack.field_190927_a);
                        PowerPotBlock.dropItem((ItemStack)soilStack.func_77946_l(), (World)world, (BlockPos)pos);
                        return ActionResultType.SUCCESS;
                    }
                }
            } else {
                ItemStack heldItem = player.func_184586_b(hand);
                if (!heldItem.func_190926_b()) {
                    CropInfo cropForStack;
                    if (pot.getSoil() == null) {
                        SoilInfo soilForStack = BotanyPotHelper.getSoilForItem((ItemStack)heldItem);
                        if (soilForStack != null && pot.canSetSoil(soilForStack)) {
                            ItemStack inStack = heldItem.func_77946_l();
                            inStack.func_190920_e(1);
                            pot.setSoil(soilForStack, inStack);
                            if (!player.func_184812_l_()) {
                                heldItem.func_190918_g(1);
                            }
                            return ActionResultType.SUCCESS;
                        }
                    } else if (pot.getCrop() == null && (cropForStack = BotanyPotHelper.getCropForItem((ItemStack)heldItem)) != null && BotanyPotHelper.isSoilValidForCrop((SoilInfo)pot.getSoil(), (CropInfo)cropForStack) && pot.canSetCrop(cropForStack)) {
                        ItemStack inStack = heldItem.func_77946_l();
                        inStack.func_190920_e(1);
                        pot.setCrop(cropForStack, inStack);
                        if (!player.func_184812_l_()) {
                            heldItem.func_190918_g(1);
                        }
                        return ActionResultType.SUCCESS;
                    }
                }
                if (!this.isHopper() && pot.canHarvest()) {
                    pot.onCropHarvest();
                    pot.resetGrowthTime();
                    for (ItemStack stack : BotanyPotHelper.generateDrop((Random)world.field_73012_v, (CropInfo)pot.getCrop())) {
                        PowerPotBlock.dropItem((ItemStack)stack, (World)world, (BlockPos)pos);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.FAIL;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return false;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState myState) {
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return false;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (this.tier == PotTier.MK1) {
            return ((TileEntityType)PowerPots.POWER_TILE_MK1.get()).func_200968_a();
        }
        if (this.tier == PotTier.MK2) {
            return ((TileEntityType)PowerPots.POWER_TILE_MK2.get()).func_200968_a();
        }
        if (this.tier == PotTier.MK3) {
            return ((TileEntityType)PowerPots.POWER_TILE_MK3.get()).func_200968_a();
        }
        return ((TileEntityType)PowerPots.POWER_TILE_MK4.get()).func_200968_a();
    }
}

