/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.powerpots.pot;

import dev.ftb.powerpots.pot.PowerPotTileBase;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;

public class PotEnergyStorage
implements IEnergyStorage,
INBTSerializable<CompoundNBT> {
    private static final String KEY = "energy";
    private int energy = 0;
    private final int capacity;
    private final int maxInOut;
    private final PowerPotTileBase tile;

    public PotEnergyStorage(PowerPotTileBase tile, int capacity) {
        this.capacity = capacity;
        this.maxInOut = capacity;
        this.tile = tile;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a(KEY, this.energy);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.energy = nbt.func_74762_e(KEY);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxInOut, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
            this.tile.sync(false);
        }
        return energyReceived;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public int consumeEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, Math.min(this.maxInOut, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
            this.tile.sync(false);
        }
        return energyExtracted;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public String toString() {
        return "ChargerEnergyStorage{energy=" + this.energy + ", capacity=" + this.capacity + ", maxInOut=" + this.maxInOut + '}';
    }
}

