/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.powerpots;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import dev.ftb.powerpots.PowerPots;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.Item;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeLootTableProvider;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(modid="ftb-power-pots", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PowerPotsData {
    @SubscribeEvent
    public static void dataGenEvent(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            gen.func_200390_a((IDataProvider)new LangGen(gen, "ftb-power-pots", "en_us"));
            gen.func_200390_a((IDataProvider)new ItemModelGens(gen, "ftb-power-pots", event.getExistingFileHelper()));
            gen.func_200390_a((IDataProvider)new BlockStateGen(gen, "ftb-power-pots", event.getExistingFileHelper()));
        }
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new BlockTagGen(gen, event.getExistingFileHelper()));
            gen.func_200390_a((IDataProvider)new RecipesGen(gen));
            gen.func_200390_a((IDataProvider)new LootTableGen(gen));
        }
    }

    private static class LangGen
    extends LanguageProvider {
        public LangGen(DataGenerator gen, String modid, String locale) {
            super(gen, modid, locale);
        }

        protected void addTranslations() {
            this.add("itemGroup.ftb-power-pots", "Power Pots");
            this.addBlock((Supplier)PowerPots.POWER_POT_MK1, "PowerPot MK1");
            this.addBlock((Supplier)PowerPots.POWER_POT_MK2, "PowerPot MK2");
            this.addBlock((Supplier)PowerPots.POWER_POT_MK3, "PowerPot MK3");
            this.addBlock((Supplier)PowerPots.POWER_POT_MK4, "PowerPot MK4");
        }
    }

    private static class ItemModelGens
    extends ItemModelProvider {
        public ItemModelGens(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
            super(generator, modid, existingFileHelper);
        }

        protected void registerModels() {
            this.simpleItem((Supplier<Item>)PowerPots.POWER_POT_MK1_ITEM);
            this.simpleItem((Supplier<Item>)PowerPots.POWER_POT_MK2_ITEM);
            this.simpleItem((Supplier<Item>)PowerPots.POWER_POT_MK3_ITEM);
            this.simpleItem((Supplier<Item>)PowerPots.POWER_POT_MK4_ITEM);
        }

        private void simpleItem(Supplier<Item> item) {
            String path = item.get().getRegistryName().func_110623_a();
            ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path)));
        }
    }

    private static class BlockStateGen
    extends BlockStateProvider {
        public BlockStateGen(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
            super(generator, modid, existingFileHelper);
        }

        protected void registerStatesAndModels() {
            this.block((Supplier<Block>)PowerPots.POWER_POT_MK1, this.modLoc("blocks/t1"));
            this.block((Supplier<Block>)PowerPots.POWER_POT_MK2, this.modLoc("blocks/t2"));
            this.block((Supplier<Block>)PowerPots.POWER_POT_MK3, this.modLoc("blocks/t3"));
            this.block((Supplier<Block>)PowerPots.POWER_POT_MK4, this.modLoc("blocks/t4"));
        }

        private void block(Supplier<Block> block, ResourceLocation texture) {
            this.horizontalBlock(block.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(block.get().getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.ExistingModelFile(this.modLoc("block/power-pot"), this.models().existingFileHelper))).texture("base", texture)).texture("particle", texture));
        }
    }

    private static class BlockTagGen
    extends BlockTagsProvider {
        public BlockTagGen(DataGenerator generatorIn, @Nullable ExistingFileHelper existingFileHelper) {
            super(generatorIn, "ftb-power-pots", existingFileHelper);
        }

        protected void func_200432_c() {
            Tags.IOptionalNamedTag botanyPots = BlockTags.createOptional((ResourceLocation)new ResourceLocation("botanypots:botany_pots"));
            this.func_240522_a_((ITag.INamedTag)botanyPots).func_240534_a_((Object[])new Block[]{(Block)PowerPots.POWER_POT_MK1.get(), (Block)PowerPots.POWER_POT_MK2.get(), (Block)PowerPots.POWER_POT_MK3.get(), (Block)PowerPots.POWER_POT_MK4.get()});
        }
    }

    private static class RecipesGen
    extends RecipeProvider {
        public RecipesGen(DataGenerator generatorIn) {
            super(generatorIn);
        }

        protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        }
    }

    private static class LootTableGen
    extends ForgeLootTableProvider {
        private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> lootTables = Lists.newArrayList((Object[])new Pair[]{Pair.of(BlockLootGen::new, (Object)LootParameterSets.field_216267_h)});

        public LootTableGen(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
            return this.lootTables;
        }
    }

    public static class BlockLootGen
    extends BlockLootTables {
        private final Map<ResourceLocation, LootTable.Builder> tables = Maps.newHashMap();

        protected void addTables() {
            this.func_218492_c((Block)PowerPots.POWER_POT_MK1.get());
            this.func_218492_c((Block)PowerPots.POWER_POT_MK2.get());
            this.func_218492_c((Block)PowerPots.POWER_POT_MK3.get());
            this.func_218492_c((Block)PowerPots.POWER_POT_MK4.get());
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.addTables();
            for (ResourceLocation rs : new ArrayList<ResourceLocation>(this.tables.keySet())) {
                if (rs == LootTables.field_186419_a) continue;
                LootTable.Builder builder = this.tables.remove(rs);
                if (builder == null) {
                    throw new IllegalStateException(String.format("Missing loottable '%s'", rs));
                }
                consumer.accept(rs, builder);
            }
            if (!this.tables.isEmpty()) {
                throw new IllegalStateException("Created block loot tables for non-blocks: " + this.tables.keySet());
            }
        }

        protected void func_218507_a(Block blockIn, LootTable.Builder table) {
            this.tables.put(blockIn.func_220068_i(), table);
        }
    }
}

