/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public final class ShapeMerger {
    private double regionBuildingAxis = Double.NEGATIVE_INFINITY;
    private double faceBuildingAxis = Double.NEGATIVE_INFINITY;
    private Vector3d lastCenterPoint = null;
    private AxisAlignedBB currentBox;
    private final Map<Vector3d, AxisAlignedBB> boxAssignments = Maps.newHashMap();
    private final Multimap<AxisAlignedBB, Vector3d> mergerAssignments = HashMultimap.create();

    public double getRegionBuildingAxisValue() {
        return this.regionBuildingAxis;
    }

    public void setRegionBuildingAxisValue(double regionBuildingAxis) {
        this.regionBuildingAxis = regionBuildingAxis;
    }

    public double getFaceBuildingAxisValue() {
        return this.faceBuildingAxis;
    }

    public void setFaceBuildingAxisValue(double faceBuildingAxis) {
        this.faceBuildingAxis = faceBuildingAxis;
    }

    public AxisAlignedBB getCurrentBox() {
        return this.currentBox;
    }

    public void setCurrentBox(AxisAlignedBB currentBox, Vector3d centerPoint) {
        this.currentBox = currentBox;
        if (currentBox != null) {
            this.boxAssignments.put(centerPoint, currentBox);
            this.mergerAssignments.put((Object)currentBox, (Object)centerPoint);
        }
    }

    public Optional<AxisAlignedBB> getBoxFor(Vector3d target) {
        return Optional.ofNullable(this.boxAssignments.get(target));
    }

    public Optional<Vector3d> getLastCenter() {
        return Optional.ofNullable(this.lastCenterPoint);
    }

    public void onNextEntry(Vector3d lastCenterPoint) {
        this.lastCenterPoint = lastCenterPoint;
    }

    public void expandCurrentBoxTowards(AxisAlignedBB target, Vector3d center) {
        AxisAlignedBB current = this.getCurrentBox();
        if (current == null) {
            throw new IllegalStateException("Can not expand current box, if current is not set.");
        }
        AxisAlignedBB expanded = current.func_111270_a(target);
        Collection currentlyAssignedToCurrent = this.mergerAssignments.removeAll((Object)current);
        currentlyAssignedToCurrent.forEach(v -> this.boxAssignments.put((Vector3d)v, expanded));
        this.mergerAssignments.putAll((Object)expanded, (Iterable)currentlyAssignedToCurrent);
        this.boxAssignments.put(center, expanded);
        this.mergerAssignments.put((Object)expanded, (Object)center);
        this.currentBox = expanded;
    }

    public Collection<AxisAlignedBB> getBoxes() {
        return this.mergerAssignments.keySet();
    }

    public void expandBoxAt(Vector3d neighborCenter, AxisAlignedBB entryData, Vector3d centerPoint) {
        AxisAlignedBB current = this.boxAssignments.get(neighborCenter);
        if (current == null) {
            throw new IllegalStateException(String.format("Can not expand box at: %s, if current is not set.", neighborCenter));
        }
        AxisAlignedBB expanded = current.func_111270_a(entryData);
        Collection currentlyAssignedToCurrent = this.mergerAssignments.removeAll((Object)current);
        currentlyAssignedToCurrent.forEach(v -> this.boxAssignments.put((Vector3d)v, expanded));
        this.mergerAssignments.putAll((Object)expanded, (Iterable)currentlyAssignedToCurrent);
        this.boxAssignments.put(centerPoint, expanded);
        this.mergerAssignments.put((Object)expanded, (Object)centerPoint);
    }

    public boolean mergeNeighbors(Vector3d centerPoint, AxisAlignedBB aabb) {
        for (Direction offsetDirection : Direction.values()) {
            AxisAlignedBB neighborBox;
            Vector3d neighborCenter = centerPoint.func_178787_e(Vector3d.func_237491_b_((Vector3i)offsetDirection.func_176730_m()));
            Optional<AxisAlignedBB> potentialNeighborBox = this.getBoxFor(neighborCenter);
            if (!potentialNeighborBox.isPresent() || !ShapeMerger.areBoxesNeighbors(aabb, neighborBox = potentialNeighborBox.get(), offsetDirection)) continue;
            this.expandBoxAt(neighborCenter, aabb, centerPoint);
            return true;
        }
        return false;
    }

    public static boolean areBoxesNeighbors(AxisAlignedBB l, AxisAlignedBB r, Direction direction) {
        double startOfR;
        double endOfL = ShapeMerger.getDirectionalValue(l, direction);
        if (endOfL != (startOfR = ShapeMerger.getDirectionalValue(r, direction.func_176734_d()))) {
            return false;
        }
        for (Direction d : Direction.values()) {
            if (d.func_176740_k() == direction.func_176740_k() || ShapeMerger.getDirectionalValue(l, d) == ShapeMerger.getDirectionalValue(r, d)) continue;
            return false;
        }
        return true;
    }

    public static double getDirectionalValue(AxisAlignedBB bb, Direction direction) {
        return direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? bb.func_197742_b(direction.func_176740_k()) : bb.func_197745_a(direction.func_176740_k());
    }

    public static Collection<AxisAlignedBB> merge(Collection<BlockPos> positions, BlockPos origin) {
        ShapeMerger merger = new ShapeMerger();
        positions.stream().map(pos -> pos.func_177973_b((Vector3i)origin)).sorted().map(AxisAlignedBB::new).forEachOrdered(aabb -> {
            if (merger.getRegionBuildingAxisValue() != aabb.field_72340_a) {
                merger.setCurrentBox(null, null);
            }
            merger.setRegionBuildingAxisValue(aabb.field_72340_a);
            if (merger.getFaceBuildingAxisValue() != aabb.field_72338_b) {
                merger.setCurrentBox(null, null);
            }
            merger.setFaceBuildingAxisValue(aabb.field_72338_b);
            Optional<Vector3d> previousCenterPoint = merger.getLastCenter();
            Vector3d centerPoint = aabb.func_189972_c();
            merger.onNextEntry(centerPoint);
            Optional<Direction> moveNext = previousCenterPoint.map(v -> {
                Vector3d w = centerPoint.func_178788_d(v);
                BlockPos onPos = new BlockPos(w);
                return Direction.func_218383_a((int)onPos.func_177958_n(), (int)onPos.func_177956_o(), (int)onPos.func_177952_p());
            });
            if (merger.getCurrentBox() != null && moveNext.map(dir -> ShapeMerger.areBoxesNeighbors(merger.getCurrentBox(), aabb, dir)).orElse(false).booleanValue()) {
                merger.expandCurrentBoxTowards((AxisAlignedBB)aabb, centerPoint);
                if (merger.mergeNeighbors(centerPoint, merger.getCurrentBox())) {
                    return;
                }
                return;
            }
            if (merger.mergeNeighbors(centerPoint, (AxisAlignedBB)aabb)) {
                return;
            }
            merger.setCurrentBox((AxisAlignedBB)aabb, centerPoint);
        });
        return merger.getBoxes();
    }
}

