/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgumentProvider;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.EntitySelector;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.util.text.TranslationTextComponent;

public class TeamArgument
implements ArgumentType<TeamArgumentProvider> {
    public static final SimpleCommandExceptionType ALREADY_IN_PARTY = new SimpleCommandExceptionType((Message)new TranslationTextComponent("ftbteams.already_in_party"));
    public static final SimpleCommandExceptionType NOT_IN_PARTY = new SimpleCommandExceptionType((Message)new TranslationTextComponent("ftbteams.not_in_party"));
    public static final DynamicCommandExceptionType TEAM_NOT_FOUND = new DynamicCommandExceptionType(object -> new TranslationTextComponent("ftbteams.team_not_found", new Object[]{object}));
    public static final DynamicCommandExceptionType CANT_EDIT = new DynamicCommandExceptionType(object -> new TranslationTextComponent("ftbteams.cant_edit", new Object[]{object}));
    public static final Dynamic2CommandExceptionType NOT_MEMBER = new Dynamic2CommandExceptionType((a, b) -> new TranslationTextComponent("ftbteams.not_member", new Object[]{a, b}));
    public static final DynamicCommandExceptionType NOT_INVITED = new DynamicCommandExceptionType(object -> new TranslationTextComponent("ftbteams.not_invited", new Object[]{object}));
    public static final SimpleCommandExceptionType OWNER_CANT_LEAVE = new SimpleCommandExceptionType((Message)new TranslationTextComponent("ftbteams.owner_cant_leave"));
    public static final SimpleCommandExceptionType CANT_KICK_OWNER = new SimpleCommandExceptionType((Message)new TranslationTextComponent("ftbteams.cant_kick_owner"));

    public static TeamArgument create() {
        return new TeamArgument();
    }

    public static Team get(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        return ((TeamArgumentProvider)context.getArgument(name, TeamArgumentProvider.class)).getTeam((CommandSource)context.getSource());
    }

    private TeamArgument() {
    }

    public TeamArgumentProvider parse(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '@') {
            EntitySelector selector = new EntitySelectorParser(reader).func_201345_m();
            if (selector.func_197351_b()) {
                throw EntityArgument.field_197100_c.create();
            }
            return new SelectorProvider(selector);
        }
        int i = reader.getCursor();
        while (reader.canRead() && reader.peek() != ' ') {
            reader.skip();
        }
        return new IDProvider(reader.getString().substring(i, reader.getCursor()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder builder) {
        if (commandContext.getSource() instanceof ISuggestionProvider) {
            LinkedHashSet<String> list = new LinkedHashSet<String>();
            if (commandContext.getSource() instanceof CommandSource) {
                if (FTBTeamsAPI.isManagerLoaded()) {
                    for (Team team : FTBTeamsAPI.getManager().getTeams()) {
                        if (team.getType().isPlayer()) continue;
                        list.add(team.getStringID());
                    }
                }
            } else if (ClientTeamManager.INSTANCE != null && !ClientTeamManager.INSTANCE.invalid) {
                for (ClientTeam team : ClientTeamManager.INSTANCE.teamMap.values()) {
                    if (team.getType().isPlayer()) continue;
                    list.add(team.getStringID());
                }
            }
            list.addAll(((ISuggestionProvider)commandContext.getSource()).func_197011_j());
            return ISuggestionProvider.func_197005_b(list, (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }

    private static class IDProvider
    implements TeamArgumentProvider {
        private final String id;

        private IDProvider(String s) {
            this.id = s;
        }

        private CommandSyntaxException error() {
            return TEAM_NOT_FOUND.create((Object)this.id);
        }

        @Override
        public Team getTeam(CommandSource source) throws CommandSyntaxException {
            Team t;
            Team team = FTBTeamsAPI.getManager().getTeamNameMap().get(this.id);
            if (team != null) {
                return team;
            }
            GameProfile profile = source.func_197028_i().func_152358_ax().func_152655_a(this.id);
            if (profile != null && (t = FTBTeamsAPI.getManager().getPlayerTeam(profile.getId())) != null) {
                return t;
            }
            throw this.error();
        }
    }

    private static class SelectorProvider
    implements TeamArgumentProvider {
        private final EntitySelector selector;

        private SelectorProvider(EntitySelector s) {
            this.selector = s;
        }

        @Override
        public Team getTeam(CommandSource source) throws CommandSyntaxException {
            return FTBTeamsAPI.getManager().getPlayerTeam(this.selector.func_197347_c(source));
        }
    }
}

