/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.event.PlayerTransferredTeamOwnershipEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import org.jetbrains.annotations.Nullable;

public class PartyTeam
extends Team {
    UUID owner = Util.field_240973_b_;

    public PartyTeam(TeamManager m) {
        super(m);
    }

    @Override
    public TeamType getType() {
        return TeamType.PARTY;
    }

    @Override
    protected void serializeExtraNBT(CompoundNBT tag) {
        tag.func_74778_a("owner", this.owner.toString());
    }

    @Override
    public void deserializeNBT(CompoundNBT tag) {
        super.deserializeNBT(tag);
        this.owner = UUID.fromString(tag.func_74779_i("owner"));
    }

    @Override
    public TeamRank getHighestRank(UUID playerId) {
        if (this.owner.equals(playerId)) {
            return TeamRank.OWNER;
        }
        return super.getHighestRank(playerId);
    }

    public boolean isOwner(UUID profile) {
        return this.owner.equals(profile);
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Nullable
    public ServerPlayerEntity getOwnerPlayer() {
        return FTBTUtils.getPlayerByUUID(this.manager.server, this.owner);
    }

    @Deprecated
    public int join(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        Team oldTeam = this.manager.getPlayerTeam(player);
        if (!oldTeam.getType().isPlayer()) {
            throw TeamArgument.ALREADY_IN_PARTY.create();
        }
        UUID id = player.func_110124_au();
        ((PlayerTeam)oldTeam).actualTeam = this;
        this.ranks.put(id, TeamRank.MEMBER);
        this.sendMessage(Util.field_240973_b_, (ITextComponent)new StringTextComponent("").func_230529_a_(player.func_200200_C_()).func_240702_b_(" joined your party!").func_240699_a_(TextFormatting.GREEN));
        this.save();
        oldTeam.ranks.remove(id);
        oldTeam.save();
        ((PlayerTeam)oldTeam).updatePresence();
        this.manager.syncAll();
        this.changedTeam(oldTeam, id, player, false);
        return 1;
    }

    @Deprecated
    public int invite(ServerPlayerEntity from, Collection<GameProfile> players) throws CommandSyntaxException {
        for (GameProfile player : players) {
            if (this.isMember(player.getId())) continue;
            this.ranks.put(player.getId(), TeamRank.INVITED);
            this.save();
            this.sendMessage(from.func_110124_au(), (ITextComponent)new StringTextComponent("Invited " + player.getName()).func_240699_a_(TextFormatting.GREEN));
            ServerPlayerEntity p = FTBTUtils.getPlayerByUUID(this.manager.getServer(), player.getId());
            if (p == null) continue;
            p.func_145747_a((ITextComponent)new StringTextComponent("").func_240702_b_(player.getName()).func_240702_b_(" has invited you to join their party!"), Util.field_240973_b_);
            IFormattableTextComponent acceptButton = new StringTextComponent("Accept \u2714").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftbteams party join " + this.getStringID())));
            IFormattableTextComponent denyButton = new StringTextComponent("Deny \u2718").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftbteams party deny_invite " + this.getStringID())));
            p.func_145747_a((ITextComponent)new StringTextComponent("[").func_230529_a_((ITextComponent)acceptButton).func_240702_b_("] [").func_230529_a_((ITextComponent)denyButton).func_240702_b_("]"), Util.field_240973_b_);
        }
        return 1;
    }

    @Deprecated
    public int kick(ServerPlayerEntity from, Collection<GameProfile> players) throws CommandSyntaxException {
        for (GameProfile player : players) {
            UUID id = player.getId();
            Team oldTeam = this.manager.getPlayerTeam(id);
            if (oldTeam != this) {
                throw TeamArgument.NOT_IN_PARTY.create();
            }
            if (this.isOwner(id)) {
                throw TeamArgument.CANT_KICK_OWNER.create();
            }
            PlayerTeam team = this.manager.getInternalPlayerTeam(id);
            team.actualTeam = team;
            ServerPlayerEntity playerEntity = FTBTUtils.getPlayerByUUID(this.manager.getServer(), id);
            team.ranks.put(id, TeamRank.OWNER);
            this.sendMessage(from.func_110124_au(), (ITextComponent)new StringTextComponent("Kicked ").func_230529_a_(this.manager.getName(id)).func_240702_b_(" from ").func_230529_a_(this.getName()).func_240699_a_(TextFormatting.RED));
            team.save();
            this.ranks.remove(id);
            this.save();
            team.updatePresence();
            this.manager.syncAll();
            if (playerEntity != null) {
                playerEntity.func_146105_b((ITextComponent)new StringTextComponent("You have been kicked from ").func_230529_a_(this.getName()).func_240702_b_("!"), false);
                this.updateCommands(playerEntity);
            }
            team.changedTeam(this, id, playerEntity, false);
        }
        return 1;
    }

    @Deprecated
    public int transferOwnership(ServerPlayerEntity from, ServerPlayerEntity to) throws CommandSyntaxException {
        if (!this.getOnlineMembers().contains(to)) {
            throw TeamArgument.NOT_MEMBER.create((Object)to.func_145748_c_(), (Object)this.getName());
        }
        if (from == to) {
            from.func_145747_a((ITextComponent)new StringTextComponent("What."), Util.field_240973_b_);
            return 0;
        }
        this.ranks.put(this.owner, TeamRank.OFFICER);
        this.owner = to.func_110124_au();
        this.ranks.put(this.owner, TeamRank.OWNER);
        this.save();
        ((Consumer)TeamEvent.OWNERSHIP_TRANSFERRED.invoker()).accept(new PlayerTransferredTeamOwnershipEvent(this, from, to));
        this.sendMessage(from.func_110124_au(), (ITextComponent)new StringTextComponent("Transferred ownership to ").func_230529_a_(to.func_145748_c_()).func_240699_a_(TextFormatting.RED));
        this.updateCommands(from);
        this.updateCommands(to);
        this.manager.syncAll();
        return 1;
    }

    @Deprecated
    public int leave(ServerPlayerEntity player) throws CommandSyntaxException {
        UUID id = player.func_110124_au();
        if (this.isOwner(id) && this.getMembers().size() > 1) {
            throw TeamArgument.OWNER_CANT_LEAVE.create();
        }
        PlayerTeam team = this.manager.getInternalPlayerTeam(id);
        team.actualTeam = team;
        team.ranks.put(id, TeamRank.OWNER);
        this.sendMessage(Util.field_240973_b_, (ITextComponent)new StringTextComponent("").func_230529_a_(player.func_200200_C_()).func_240702_b_(" left your party!").func_240699_a_(TextFormatting.YELLOW));
        team.save();
        this.ranks.remove(id);
        this.manager.save();
        boolean deleted = false;
        if (this.getMembers().isEmpty()) {
            deleted = true;
            this.manager.saveNow();
            this.manager.teamMap.remove(this.getId());
            String fn = this.getId() + ".snbt";
            try {
                Path dir = this.manager.server.func_240776_a_(TeamManager.FOLDER_NAME).resolve("deleted");
                if (Files.notExists(dir, new LinkOption[0])) {
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
                Files.move(this.manager.server.func_240776_a_(TeamManager.FOLDER_NAME).resolve("party/" + fn), dir.resolve(fn), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    Files.deleteIfExists(this.manager.server.func_240776_a_(TeamManager.FOLDER_NAME).resolve("party/" + fn));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        team.updatePresence();
        this.manager.syncAll();
        team.changedTeam(this, id, player, deleted);
        return 1;
    }

    @Deprecated
    public int addAlly(CommandSource source, Collection<GameProfile> players) throws CommandSyntaxException {
        UUID from = source.func_197022_f() == null ? Util.field_240973_b_ : source.func_197022_f().func_110124_au();
        boolean changed = false;
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (this.isAlly(id)) continue;
            this.ranks.put(id, TeamRank.ALLY);
            this.sendMessage(from, (ITextComponent)new StringTextComponent("").func_240702_b_(player.getName()).func_240702_b_(" added as ally!").func_240699_a_(TextFormatting.YELLOW));
            changed = true;
        }
        if (changed) {
            this.save();
            this.manager.syncAll();
            return 1;
        }
        return 0;
    }

    @Deprecated
    public int removeAlly(CommandSource source, Collection<GameProfile> players) throws CommandSyntaxException {
        UUID from = source.func_197022_f() == null ? Util.field_240973_b_ : source.func_197022_f().func_110124_au();
        boolean changed = false;
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (!this.isAlly(id) || this.isMember(id)) continue;
            this.ranks.remove(id);
            this.sendMessage(from, (ITextComponent)new StringTextComponent("").func_240702_b_(player.getName()).func_240702_b_(" removed from allies!").func_240699_a_(TextFormatting.YELLOW));
            changed = true;
        }
        if (changed) {
            this.save();
            this.manager.syncAll();
            return 1;
        }
        return 0;
    }

    @Deprecated
    public int listAllies(CommandSource source) throws CommandSyntaxException {
        source.func_197030_a((ITextComponent)new StringTextComponent("Allies:"), false);
        boolean any = false;
        for (Map.Entry<UUID, TeamRank> entry : this.getRanked(TeamRank.ALLY).entrySet()) {
            if (entry.getValue().is(TeamRank.MEMBER)) continue;
            source.func_197030_a(this.manager.getName(entry.getKey()), false);
            any = true;
        }
        if (!any) {
            source.func_197030_a((ITextComponent)new StringTextComponent("None"), false);
        }
        return 1;
    }
}

