/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class KnownClientPlayer
implements Comparable<KnownClientPlayer> {
    public final UUID uuid;
    public String name;
    public boolean online;
    public UUID teamId;
    private GameProfile profile;
    private CompoundNBT extraData;

    public KnownClientPlayer(PlayerTeam pt) {
        this.uuid = pt.getId();
        this.name = pt.playerName;
        this.online = pt.online;
        this.teamId = pt.actualTeam.getId();
        this.extraData = pt.getExtraData();
    }

    public KnownClientPlayer(PacketBuffer buf) {
        this.uuid = buf.func_179253_g();
        this.name = buf.func_150789_c(Short.MAX_VALUE);
        this.online = buf.readBoolean();
        this.teamId = buf.func_179253_g();
        this.extraData = buf.func_244273_m();
    }

    public void update(KnownClientPlayer p) {
        this.name = p.name;
        this.online = p.online;
        this.teamId = p.teamId;
        this.profile = null;
        this.extraData = p.extraData;
    }

    public GameProfile getProfile() {
        if (this.profile == null) {
            this.profile = new GameProfile(this.uuid, this.name);
        }
        return this.profile;
    }

    public void write(PacketBuffer buf) {
        buf.func_179252_a(this.uuid);
        buf.func_211400_a(this.name, Short.MAX_VALUE);
        buf.writeBoolean(this.online);
        buf.func_179252_a(this.teamId);
        buf.func_150786_a(this.extraData);
    }

    public boolean isInternalTeam() {
        return this.teamId.equals(this.uuid);
    }

    public boolean isValid() {
        return this.online && this.isInternalTeam();
    }

    public CompoundNBT getExtraData() {
        return this.extraData;
    }

    @Override
    public int compareTo(KnownClientPlayer o) {
        int i = Boolean.compare(o.isValid(), this.isValid());
        return i == 0 ? this.name.compareToIgnoreCase(o.name) : i;
    }
}

