/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.ISingleLongValueTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class XPTask
extends Task
implements ISingleLongValueTask {
    public long value = 1L;
    public boolean points = false;

    public XPTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.XP;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public String formatMaxProgress() {
        return Long.toUnsignedString(this.points && this.value <= Integer.MAX_VALUE ? (long)XPTask.getLevelForExperience((int)this.value) : this.value);
    }

    @Override
    public String formatProgress(TeamData teamData, long progress) {
        return Long.toUnsignedString(this.points && this.value <= Integer.MAX_VALUE ? (long)XPTask.getLevelForExperience((int)progress) : progress);
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74772_a("value", this.value);
        nbt.func_74757_a("points", this.points);
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.value = nbt.func_74763_f("value");
        this.points = nbt.func_74767_n("points");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_179254_b(this.value);
        buffer.writeBoolean(this.points);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.value = buffer.func_179260_f();
        this.points = buffer.readBoolean();
    }

    @Override
    public void setValue(long v) {
        this.value = v;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 1L, 1L, Long.MAX_VALUE);
        config.addBool("points", this.points, v -> {
            this.points = v;
        }, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("ftbquests.reward.ftbquests.xp_levels").func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent(this.formatMaxProgress()).func_240699_a_(TextFormatting.RED));
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    public static int getPlayerXP(PlayerEntity player) {
        return (int)((float)XPTask.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(PlayerEntity player, int amount) {
        int experience;
        player.field_71067_cb = experience = XPTask.getPlayerXP(player) + amount;
        player.field_71068_ca = XPTask.getLevelForExperience(experience);
        int expForLevel = XPTask.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return XPTask.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + XPTask.sum(level - 15, 37, 5);
        }
        return 1395 + XPTask.sum(level - 30, 112, 9);
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = XPTask.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    @Override
    public void submitTask(TeamData teamData, ServerPlayerEntity player, ItemStack craftedItem) {
        int add = (int)Math.min(this.points ? (long)XPTask.getPlayerXP((PlayerEntity)player) : (long)player.field_71068_ca, Math.min(this.value - teamData.getProgress(this), Integer.MAX_VALUE));
        if (add <= 0) {
            return;
        }
        if (this.points) {
            XPTask.addPlayerXP((PlayerEntity)player, -add);
            player.func_82242_a(0);
        } else {
            player.func_82242_a(-add);
        }
        teamData.addProgress(this, add);
    }
}

