/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.integration.StageHelper;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StageReward
extends Reward {
    public String stage = "";
    public boolean remove = false;

    public StageReward(Quest quest) {
        super(quest);
        this.autoclaim = RewardAutoClaim.INVISIBLE;
    }

    @Override
    public RewardType getType() {
        return RewardTypes.STAGE;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("stage", this.stage);
        if (this.remove) {
            nbt.func_74757_a("remove", true);
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.stage = nbt.func_74779_i("stage");
        this.remove = nbt.func_74767_n("remove");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_211400_a(this.stage, Short.MAX_VALUE);
        buffer.writeBoolean(this.remove);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.stage = buffer.func_150789_c(Short.MAX_VALUE);
        this.remove = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("stage", this.stage, v -> {
            this.stage = v;
        }, "").setNameKey("ftbquests.reward.ftbquests.gamestage");
        config.addBool("remove", this.remove, v -> {
            this.remove = v;
        }, false);
    }

    @Override
    public void claim(ServerPlayerEntity player, boolean notify) {
        if (this.remove) {
            ((StageHelper)StageHelper.instance.func_179281_c()).remove(player, this.stage);
        } else {
            ((StageHelper)StageHelper.instance.func_179281_c()).add(player, this.stage);
        }
        if (notify) {
            if (this.remove) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("commands.gamestage.remove.target", new Object[]{this.stage}), Util.field_240973_b_);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("commands.gamestage.add.target", new Object[]{this.stage}), Util.field_240973_b_);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("ftbquests.reward.ftbquests.gamestage").func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent(this.stage).func_240699_a_(TextFormatting.YELLOW));
    }
}

