/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.gui.SelectQuestObjectScreen;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.reward.RandomReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.architectury.core.RegistryEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public final class RewardType
extends RegistryEntry<RewardType> {
    public final ResourceLocation id;
    public final Provider provider;
    private final Supplier<Icon> icon;
    private ITextComponent displayName;
    private GuiProvider guiProvider;
    private boolean excludeFromListRewards;
    public int intId;

    @Nullable
    public static Reward createReward(Quest quest, String id) {
        if (id.isEmpty()) {
            id = "ftbquests:item";
        } else if (id.indexOf(58) == -1) {
            id = "ftbquests:" + id;
        }
        RewardType type = RewardTypes.TYPES.get(new ResourceLocation(id));
        if (type == null) {
            return null;
        }
        return type.provider.create(quest);
    }

    public RewardType(ResourceLocation i, Provider p, Supplier<Icon> ic) {
        this.id = i;
        this.provider = p;
        this.icon = ic;
        this.displayName = null;
        this.guiProvider = new GuiProvider(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void openCreationGui(Runnable gui, Quest quest, Consumer<Reward> callback) {
                Reward reward = RewardType.this.provider.create(quest);
                if (reward instanceof RandomReward) {
                    ConfigQuestObject config = new ConfigQuestObject(QuestObjectType.REWARD_TABLE);
                    new SelectQuestObjectScreen(config, accepted -> {
                        if (accepted) {
                            ((RandomReward)reward).table = (RewardTable)config.value;
                            callback.accept(reward);
                        }
                        gui.run();
                    }).openGui();
                    return;
                }
                ConfigGroup group = new ConfigGroup("ftbquests");
                reward.getConfig(reward.createSubGroup(group));
                group.savedCallback = accepted -> {
                    if (accepted) {
                        callback.accept(reward);
                    }
                    gui.run();
                };
                new EditConfigScreen(group).openGui();
            }
        };
    }

    public String getTypeForNBT() {
        return this.id.func_110624_b().equals("ftbquests") ? this.id.func_110623_a() : this.id.toString();
    }

    public RewardType setDisplayName(ITextComponent name) {
        this.displayName = name;
        return this;
    }

    public ITextComponent getDisplayName() {
        if (this.displayName == null) {
            this.displayName = new TranslationTextComponent("ftbquests.reward." + this.id.func_110624_b() + '.' + this.id.func_110623_a());
        }
        return this.displayName;
    }

    public Icon getIcon() {
        return this.icon.get();
    }

    public RewardType setGuiProvider(GuiProvider p) {
        this.guiProvider = p;
        return this;
    }

    public GuiProvider getGuiProvider() {
        return this.guiProvider;
    }

    public RewardType setExcludeFromListRewards(boolean v) {
        this.excludeFromListRewards = v;
        return this;
    }

    public boolean getExcludeFromListRewards() {
        return this.excludeFromListRewards;
    }

    public static interface GuiProvider {
        @OnlyIn(value=Dist.CLIENT)
        public void openCreationGui(Runnable var1, Quest var2, Consumer<Reward> var3);
    }

    @FunctionalInterface
    public static interface Provider {
        public Reward create(Quest var1);
    }
}

