/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class RandomReward
extends Reward {
    public RewardTable table = null;

    public RandomReward(Quest parent) {
        super(parent);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.RANDOM;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        if (this.getTable() != null) {
            nbt.func_74772_a("table_id", this.table.id);
            if (this.table.id == -1L) {
                SNBTCompoundTag tag = new SNBTCompoundTag();
                this.table.writeData((CompoundNBT)tag);
                nbt.func_218657_a("table_data", (INBT)tag);
            }
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.table = null;
        QuestFile file = this.getQuestFile();
        long id = nbt.func_74763_f("table_id");
        if (id != 0L) {
            this.table = file.getRewardTable(id);
        } else {
            int index;
            int n = index = nbt.func_74764_b("table") ? nbt.func_74762_e("table") : -1;
            if (index >= 0 && index < file.rewardTables.size()) {
                this.table = file.rewardTables.get(index);
            }
        }
        if (this.table == null && nbt.func_74764_b("table_data")) {
            this.table = new RewardTable(file);
            this.table.readData(nbt.func_74775_l("table_data"));
            this.table.id = -1L;
            this.table.title = "Internal";
        }
    }

    @Nullable
    public RewardTable getTable() {
        if (this.table != null && this.table.invalid) {
            this.table = null;
        }
        return this.table;
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        RewardTable table = this.getTable();
        buffer.writeLong(table == null ? 0L : table.id);
        if (table != null && table.id == -1L) {
            table.writeNetData(buffer);
        }
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        QuestFile file = this.getQuestFile();
        long t = buffer.readLong();
        if (t == -1L) {
            this.table = new RewardTable(file);
            this.table.readNetData(buffer);
            this.table.id = -1L;
            this.table.title = "Internal";
        } else {
            this.table = file.getRewardTable(t);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        ((ConfigQuestObject)config.add("table", new ConfigQuestObject(QuestObjectType.REWARD_TABLE), (Object)this.table, v -> {
            this.table = v;
        }, (Object)this.getTable())).setNameKey("ftbquests.reward_table");
    }

    @Override
    public void claim(ServerPlayerEntity player, boolean notify) {
        RewardTable table = this.getTable();
        if (table == null) {
            return;
        }
        for (WeightedReward reward : table.rewards) {
            if (reward.weight != 0) continue;
            reward.reward.claim(player, notify);
        }
        int totalWeight = table.getTotalWeight(false);
        if (totalWeight <= 0) {
            return;
        }
        int number = player.field_70170_p.field_73012_v.nextInt(totalWeight) + 1;
        int currentWeight = 0;
        for (WeightedReward reward : table.rewards) {
            if ((currentWeight += reward.weight) < number) continue;
            reward.reward.claim(player, notify);
            return;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getAltTitle() {
        return this.getTable() == null ? super.getAltTitle() : (this.getTable().useTitle ? this.getTable().getTitle() : super.getAltTitle());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        return this.getTable() == null ? super.getAltIcon() : this.getTable().getIcon();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list) {
        if (this.getTable() != null) {
            this.getTable().addMouseOverText(list, true, false);
        }
    }

    @Override
    public boolean getExcludeFromClaimAll() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Object getIngredient() {
        return this.getTable() != null && this.getTable().lootCrate != null ? this.getTable().lootCrate.createStack() : null;
    }

    @Override
    public boolean automatedClaimPre(TileEntity tileEntity, List<ItemStack> items, Random random, UUID playerId, @Nullable ServerPlayerEntity player) {
        return false;
    }

    @Override
    public void automatedClaimPost(TileEntity tileEntity, UUID playerId, @Nullable ServerPlayerEntity player) {
    }
}

