/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.loot;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.EditRewardTableScreen;
import dev.ftb.mods.ftbquests.gui.RewardTablesScreen;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.jei.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class RewardTable
extends QuestObjectBase {
    public final QuestFile file;
    public final List<WeightedReward> rewards;
    public final Quest fakeQuest;
    public int emptyWeight;
    public int lootSize;
    public boolean hideTooltip;
    public boolean useTitle;
    public LootCrate lootCrate;
    public ResourceLocation lootTableId;
    public String filename;

    public RewardTable(QuestFile f) {
        this.file = f;
        this.rewards = new ArrayList<WeightedReward>();
        this.fakeQuest = new Quest(new Chapter(this.file, f.defaultChapterGroup));
        this.emptyWeight = 0;
        this.lootSize = 1;
        this.hideTooltip = false;
        this.useTitle = false;
        this.lootCrate = null;
        this.lootTableId = null;
        this.filename = "";
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.REWARD_TABLE;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.file;
    }

    public int getTotalWeight(boolean includeEmpty) {
        int w = includeEmpty ? this.emptyWeight : 0;
        for (WeightedReward r : this.rewards) {
            w += r.weight;
        }
        return w;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        if (this.emptyWeight > 0) {
            nbt.func_74768_a("empty_weight", this.emptyWeight);
        }
        nbt.func_74768_a("loot_size", this.lootSize);
        if (this.hideTooltip) {
            nbt.func_74757_a("hide_tooltip", true);
        }
        if (this.useTitle) {
            nbt.func_74757_a("use_title", true);
        }
        ListNBT list = new ListNBT();
        for (WeightedReward reward : this.rewards) {
            SNBTCompoundTag nbt1 = new SNBTCompoundTag();
            reward.reward.writeData((CompoundNBT)nbt1);
            if (reward.reward.getType() != RewardTypes.ITEM) {
                nbt1.func_74778_a("type", reward.reward.getType().getTypeForNBT());
            } else if (nbt1.func_150299_b("item") == 8) {
                nbt1.singleLine();
            }
            if (reward.weight != 1) {
                nbt1.func_74768_a("weight", reward.weight);
            }
            list.add((Object)nbt1);
        }
        nbt.func_218657_a("rewards", (INBT)list);
        if (this.lootCrate != null) {
            CompoundNBT nbt1 = new CompoundNBT();
            this.lootCrate.writeData(nbt1);
            nbt.func_218657_a("loot_crate", (INBT)nbt1);
        }
        if (this.lootTableId != null) {
            nbt.func_74778_a("loot_table_id", this.lootTableId.toString());
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.emptyWeight = nbt.func_74762_e("empty_weight");
        this.lootSize = nbt.func_74762_e("loot_size");
        this.hideTooltip = nbt.func_74767_n("hide_tooltip");
        this.useTitle = nbt.func_74767_n("use_title");
        this.rewards.clear();
        ListNBT list = nbt.func_150295_c("rewards", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT nbt1 = list.func_150305_b(i);
            Reward reward = RewardType.createReward(this.fakeQuest, nbt1.func_74779_i("type"));
            if (reward == null) continue;
            reward.readData(nbt1);
            this.rewards.add(new WeightedReward(reward, nbt1.func_74764_b("weight") ? nbt1.func_74762_e("weight") : 1));
        }
        this.lootCrate = null;
        if (nbt.func_74764_b("loot_crate")) {
            this.lootCrate = new LootCrate(this);
            this.lootCrate.readData(nbt.func_74775_l("loot_crate"));
        }
        this.lootTableId = nbt.func_74764_b("loot_table_id") ? new ResourceLocation(nbt.func_74779_i("loot_table_id")) : null;
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_211400_a(this.filename, Short.MAX_VALUE);
        buffer.func_150787_b(this.emptyWeight);
        buffer.func_150787_b(this.lootSize);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (boolean)this.hideTooltip);
        flags = Bits.setFlag((int)flags, (int)2, (boolean)this.useTitle);
        flags = Bits.setFlag((int)flags, (int)4, (this.lootCrate != null ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (this.lootTableId != null ? 1 : 0) != 0);
        buffer.func_150787_b(flags);
        buffer.func_150787_b(this.rewards.size());
        for (WeightedReward reward : this.rewards) {
            buffer.func_150787_b(reward.reward.getType().intId);
            reward.reward.writeNetData(buffer);
            buffer.func_150787_b(reward.weight);
        }
        if (this.lootCrate != null) {
            this.lootCrate.writeNetData(buffer);
        }
        if (this.lootTableId != null) {
            buffer.func_192572_a(this.lootTableId);
        }
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.filename = buffer.func_150789_c(Short.MAX_VALUE);
        this.emptyWeight = buffer.func_150792_a();
        this.lootSize = buffer.func_150792_a();
        int flags = buffer.func_150792_a();
        this.hideTooltip = Bits.getFlag((int)flags, (int)1);
        this.useTitle = Bits.getFlag((int)flags, (int)2);
        boolean hasCrate = Bits.getFlag((int)flags, (int)4);
        boolean hasLootTableId = Bits.getFlag((int)flags, (int)8);
        this.rewards.clear();
        int s = buffer.func_150792_a();
        for (int i = 0; i < s; ++i) {
            RewardType type = (RewardType)((Object)this.file.rewardTypeIds.get(buffer.func_150792_a()));
            Reward reward = type.provider.create(this.fakeQuest);
            reward.readNetData(buffer);
            int w = buffer.func_150792_a();
            this.rewards.add(new WeightedReward(reward, w));
        }
        this.lootCrate = null;
        if (hasCrate) {
            this.lootCrate = new LootCrate(this);
            this.lootCrate.readNetData(buffer);
        }
        this.lootTableId = hasLootTableId ? buffer.func_192575_l() : null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("empty_weight", this.emptyWeight, v -> {
            this.emptyWeight = v;
        }, 0, 0, Integer.MAX_VALUE);
        config.addInt("loot_size", this.lootSize, v -> {
            this.lootSize = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addBool("hide_tooltip", this.hideTooltip, v -> {
            this.hideTooltip = v;
        }, false);
        config.addBool("use_title", this.useTitle, v -> {
            this.useTitle = v;
        }, false);
        if (this.lootCrate != null) {
            this.lootCrate.getConfig(config.getGroup("loot_crate").setNameKey("item.ftbquests.lootcrate.name"));
        }
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (WeightedReward reward : this.rewards) {
            reward.reward.clearCachedData();
        }
    }

    @Override
    public void deleteSelf() {
        this.file.rewardTables.remove(this);
        super.deleteSelf();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null && gui.isViewingQuest()) {
            gui.viewQuestPanel.refreshWidgets();
        } else {
            RewardTablesScreen gui1 = (RewardTablesScreen)((Object)ClientUtils.getCurrentGuiAs(RewardTablesScreen.class));
            if (gui1 != null) {
                gui1.refreshWidgets();
            }
        }
        this.file.updateLootCrates();
    }

    @Override
    public void editedFromGUIOnServer() {
        this.file.updateLootCrates();
    }

    @Override
    public void onCreated() {
        if (this.filename.isEmpty()) {
            String s;
            this.filename = s = RewardTable.titleToID(this.title).orElse(this.toString());
            Set existingNames = this.file.rewardTables.stream().map(rt -> rt.filename).collect(Collectors.toSet());
            int i = 2;
            while (existingNames.contains(this.filename)) {
                this.filename = s + "_" + i;
                ++i;
            }
        }
        this.file.rewardTables.add(this);
    }

    public String getFilename() {
        if (this.filename.isEmpty()) {
            this.filename = RewardTable.getCodeString(this);
        }
        return this.filename;
    }

    @Override
    public String getPath() {
        return "reward_tables/" + this.getFilename() + ".snbt";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getAltTitle() {
        if (this.rewards.size() == 1) {
            return this.rewards.get((int)0).reward.getTitle();
        }
        return new TranslationTextComponent("ftbquests.reward_table");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        if (this.lootCrate != null) {
            return ItemIcon.getItemIcon((ItemStack)this.lootCrate.createStack());
        }
        if (this.rewards.isEmpty()) {
            return Icons.DICE;
        }
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (WeightedReward reward : this.rewards) {
            icons.add(reward.reward.getIcon());
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onEditButtonClicked(Runnable gui) {
        new EditRewardTableScreen(this, () -> new EditObjectMessage(this).sendToServer()).openGui();
    }

    public void addMouseOverText(TooltipList list, boolean includeWeight, boolean includeEmpty) {
        List<WeightedReward> rewards1;
        if (this.hideTooltip) {
            return;
        }
        int totalWeight = this.getTotalWeight(includeEmpty);
        if (includeWeight && includeEmpty && this.emptyWeight > 0) {
            list.add((ITextComponent)new StringTextComponent("").func_240699_a_(TextFormatting.GRAY).func_240702_b_("- ").func_230529_a_((ITextComponent)new TranslationTextComponent("ftbquests.reward_table.nothing")).func_230529_a_((ITextComponent)new StringTextComponent(" [" + WeightedReward.chanceString(this.emptyWeight, totalWeight, true) + "]").func_240699_a_(TextFormatting.DARK_GRAY)));
        }
        if (this.rewards.size() > 1) {
            rewards1 = new ArrayList<WeightedReward>(this.rewards);
            rewards1.sort(null);
        } else {
            rewards1 = this.rewards;
        }
        for (int i = 0; i < rewards1.size(); ++i) {
            if (i == 10) {
                list.add((ITextComponent)new StringTextComponent("").func_240699_a_(TextFormatting.GRAY).func_240702_b_("- ").func_230529_a_((ITextComponent)new TranslationTextComponent("ftbquests.reward_table.and_more", new Object[]{rewards1.size() - 10})));
                return;
            }
            WeightedReward r = rewards1.get(i);
            if (includeWeight) {
                list.add((ITextComponent)new StringTextComponent("").func_240699_a_(TextFormatting.GRAY).func_240702_b_("- ").func_230529_a_(r.reward.getTitle()).func_230529_a_((ITextComponent)new StringTextComponent(" [" + WeightedReward.chanceString(r.weight, totalWeight) + "]").func_240699_a_(TextFormatting.DARK_GRAY)));
                continue;
            }
            list.add((ITextComponent)new StringTextComponent("").func_240699_a_(TextFormatting.GRAY).func_240702_b_("- ").func_230529_a_(r.reward.getTitle()));
        }
    }

    @Override
    public int refreshJEI() {
        return FTBQuestsJEIHelper.LOOTCRATES;
    }
}

