/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import dev.ftb.mods.ftbquests.util.NetUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ChapterImage
implements Movable {
    public Chapter chapter;
    public double x;
    public double y;
    public double width;
    public double height;
    public double rotation;
    public Icon image;
    public List<String> hover;
    public String click;
    public boolean dev;
    public boolean corner;
    public Quest dependency;

    public ChapterImage(Chapter c) {
        this.chapter = c;
        this.y = 0.0;
        this.x = 0.0;
        this.width = 1.0;
        this.height = 1.0;
        this.rotation = 0.0;
        this.image = Icon.getIcon((String)"minecraft:textures/gui/presets/isles.png");
        this.hover = new ArrayList<String>();
        this.click = "";
        this.dev = false;
        this.corner = false;
        this.dependency = null;
    }

    public void writeData(CompoundNBT nbt) {
        nbt.func_74780_a("x", this.x);
        nbt.func_74780_a("y", this.y);
        nbt.func_74780_a("width", this.width);
        nbt.func_74780_a("height", this.height);
        nbt.func_74780_a("rotation", this.rotation);
        nbt.func_74778_a("image", this.image.toString());
        ListNBT hoverTag = new ListNBT();
        for (String s : this.hover) {
            hoverTag.add((Object)StringNBT.func_229705_a_((String)s));
        }
        nbt.func_218657_a("hover", (INBT)hoverTag);
        nbt.func_74778_a("click", this.click);
        nbt.func_74757_a("dev", this.dev);
        nbt.func_74757_a("corner", this.corner);
        if (this.dependency != null) {
            nbt.func_74778_a("dependency", this.dependency.getCodeString());
        }
    }

    public void readData(CompoundNBT nbt) {
        this.x = nbt.func_74769_h("x");
        this.y = nbt.func_74769_h("y");
        this.width = nbt.func_74769_h("width");
        this.height = nbt.func_74769_h("height");
        this.rotation = nbt.func_74769_h("rotation");
        this.image = Icon.getIcon((String)nbt.func_74779_i("image"));
        this.hover.clear();
        ListNBT hoverTag = nbt.func_150295_c("hover", 8);
        for (int i = 0; i < hoverTag.size(); ++i) {
            this.hover.add(hoverTag.func_150307_f(i));
        }
        this.click = nbt.func_74779_i("click");
        this.dev = nbt.func_74767_n("dev");
        this.corner = nbt.func_74767_n("corner");
        this.dependency = nbt.func_74764_b("dependency") ? this.chapter.file.getQuest(this.chapter.file.getID(nbt.func_74781_a("dependency"))) : null;
    }

    public void writeNetData(PacketBuffer buffer) {
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.width);
        buffer.writeDouble(this.height);
        buffer.writeDouble(this.rotation);
        NetUtils.writeIcon(buffer, this.image);
        NetUtils.writeStrings(buffer, this.hover);
        buffer.func_211400_a(this.click, Short.MAX_VALUE);
        buffer.writeBoolean(this.dev);
        buffer.writeBoolean(this.corner);
        buffer.writeLong(this.dependency == null ? 0L : this.dependency.id);
    }

    public void readNetData(PacketBuffer buffer) {
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.width = buffer.readDouble();
        this.height = buffer.readDouble();
        this.rotation = buffer.readDouble();
        this.image = NetUtils.readIcon(buffer);
        NetUtils.readStrings(buffer, this.hover);
        this.click = buffer.func_150789_c(Short.MAX_VALUE);
        this.dev = buffer.readBoolean();
        this.corner = buffer.readBoolean();
        this.dependency = this.chapter.file.getQuest(buffer.readLong());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        config.addDouble("x", this.x, v -> {
            this.x = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("y", this.y, v -> {
            this.y = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("width", this.width, v -> {
            this.width = v;
        }, 1.0, 0.0, Double.POSITIVE_INFINITY);
        config.addDouble("height", this.height, v -> {
            this.height = v;
        }, 1.0, 0.0, Double.POSITIVE_INFINITY);
        config.addDouble("rotation", this.rotation, v -> {
            this.rotation = v;
        }, 0.0, -180.0, 180.0);
        config.add("image", (ConfigValue)new ImageConfig(), (Object)this.image.toString(), v -> {
            this.image = Icon.getIcon((String)v);
        }, (Object)"minecraft:textures/gui/presets/isles.png");
        config.addList("hover", this.hover, (ConfigValue)new StringConfig(), (Object)"");
        config.addString("click", this.click, v -> {
            this.click = v;
        }, "");
        config.addBool("dev", this.dev, v -> {
            this.dev = v;
        }, false);
        config.addBool("corner", this.corner, v -> {
            this.corner = v;
        }, false);
        Predicate<QuestObjectBase> depTypes = object -> object == null || object instanceof Quest;
        ((ConfigQuestObject)config.add("dependency", new ConfigQuestObject(depTypes), (Object)this.dependency, v -> {
            this.dependency = v;
        }, null)).setNameKey("ftbquests.dependency");
    }

    @Override
    public Chapter getChapter() {
        return this.chapter;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public String getShape() {
        return "square";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void move(Chapter to, double _x, double _y) {
        this.x = _x;
        this.y = _y;
        if (to != this.chapter) {
            this.chapter.images.remove(this);
            new EditObjectMessage(this.chapter).sendToServer();
            this.chapter = to;
            this.chapter.images.add(this);
        }
        new EditObjectMessage(this.chapter).sendToServer();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMoved(MatrixStack matrixStack) {
        matrixStack.func_227860_a_();
        if (this.corner) {
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)this.rotation));
            this.image.withColor(Color4I.WHITE.withAlpha(50)).draw(matrixStack, 0, 0, 1, 1);
        } else {
            matrixStack.func_227861_a_(0.5, 0.5, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)this.rotation));
            matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
            this.image.withColor(Color4I.WHITE.withAlpha(50)).draw(matrixStack, -1, -1, 2, 2);
        }
        matrixStack.func_227865_b_();
        QuestShape.get((String)this.getShape()).outline.withColor(Color4I.WHITE.withAlpha(30)).draw(matrixStack, 0, 0, 1, 1);
    }
}

