/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public abstract class SimpleTextButton
extends Button {
    public SimpleTextButton(Panel panel, class_2561 txt, Icon icon) {
        super(panel, txt, icon);
        this.setWidth(panel.getGui().getTheme().getStringWidth((class_5348)txt) + (this.hasIcon() ? 28 : 8));
        this.setHeight(20);
    }

    @Override
    public SimpleTextButton setTitle(class_2561 txt) {
        super.setTitle(txt);
        this.setWidth(this.getGui().getTheme().getStringWidth((class_5348)this.getTitle()) + (this.hasIcon() ? 28 : 8));
        return this;
    }

    public boolean renderTitleInCenter() {
        return false;
    }

    @Override
    public Optional<PositionedIngredient> getIngredientUnderMouse() {
        return PositionedIngredient.of(this.icon.getIngredient(), this);
    }

    public boolean hasIcon() {
        return !this.icon.isEmpty();
    }

    @Override
    public void addMouseOverText(TooltipList list) {
        if (this.getGui().getTheme().getStringWidth((class_5348)this.getTitle()) + (this.hasIcon() ? 28 : 8) > this.width) {
            list.add(this.getTitle());
        }
    }

    @Override
    public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        this.drawBackground(graphics, theme, x, y, w, h);
        int s = h >= 16 ? 16 : 8;
        int off = (h - s) / 2;
        class_2561 title = this.getTitle();
        int textX = x;
        int textY = y + (h - theme.getFontHeight() + 1) / 2;
        int sw = theme.getStringWidth((class_5348)title);
        int mw = w - (this.hasIcon() ? off + s : 0) - 6;
        if (sw > mw) {
            sw = mw;
            title = theme.trimStringToWidth((class_5348)title, mw);
        }
        textX = this.renderTitleInCenter() ? (textX += (mw - sw + 6) / 2) : (textX += 4);
        if (this.hasIcon()) {
            this.drawIcon(graphics, theme, x + off, y + off, s, s);
            textX += off + s;
        }
        theme.drawString(graphics, title, textX, textY, theme.getContentColor(this.getWidgetType()), 2);
    }
}

