/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class ScreenWrapper
extends class_437
implements IScreenWrapper {
    private final BaseScreen wrappedGui;
    private final TooltipList tooltipList = new TooltipList();

    public ScreenWrapper(BaseScreen g) {
        super(g.getTitle());
        this.wrappedGui = g;
    }

    public void method_25426() {
        super.method_25426();
        this.wrappedGui.initGui();
    }

    public boolean method_25421() {
        return this.wrappedGui.doesGuiPauseGame();
    }

    public boolean method_25402(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        if (button == MouseButton.BACK.id) {
            this.wrappedGui.onBack();
            return true;
        }
        return this.wrappedGui.mousePressed(MouseButton.get(button)) || super.method_25402(x, y, button);
    }

    public boolean method_25406(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        this.wrappedGui.mouseReleased(MouseButton.get(button));
        return super.method_25406(x, y, button);
    }

    public boolean method_25401(double x, double y, double scroll) {
        return this.wrappedGui.mouseScrolled(scroll) || super.method_25401(x, y, scroll);
    }

    public boolean method_25403(double x, double y, int button, double dragX, double dragY) {
        return this.wrappedGui.mouseDragged(button, dragX, dragY) || super.method_25403(x, y, button, dragX, dragY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        if (this.wrappedGui.keyPressed(key)) {
            return true;
        }
        if (key.backspace()) {
            this.wrappedGui.onBack();
            return true;
        }
        if (this.wrappedGui.onClosedByKey(key)) {
            this.wrappedGui.closeGui(true);
            return true;
        }
        if (Platform.isModLoaded((String)"jei")) {
            this.wrappedGui.getIngredientUnderMouse().ifPresent(underMouse -> this.handleIngredientKey(key, underMouse.ingredient()));
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        this.wrappedGui.keyReleased(key);
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char keyChar, int modifiers) {
        if (this.wrappedGui.charTyped(keyChar, new KeyModifiers(modifiers))) {
            return true;
        }
        return super.method_25400(keyChar, (int)keyChar);
    }

    private void handleIngredientKey(Key key, Object object) {
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.wrappedGui.updateGui(mouseX, mouseY, partialTicks);
        this.method_25420(graphics);
        GuiHelper.setupDrawing();
        int x = this.wrappedGui.getX();
        int y = this.wrappedGui.getY();
        int w = this.wrappedGui.width;
        int h = this.wrappedGui.height;
        Theme theme = this.wrappedGui.getTheme();
        this.wrappedGui.draw(graphics, theme, x, y, w, h);
        this.wrappedGui.drawForeground(graphics, theme, x, y, w, h);
        this.wrappedGui.getContextMenu().orElse(this.wrappedGui).addMouseOverText(this.tooltipList);
        if (!this.tooltipList.shouldRender()) {
            this.wrappedGui.getIngredientUnderMouse().ifPresent(underMouse -> {
                class_1799 stack;
                Object ingredient;
                if (underMouse.tooltip() && (ingredient = underMouse.ingredient()) instanceof class_1799 && !(stack = (class_1799)ingredient).method_7960()) {
                    graphics.method_51448().method_22903();
                    graphics.method_51448().method_46416(0.0f, 0.0f, (float)this.tooltipList.zOffsetItemTooltip);
                    graphics.method_51446(theme.getFont(), (class_1799)ingredient, mouseX, mouseY);
                    graphics.method_51448().method_22909();
                }
            });
        } else {
            this.tooltipList.render(graphics, mouseX, Math.max(mouseY, 18), this.wrappedGui.getScreen().method_4486(), this.wrappedGui.getScreen().method_4502(), theme.getFont());
        }
        this.tooltipList.reset();
    }

    public void method_25420(class_332 matrixStack) {
        if (this.wrappedGui.drawDefaultBackground(matrixStack)) {
            super.method_25420(matrixStack);
        }
    }

    public void method_25393() {
        super.method_25393();
        this.wrappedGui.tick();
    }

    @Override
    public BaseScreen getGui() {
        return this.wrappedGui;
    }

    public void method_25432() {
        this.wrappedGui.onClosed();
        super.method_25432();
    }
}

