/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.ui.ContextMenu;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.LoadingScreen;
import dev.ftb.mods.ftblibrary.util.BooleanConsumer;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1041;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_410;
import net.minecraft.class_437;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public abstract class BaseScreen
extends Panel {
    private final class_437 prevScreen;
    private int mouseX;
    private int mouseY;
    private float partialTicks;
    private boolean refreshWidgets;
    private class_1041 screen;
    private Panel contextMenu = null;
    private long lastClickTime = 0L;

    public BaseScreen() {
        super(null);
        this.setSize(176, 166);
        this.setOnlyRenderWidgetsInside(false);
        this.setOnlyInteractWithWidgetsInside(false);
        this.prevScreen = class_310.method_1551().field_1755;
    }

    @Override
    public final BaseScreen getGui() {
        return this;
    }

    @Override
    public void alignWidgets() {
    }

    public final void initGui() {
        this.screen = this.parent instanceof BaseScreen ? this.parent.getScreen() : class_310.method_1551().method_22683();
        if (this.onInit()) {
            super.refreshWidgets();
            this.alignWidgets();
            this.onPostInit();
        }
    }

    public Theme getTheme() {
        return Theme.DEFAULT;
    }

    @Override
    public int getX() {
        return (this.getScreen().method_4486() - this.width) / 2;
    }

    @Override
    public int getY() {
        return (this.getScreen().method_4502() - this.height) / 2;
    }

    @Override
    public void setScrollX(double scroll) {
    }

    @Override
    public void setScrollY(double scroll) {
    }

    @Override
    public double getScrollX() {
        return 0.0;
    }

    @Override
    public double getScrollY() {
        return 0.0;
    }

    public boolean onInit() {
        return true;
    }

    protected boolean setFullscreen() {
        return this.setSizeProportional(1.0f, 1.0f);
    }

    protected boolean setSizeProportional(float w, float h) {
        Validate.isTrue((w > 0.0f && w <= 1.0f && h > 0.0f && h <= 1.0f ? 1 : 0) != 0, (String)"width and height must be > 0 and <= 1", (Object[])new Object[0]);
        if (this.screen == null) {
            return false;
        }
        this.setWidth((int)((float)this.screen.method_4486() * w));
        this.setHeight((int)((float)this.screen.method_4502() * h));
        return true;
    }

    public void onPostInit() {
    }

    @Nullable
    public class_437 getPrevScreen() {
        if (this.prevScreen instanceof ScreenWrapper && ((ScreenWrapper)this.prevScreen).getGui() instanceof LoadingScreen) {
            return ((ScreenWrapper)this.prevScreen).getGui().getPrevScreen();
        }
        if (this.prevScreen instanceof class_408) {
            return null;
        }
        return this.prevScreen;
    }

    @Override
    public final void closeGui(boolean openPrevScreen) {
        double mx = class_310.method_1551().field_1729.method_1603();
        double my = class_310.method_1551().field_1729.method_1604();
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            mc.field_1724.method_7346();
            if (mc.field_1755 == null) {
                mc.method_15995(true);
            }
        }
        if (openPrevScreen && this.getPrevScreen() != null) {
            mc.method_1507(this.getPrevScreen());
            GLFW.glfwSetCursorPos((long)this.getScreen().method_4490(), (double)mx, (double)my);
        }
        this.onClosed();
    }

    public boolean onClosedByKey(Key key) {
        return key.escOrInventory();
    }

    public void onBack() {
        this.closeGui(true);
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    @Override
    public final void refreshWidgets() {
        this.refreshWidgets = true;
    }

    public final void updateGui(int mx, int my, float pt) {
        this.mouseX = mx;
        this.mouseY = my;
        this.partialTicks = pt;
        if (this.refreshWidgets) {
            super.refreshWidgets();
            this.refreshWidgets = false;
        }
        this.posX = this.getX();
        this.posY = this.getY();
        if (this.contextMenu != null) {
            if (this.contextMenu instanceof BaseScreen) {
                ((BaseScreen)this.contextMenu).updateGui(mx, my, pt);
            } else {
                this.contextMenu.updateMouseOver(this.mouseX, this.mouseY);
            }
        }
        this.updateMouseOver(this.mouseX, this.mouseY);
    }

    @Override
    public void updateMouseOver(int mouseX, int mouseY) {
        this.isMouseOver = this.checkMouseOver(mouseX, mouseY);
        this.setOffset(true);
        if (this.contextMenu != null) {
            this.contextMenu.updateMouseOver(mouseX, mouseY);
        } else {
            for (Widget widget : this.widgets) {
                widget.updateMouseOver(mouseX, mouseY);
            }
        }
        this.setOffset(false);
    }

    @Override
    public final void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        super.draw(graphics, theme, x, y, w, h);
    }

    public Optional<Panel> getContextMenu() {
        return Optional.ofNullable(this.contextMenu);
    }

    public void openContextMenu(@Nullable ContextMenu newContextMenu) {
        int px = 0;
        int py = 0;
        if (this.contextMenu != null) {
            px = this.contextMenu.posX;
            py = this.contextMenu.posY;
            this.contextMenu.onClosed();
            this.widgets.remove(this.contextMenu);
        }
        if (newContextMenu == null) {
            this.contextMenu = null;
            return;
        }
        int x = this.getX();
        int y = this.getY();
        if (this.contextMenu == null) {
            px = this.getMouseX() - x;
            py = this.getMouseY() - y;
        }
        this.contextMenu = newContextMenu;
        this.widgets.add(this.contextMenu);
        this.contextMenu.refreshWidgets();
        px = Math.min(px, this.screen.method_4486() - this.contextMenu.width - x) - 3;
        py = Math.min(py, this.screen.method_4502() - this.contextMenu.height - y) - 3;
        this.contextMenu.setPos(px, py);
        Panel panel = this.contextMenu;
        if (panel instanceof BaseScreen) {
            BaseScreen b = (BaseScreen)panel;
            b.initGui();
        }
    }

    public ContextMenu openContextMenu(@NotNull List<ContextMenuItem> menu) {
        ContextMenu contextMenu = new ContextMenu(this, menu);
        this.openContextMenu(contextMenu);
        return contextMenu;
    }

    @Override
    public void closeContextMenu() {
        this.openContextMenu((ContextMenu)null);
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.closeContextMenu();
        CursorType.set(null);
    }

    @Override
    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        theme.drawGui(graphics, x, y, w, h, WidgetType.NORMAL);
    }

    public boolean drawDefaultBackground(class_332 graphics) {
        return true;
    }

    public void drawForeground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (button == MouseButton.BACK) {
            this.closeGui(true);
            return true;
        }
        long now = System.currentTimeMillis();
        if (this.lastClickTime != 0L && now - this.lastClickTime <= 300L && this.mouseDoubleClicked(button)) {
            this.lastClickTime = 0L;
            return true;
        }
        this.lastClickTime = now;
        return super.mousePressed(button);
    }

    @Override
    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        if (GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)292) == 1 && key.is(66)) {
            Theme.renderDebugBoxes = !Theme.renderDebugBoxes;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldAddMouseOverText() {
        return this.contextMenu == null;
    }

    @Override
    public final void openGui() {
        this.openContextMenu((ContextMenu)null);
        class_310.method_1551().method_1507((class_437)new ScreenWrapper(this));
    }

    @Override
    public final class_1041 getScreen() {
        if (this.screen == null) {
            return this.parent.getScreen();
        }
        return this.screen;
    }

    @Override
    public final int getMouseX() {
        return this.mouseX;
    }

    @Override
    public final int getMouseY() {
        return this.mouseY;
    }

    @Override
    public final float getPartialTicks() {
        return this.partialTicks;
    }

    public boolean isMouseOver(int x, int y, int w, int h) {
        return this.getMouseX() >= x && this.getMouseY() >= y && this.getMouseX() < x + w && this.getMouseY() < y + h;
    }

    public boolean isMouseOver(Widget widget) {
        if (widget == this) {
            return this.isMouseOver(this.getX(), this.getY(), this.width, this.height);
        }
        if (this.isMouseOver(widget.getX(), widget.getY(), widget.width, widget.height)) {
            boolean offset = widget.parent.isOffset();
            widget.parent.setOffset(false);
            boolean b = this.isMouseOver(widget.parent);
            widget.parent.setOffset(offset);
            return b;
        }
        return false;
    }

    @Override
    public boolean handleClick(String scheme, String path) {
        return ClientUtils.handleClick(scheme, path);
    }

    public void openYesNoFull(class_2561 title, class_2561 desc, BooleanConsumer callback) {
        class_310.method_1551().method_1507((class_437)new class_410(result -> {
            this.openGui();
            callback.accept(result);
            this.refreshWidgets();
        }, title, desc));
    }

    public final void openYesNo(class_2561 title, class_2561 desc, Runnable callback) {
        this.openYesNoFull(title, desc, result -> {
            if (result) {
                callback.run();
            }
        });
    }

    public static class PositionedTextData {
        public final int posX;
        public final int posY;
        public final int width;
        public final int height;
        public final class_2558 clickEvent;
        public final class_2568 hoverEvent;
        public final String insertion;

        public PositionedTextData(int x, int y, int w, int h, class_2583 s) {
            this.posX = x;
            this.posY = y;
            this.width = w;
            this.height = h;
            this.clickEvent = s.method_10970();
            this.hoverEvent = s.method_10969();
            this.insertion = s.method_10955();
        }
    }
}

