/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt;

import dev.ftb.mods.ftblibrary.snbt.SNBTTagProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import org.jetbrains.annotations.Nullable;

public class SNBTCompoundTag
extends CompoundNBT {
    private HashMap<String, SNBTTagProperties> properties;
    boolean singleLine = false;

    public static SNBTCompoundTag of(@Nullable INBT tag) {
        if (tag instanceof SNBTCompoundTag) {
            return (SNBTCompoundTag)tag;
        }
        if (tag instanceof CompoundNBT) {
            SNBTCompoundTag tag1 = new SNBTCompoundTag();
            for (String s : ((CompoundNBT)tag).func_150296_c()) {
                tag1.func_218657_a(s, ((CompoundNBT)tag).func_74781_a(s));
            }
            return tag1;
        }
        return new SNBTCompoundTag();
    }

    public SNBTCompoundTag() {
        super(new LinkedHashMap());
    }

    SNBTTagProperties getOrCreateProperties(String key) {
        SNBTTagProperties p;
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if ((p = this.properties.get(key)) == null) {
            p = new SNBTTagProperties();
            this.properties.put(key, p);
        }
        return p;
    }

    SNBTTagProperties getProperties(String key) {
        SNBTTagProperties p;
        if (this.properties != null && (p = this.properties.get(key)) != null) {
            return p;
        }
        return SNBTTagProperties.DEFAULT;
    }

    public void comment(String key, String ... comment) {
        if (comment.length > 0) {
            this.comment(key, String.join((CharSequence)"\n", comment));
        }
    }

    public void comment(String key, String comment) {
        String s;
        String string = s = comment == null ? "" : comment.trim();
        if (!s.isEmpty()) {
            this.getOrCreateProperties((String)key).comment = comment;
        }
    }

    public String getComment(String key) {
        return this.getProperties((String)key).comment;
    }

    public void singleLine() {
        this.singleLine = true;
    }

    public void singleLine(String key) {
        this.getOrCreateProperties((String)key).singleLine = true;
    }

    public void func_74757_a(String key, boolean value) {
        this.getOrCreateProperties((String)key).valueType = value ? 2 : 1;
        super.func_74757_a(key, value);
    }

    public boolean isBoolean(String key) {
        int t = this.getProperties((String)key).valueType;
        return t == 2 || t == 1;
    }

    public SNBTCompoundTag getCompound(String string) {
        return SNBTCompoundTag.of(this.func_74781_a(string));
    }

    public void putNumber(String key, Number number) {
        if (number instanceof Double) {
            this.func_74780_a(key, number.doubleValue());
        } else if (number instanceof Float) {
            this.func_74776_a(key, number.floatValue());
        } else if (number instanceof Long) {
            this.func_74772_a(key, number.longValue());
        } else if (number instanceof Integer) {
            this.func_74768_a(key, number.intValue());
        } else if (number instanceof Short) {
            this.func_74777_a(key, number.shortValue());
        } else if (number instanceof Byte) {
            this.func_74774_a(key, number.byteValue());
        } else if (number.toString().contains(".")) {
            this.func_74780_a(key, number.doubleValue());
        } else {
            this.func_74768_a(key, number.intValue());
        }
    }

    public void putNull(String key) {
        this.func_218657_a(key, (INBT)EndNBT.field_229686_b_);
    }

    @Nullable
    public ListNBT getNullableList(String key, byte type) {
        INBT tag = this.func_74781_a(key);
        return tag instanceof ListNBT && (((ListNBT)tag).isEmpty() || type == 0 || ((ListNBT)tag).func_230528_d__() == type) ? (ListNBT)tag : null;
    }

    public <T extends INBT> List<T> getList(String key, Class<T> type) {
        INBT tag = this.func_74781_a(key);
        if (!(tag instanceof CollectionNBT)) {
            return Collections.emptyList();
        }
        CollectionNBT l = (CollectionNBT)tag;
        if (l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<INBT> list = new ArrayList<INBT>(l.size());
        for (INBT t : l) {
            if (!type.isAssignableFrom(t.getClass())) continue;
            list.add(t);
        }
        return list;
    }
}

