/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class TeleportPos {
    private final class_5321<class_1937> dimension;
    private final class_2338 pos;
    public final Float yRot;
    public final Float xRot;
    private final long time;

    public TeleportPos(class_5321<class_1937> d, class_2338 p) {
        this(d, p, null, null);
    }

    public TeleportPos(class_5321<class_1937> d, class_2338 p, Float yRot, Float xRot) {
        this.dimension = d;
        this.pos = p;
        this.yRot = yRot;
        this.xRot = xRot;
        this.time = System.currentTimeMillis();
    }

    public TeleportPos(class_1937 world, class_2338 p, Float yRot, Float xRot) {
        this((class_5321<class_1937>)world.method_27983(), p, yRot, xRot);
    }

    public TeleportPos(class_1297 entity) {
        this(entity.method_37908(), entity.method_24515(), Float.valueOf(entity.method_36454()), Float.valueOf(entity.method_36455()));
    }

    public TeleportPos(class_2487 tag) {
        this.dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(tag.method_10558("dim")));
        this.pos = new class_2338(tag.method_10550("x"), tag.method_10550("y"), tag.method_10550("z"));
        this.yRot = tag.method_10540("yRot") == 5 ? Float.valueOf(tag.method_10583("yRot")) : null;
        this.xRot = tag.method_10540("xRot") == 5 ? Float.valueOf(tag.method_10583("xRot")) : null;
        this.time = tag.method_10537("time");
    }

    public TeleportResult teleport(class_3222 player) {
        class_3218 level = player.field_13995.method_3847(this.dimension);
        if (level == null) {
            return TeleportResult.DIMENSION_NOT_FOUND;
        }
        int xpLevel = player.field_7520;
        float xrot = this.xRot == null ? player.method_36455() : this.xRot.floatValue();
        float yrot = this.yRot == null ? player.method_36454() : this.yRot.floatValue();
        player.method_14251(level, (double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 0.1, (double)this.pos.method_10260() + 0.5, yrot, xrot);
        player.method_14252(xpLevel);
        return TeleportResult.SUCCESS;
    }

    public class_2487 write() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.singleLine();
        tag.method_10582("dim", this.dimension.method_29177().toString());
        tag.method_10569("x", this.pos.method_10263());
        tag.method_10569("y", this.pos.method_10264());
        tag.method_10569("z", this.pos.method_10260());
        tag.method_10544("time", this.time);
        if (this.xRot != null) {
            tag.method_10548("xRot", this.xRot.floatValue());
        }
        if (this.yRot != null) {
            tag.method_10548("yRot", this.yRot.floatValue());
        }
        return tag;
    }

    public String distanceString(TeleportPos origin) {
        if (origin.dimension == this.dimension) {
            double dx = this.pos.method_10263() - origin.pos.method_10263();
            double dz = this.pos.method_10260() - origin.pos.method_10260();
            return (int)Math.sqrt(dx * dx + dz * dz) + "m";
        }
        class_2960 s = this.dimension.method_29177();
        if (s.method_12836().equals("minecraft")) {
            return switch (s.method_12832()) {
                case "overworld" -> "Overworld";
                case "the_nether" -> "The Nether";
                case "the_end" -> "The End";
                default -> s.method_12832();
            };
        }
        return s.method_12832() + " [" + s.method_12836() + "]";
    }

    @FunctionalInterface
    public static interface TeleportResult {
        public static final TeleportResult SUCCESS = new TeleportResult(){

            @Override
            public int runCommand(class_3222 player) {
                return 1;
            }

            @Override
            public boolean isSuccess() {
                return true;
            }
        };
        public static final TeleportResult DIMENSION_NOT_FOUND = TeleportResult.failed((class_2561)class_2561.method_43470((String)"Dimension not found!"));
        public static final TeleportResult UNKNOWN_DESTINATION = TeleportResult.failed((class_2561)class_2561.method_43470((String)"Unknown destination!"));

        public static TeleportResult failed(class_2561 msg) {
            return player -> {
                player.method_7353(msg, false);
                return 0;
            };
        }

        public int runCommand(class_3222 var1);

        default public boolean isSuccess() {
            return false;
        }
    }

    @FunctionalInterface
    public static interface CooldownTeleportResult
    extends TeleportResult {
        public long getCooldown();

        @Override
        default public int runCommand(class_3222 player) {
            String secStr = TimeUtils.prettyTimeString((long)(this.getCooldown() / 1000L));
            player.method_7353((class_2561)class_2561.method_43470((String)("Can't teleport yet! Cooldown: " + secStr)), false);
            return 0;
        }
    }
}

