/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import dev.ftb.mods.ftbessentials.util.WarmupCooldownTeleporter;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public abstract class SavedTeleportManager {
    private final Map<String, TeleportPos> destinations = new HashMap<String, TeleportPos>();

    public void addDestination(String name, TeleportPos dest, class_3222 player) {
        String nameLower = name.toLowerCase();
        if (this.destinations.size() >= this.getMaxSize(player) && !this.destinations.containsKey(nameLower)) {
            throw new TooManyDestinationsException();
        }
        this.destinations.put(nameLower, dest);
        this.onChanged();
    }

    public boolean deleteDestination(String name) {
        if (this.destinations.remove(name.toLowerCase()) != null) {
            this.onChanged();
            return true;
        }
        return false;
    }

    public TeleportPos.TeleportResult teleportTo(String name, class_3222 player, WarmupCooldownTeleporter teleporter) {
        TeleportPos pos = this.destinations.get(name.toLowerCase());
        return pos != null ? teleporter.teleport(player, p -> pos) : TeleportPos.TeleportResult.UNKNOWN_DESTINATION;
    }

    public Stream<DestinationEntry> destinations() {
        return this.destinations.entrySet().stream().map(e -> new DestinationEntry((String)e.getKey(), (TeleportPos)e.getValue()));
    }

    public class_2487 writeNBT() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        this.destinations.forEach((name, dest) -> tag.method_10566(name, (class_2520)dest.write()));
        return tag;
    }

    public void readNBT(class_2487 tag) {
        this.destinations.clear();
        for (String key : tag.method_10541()) {
            this.destinations.put(key, new TeleportPos(tag.method_10562(key)));
        }
    }

    public Set<String> getNames() {
        return this.destinations.keySet();
    }

    protected int getMaxSize(class_3222 player) {
        return Integer.MAX_VALUE;
    }

    protected abstract void onChanged();

    public static class TooManyDestinationsException
    extends RuntimeException {
    }

    public record DestinationEntry(String name, TeleportPos destination) {
    }

    public static class WarpManager
    extends SavedTeleportManager {
        private final FTBEWorldData worldData;

        public WarpManager(FTBEWorldData worldData) {
            this.worldData = worldData;
        }

        @Override
        protected void onChanged() {
            this.worldData.markDirty();
        }
    }

    public static class HomeManager
    extends SavedTeleportManager {
        private final FTBEPlayerData playerData;

        public HomeManager(FTBEPlayerData playerData) {
            this.playerData = playerData;
        }

        @Override
        protected int getMaxSize(class_3222 player) {
            return FTBEConfig.MAX_HOMES.get(player);
        }

        @Override
        protected void onChanged() {
            this.playerData.markDirty();
        }
    }
}

