/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftbessentials.FTBEssentials;
import dev.ftb.mods.ftbessentials.kit.KitManager;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.SavedTeleportManager;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class FTBEWorldData {
    private static final class_5218 FTBESSENTIALS_DIRECTORY = new class_5218("ftbessentials");
    private static final String DATA_FILE = "data.snbt";
    public static FTBEWorldData instance;
    private final MinecraftServer server;
    private boolean needSave;
    private final SavedTeleportManager.WarpManager warpManager;
    private final Map<UUID, Long> muteTimeouts;

    public FTBEWorldData(MinecraftServer s) {
        this.server = s;
        this.warpManager = new SavedTeleportManager.WarpManager(this);
        this.muteTimeouts = new HashMap<UUID, Long>();
    }

    public SavedTeleportManager.WarpManager warpManager() {
        return this.warpManager;
    }

    public Path mkdirs(String path) {
        Path dir = this.server.method_27050(FTBESSENTIALS_DIRECTORY);
        if (!path.isEmpty()) {
            dir = dir.resolve(path);
        }
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not create FTB Essentials data directory: " + ex);
            }
        }
        return dir;
    }

    public void markDirty() {
        this.needSave = true;
    }

    public void saveIfChanged() {
        if (this.needSave && SNBT.write((Path)this.mkdirs("").resolve(DATA_FILE), (class_2487)this.toNBT())) {
            this.needSave = false;
        }
    }

    public void load() {
        try {
            SNBTCompoundTag tag = SNBT.read((Path)this.mkdirs("").resolve(DATA_FILE));
            if (tag != null) {
                this.loadNBT(tag);
            }
        }
        catch (Exception ex) {
            FTBEssentials.LOGGER.error("Failed to load world data: " + ex);
            ex.printStackTrace();
        }
    }

    private SNBTCompoundTag toNBT() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.method_10566("warps", (class_2520)this.warpManager.writeNBT());
        SNBTCompoundTag mutesTag = new SNBTCompoundTag();
        this.muteTimeouts.forEach((id, until) -> mutesTag.method_10544(id.toString(), until.longValue()));
        tag.method_10566("mute_timeouts", (class_2520)mutesTag);
        tag.method_10566("kits", (class_2520)KitManager.getInstance().save());
        return tag;
    }

    public void loadNBT(SNBTCompoundTag tag) {
        this.warpManager.readNBT((class_2487)tag.getCompound("warps"));
        this.muteTimeouts.clear();
        SNBTCompoundTag mutesTag = tag.getCompound("mute_timeouts");
        for (String key : mutesTag.method_10541()) {
            this.muteTimeouts.put(UUID.fromString(key), mutesTag.method_10537(key));
        }
        KitManager.getInstance().load((class_2487)tag.getCompound("kits"));
    }

    public void tickMuteTimeouts(MinecraftServer server) {
        long now = System.currentTimeMillis();
        HashSet toExpire = new HashSet();
        this.muteTimeouts.forEach((id, expiry) -> {
            if (now >= expiry) {
                toExpire.add(id);
            }
        });
        toExpire.forEach(id -> {
            class_3222 player = server.method_3760().method_14602(id);
            if (player != null) {
                player.method_7353((class_2561)player.method_5476().method_27661().method_27693(" is no longer muted"), false);
            }
            FTBEPlayerData.getOrCreate(new GameProfile(id, "")).ifPresent(data -> {
                data.setMuted(false);
                if (player == null) {
                    data.saveIfChanged();
                }
                FTBEssentials.LOGGER.info("auto-unmuted {} - timeout expired", id);
            });
            this.muteTimeouts.remove(id);
            this.markDirty();
        });
    }

    public void setMuteTimeout(class_3222 player, long until) {
        if (until > 0L) {
            this.muteTimeouts.put(player.method_5667(), until);
        } else {
            this.muteTimeouts.remove(player.method_5667());
        }
        this.markDirty();
    }

    public Optional<Long> getMuteTimeout(class_3222 player) {
        return Optional.ofNullable(this.muteTimeouts.get(player.method_5667()));
    }
}

