/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.kit;

import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public class Kit {
    private final String kitName;
    private final List<class_1799> items;
    private final long cooldown;
    private final boolean autoGrant;

    public Kit(String kitName, Collection<class_1799> items, long cooldown, boolean autoGrant) {
        this.kitName = kitName;
        this.items = List.copyOf(items);
        this.cooldown = cooldown;
        this.autoGrant = autoGrant;
    }

    public static Kit deepCopy(String kitName, Collection<class_1799> items, long cooldownSecs, boolean autoGrant) {
        return new Kit(kitName, items.stream().map(class_1799::method_7972).toList(), cooldownSecs, autoGrant);
    }

    public String getKitName() {
        return this.kitName;
    }

    public List<class_1799> getItems() {
        return this.items;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public boolean isAutoGrant() {
        return this.autoGrant;
    }

    public class_2487 toNBT() {
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();
        this.items.forEach(stack -> list.add((Object)this.saveStack((class_1799)stack)));
        tag.method_10566("items", (class_2520)list);
        tag.method_10544("cooldown", this.cooldown);
        if (this.autoGrant) {
            tag.method_10556("auto_grant", true);
        }
        return tag;
    }

    private SNBTCompoundTag saveStack(class_1799 stack) {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.singleLine();
        stack.method_7953((class_2487)tag);
        return tag;
    }

    public static Kit fromNBT(String kitName, class_2487 tag) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        class_2499 list = tag.method_10554("items", 10);
        list.forEach(el -> {
            if (el instanceof class_2487) {
                class_2487 c = (class_2487)el;
                items.add(class_1799.method_7915((class_2487)c));
            }
        });
        return new Kit(kitName, items, tag.method_10537("cooldown"), tag.method_10577("auto_grant"));
    }

    public void giveToPlayer(class_3222 player, FTBEPlayerData playerData, boolean throwOnCooldown) {
        long now = System.currentTimeMillis();
        if (!this.checkForCooldown(player, playerData, now, throwOnCooldown)) {
            this.items.forEach(stack -> {
                class_1542 itementity;
                class_1799 stack1 = stack.method_7972();
                if (!player.method_31548().method_7394(stack1) && (itementity = player.method_7328(stack1, false)) != null) {
                    itementity.method_6975();
                    itementity.method_48349(player.method_5667());
                }
            });
            if (this.cooldown != 0L) {
                playerData.setLastKitUseTime(this.kitName, now);
            }
        }
    }

    private boolean checkForCooldown(class_3222 player, FTBEPlayerData data, long now, boolean throwOnCooldown) {
        if (this.cooldown != 0L) {
            long lastUsed = data.getLastKitUseTime(this.kitName);
            if (this.cooldown < 0L && lastUsed != 0L) {
                if (throwOnCooldown) {
                    throw new IllegalStateException("Kit " + this.kitName + " is a one-time use kit (already given to " + player.method_7334().getName() + ")");
                }
                return true;
            }
            long delta = (now - lastUsed) / 1000L;
            if (delta < this.cooldown) {
                if (throwOnCooldown) {
                    long remaining = this.cooldown - delta;
                    throw new IllegalStateException("Kit " + this.kitName + " is on cooldown - " + TimeUtils.prettyTimeString((long)remaining) + " remaining");
                }
                return true;
            }
        }
        return false;
    }

    public Kit withCooldown(long newCooldown) {
        return new Kit(this.kitName, this.items, newCooldown, this.autoGrant);
    }

    public Kit withAutoGrant(boolean newAutoGrant) {
        return new Kit(this.kitName, this.items, this.cooldown, newAutoGrant);
    }
}

