/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;

public class CooldownTeleporter {
    public final FTBEPlayerData playerData;
    public final ToIntFunction<ServerPlayerEntity> cooldownConfig;
    public long cooldown;

    public CooldownTeleporter(FTBEPlayerData d, ToIntFunction<ServerPlayerEntity> c) {
        this.playerData = d;
        this.cooldownConfig = c;
        this.cooldown = 0L;
    }

    public TeleportPos.TeleportResult checkCooldown() {
        long now = System.currentTimeMillis();
        if (now < this.cooldown) {
            return () -> this.cooldown - now;
        }
        return TeleportPos.TeleportResult.SUCCESS;
    }

    public TeleportPos.TeleportResult teleport(ServerPlayerEntity player, Function<ServerPlayerEntity, TeleportPos> positionGetter) {
        TeleportPos.TeleportResult res0 = this.checkCooldown();
        if (!res0.isSuccess()) {
            return res0;
        }
        this.cooldown = System.currentTimeMillis() + Math.max(0L, (long)this.cooldownConfig.applyAsInt(player) * 1000L);
        TeleportPos p = positionGetter.apply(player);
        TeleportPos currentPos = new TeleportPos((Entity)player);
        res0 = p.teleport(player);
        if (!res0.isSuccess()) {
            return res0;
        }
        if (this != this.playerData.backTeleporter) {
            this.playerData.addTeleportHistory(player, currentPos);
        }
        return TeleportPos.TeleportResult.SUCCESS;
    }
}

