/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import com.google.common.primitives.Ints;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class SendChunkPacket
extends BaseS2CMessage {
    public final class_5321<class_1937> dimension;
    public final UUID teamId;
    public final SingleChunk chunk;

    public SendChunkPacket(class_5321<class_1937> dimension, UUID teamId, SingleChunk chunk) {
        this.dimension = dimension;
        this.teamId = teamId;
        this.chunk = chunk;
    }

    SendChunkPacket(class_2540 buf) {
        this.dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)buf.method_10810());
        this.teamId = buf.method_10790();
        this.chunk = new SingleChunk(buf, this.teamId);
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_CHUNK;
    }

    public void write(class_2540 buf) {
        buf.method_10812(this.dimension.method_29177());
        buf.method_10797(this.teamId);
        this.chunk.write(buf, this.teamId);
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunksClient.INSTANCE.updateChunksFromServer(this.dimension, this.teamId, List.of(this.chunk));
    }

    public static class SingleChunk {
        private final int x;
        private final int z;
        private final int relativeTimeClaimed;
        private final boolean forceLoaded;
        private final int relativeTimeForceLoaded;
        private final boolean expires;
        private final int relativeForceLoadExpiryTime;

        public SingleChunk(long now, int x, int z, @Nullable ClaimedChunk claimedChunk) {
            this.x = x;
            this.z = z;
            if (claimedChunk != null) {
                this.relativeTimeClaimed = SingleChunk.millisToSeconds(now - claimedChunk.getTimeClaimed());
                this.forceLoaded = claimedChunk.isForceLoaded();
                this.expires = claimedChunk.getForceLoadExpiryTime() > 0L;
                this.relativeTimeForceLoaded = this.forceLoaded ? SingleChunk.millisToSeconds(now - claimedChunk.getForceLoadedTime()) : 0;
                this.relativeForceLoadExpiryTime = this.expires ? SingleChunk.millisToSeconds(claimedChunk.getForceLoadExpiryTime() - now) : 0;
            } else {
                this.relativeForceLoadExpiryTime = 0;
                this.relativeTimeForceLoaded = 0;
                this.relativeTimeClaimed = 0;
                this.expires = false;
                this.forceLoaded = false;
            }
        }

        private static int millisToSeconds(long ms) {
            return Ints.saturatedCast((long)(ms / 1000L));
        }

        public int getX() {
            return this.x;
        }

        public int getZ() {
            return this.z;
        }

        public SingleChunk(class_2540 buf, UUID teamId) {
            this.x = buf.method_10816();
            this.z = buf.method_10816();
            if (!teamId.equals(class_156.field_25140)) {
                this.relativeTimeClaimed = buf.readInt();
                byte b = buf.readByte();
                this.forceLoaded = (b & 1) != 0;
                this.expires = (b & 2) != 0;
                this.relativeTimeForceLoaded = this.forceLoaded ? buf.readInt() : 0;
                this.relativeForceLoadExpiryTime = this.expires ? buf.readInt() : 0;
            } else {
                this.relativeForceLoadExpiryTime = 0;
                this.relativeTimeForceLoaded = 0;
                this.relativeTimeClaimed = 0;
                this.expires = false;
                this.forceLoaded = false;
            }
        }

        public void write(class_2540 buf, UUID teamId) {
            buf.method_10804(this.x);
            buf.method_10804(this.z);
            if (!teamId.equals(class_156.field_25140)) {
                byte b = 0;
                if (this.forceLoaded) {
                    b = (byte)(b | 1);
                }
                if (this.expires) {
                    b = (byte)(b | 2);
                }
                buf.writeInt(this.relativeTimeClaimed);
                buf.writeByte((int)b);
                if (this.forceLoaded) {
                    buf.writeInt(this.relativeTimeForceLoaded);
                }
                if (this.expires) {
                    buf.writeInt(this.relativeForceLoadExpiryTime);
                }
            }
        }

        public SingleChunk hidden() {
            return new SingleChunk(0L, this.x, this.z, null);
        }

        public MapChunk.DateInfo getDateInfo(boolean isClaimed, long now) {
            if (!isClaimed) {
                return MapChunk.NO_DATE_INFO;
            }
            Date claimed = new Date(now - (long)this.relativeTimeClaimed * 1000L);
            Date forceLoaded = this.forceLoaded ? new Date(now - (long)this.relativeTimeForceLoaded * 1000L) : null;
            Date expiry = this.forceLoaded && this.expires ? new Date(now + (long)this.relativeForceLoadExpiryTime * 1000L) : null;
            return new MapChunk.DateInfo(claimed, forceLoaded, expiry);
        }
    }
}

