/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.mapicon;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbchunks.api.client.icon.MapType;
import dev.ftb.mods.ftbchunks.api.client.icon.WaypointIcon;
import dev.ftb.mods.ftbchunks.client.gui.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.map.WaypointImpl;
import dev.ftb.mods.ftbchunks.client.mapicon.StaticMapIcon;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class WaypointMapIcon
extends StaticMapIcon
implements WaypointIcon {
    private final WaypointImpl waypoint;
    private Icon outsideIcon;
    private int alpha;

    public WaypointMapIcon(WaypointImpl waypoint) {
        super(waypoint.getPos());
        this.waypoint = waypoint;
        this.outsideIcon = Color4I.empty();
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    @Override
    public Color4I getColor() {
        return Color4I.rgb((int)this.waypoint.getColor());
    }

    @Override
    public boolean isVisible(MapType mapType, double distanceToPlayer, boolean outsideVisibleArea) {
        if (outsideVisibleArea || distanceToPlayer > this.waypoint.getDrawDistance(mapType.isMinimap())) {
            return false;
        }
        return !mapType.isWorldIcon() || distanceToPlayer >= 0.5;
    }

    @Override
    public boolean isIconOnEdge(MapType mapType, boolean outsideVisibleArea) {
        return !outsideVisibleArea;
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    @Override
    public void addTooltip(TooltipList list) {
        list.string(this.waypoint.getName());
        super.addTooltip(list);
    }

    @Override
    public boolean onMousePressed(BaseScreen screen, MouseButton button) {
        if (super.onMousePressed(screen, button)) {
            return true;
        }
        if (button.isRight() && screen instanceof LargeMapScreen) {
            LargeMapScreen lms = (LargeMapScreen)screen;
            this.openWPContextMenu(lms);
            return true;
        }
        return false;
    }

    private void openWPContextMenu(LargeMapScreen screen) {
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        contextMenu.add(this.makeTitleMenuItem());
        contextMenu.add(ContextMenuItem.SEPARATOR);
        contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.rename"), Icons.CHAT, () -> {
            StringConfig config = new StringConfig();
            config.setValue((Object)this.waypoint.getName());
            config.onClicked(MouseButton.LEFT, accepted -> {
                if (accepted) {
                    this.waypoint.setName((String)config.getValue());
                }
                screen.openGui();
            });
        }));
        if (this.waypoint.getType().canChangeColor()) {
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbchunks.gui.change_color"), Icons.COLOR_RGB, () -> {
                int r = this.waypoint.getColor() >> 16 & 0xFF;
                int g = this.waypoint.getColor() >> 8 & 0xFF;
                int b = this.waypoint.getColor() & 0xFF;
                float[] hsb = Color.RGBtoHSB(r, g, b, new float[3]);
                float add = Widget.isShiftKeyDown() ? -0.083333336f : 0.083333336f;
                Color4I col = Color4I.hsb((float)(hsb[0] + add), (float)hsb[1], (float)hsb[2]);
                this.waypoint.setColor(col.rgba());
                this.icon = Color4I.empty();
                this.outsideIcon = Color4I.empty();
                this.checkIcon();
            }).setCloseMenu(false));
        }
        contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)("ftbchunks.label." + (this.waypoint.isHidden() ? "show" : "hide"))), Icons.BEACON, () -> {
            this.waypoint.setHidden(!this.waypoint.isHidden());
            screen.refreshWidgets();
        }));
        contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.remove"), Icons.REMOVE, () -> {
            this.waypoint.removeFromManager();
            screen.refreshIcons();
        }));
        screen.openContextMenu(contextMenu);
    }

    private ContextMenuItem makeTitleMenuItem() {
        return new ContextMenuItem((class_2561)class_2561.method_43470((String)this.waypoint.getName()), this.icon, () -> {}){

            public Icon getIcon() {
                return WaypointMapIcon.this.icon;
            }
        };
    }

    @Override
    public boolean onKeyPressed(BaseScreen screen, Key key) {
        if (super.onKeyPressed(screen, key)) {
            return true;
        }
        if (key.is(261) && screen instanceof LargeMapScreen) {
            LargeMapScreen lms = (LargeMapScreen)screen;
            this.waypoint.removeFromManager();
            lms.refreshIcons();
            return true;
        }
        return false;
    }

    public void checkIcon() {
        if (this.icon.isEmpty() || this.outsideIcon.isEmpty()) {
            Color4I tint = Color4I.rgb((int)this.waypoint.getColor()).withAlpha(this.waypoint.isHidden() ? 130 : 255);
            this.icon = this.waypoint.getType().getIcon().withTint(tint);
            this.outsideIcon = this.waypoint.getType().getOutsideIcon().withTint(tint);
        }
    }

    @Override
    public void draw(MapType mapType, class_332 graphics, int x, int y, int w, int h, boolean outsideVisibleArea, int iconAlpha) {
        Icon toDraw;
        this.checkIcon();
        Icon icon = toDraw = outsideVisibleArea || mapType.isWorldIcon() ? this.outsideIcon : this.icon;
        if (iconAlpha < 255 && toDraw instanceof ImageIcon) {
            ImageIcon img = (ImageIcon)toDraw;
            img.withColor(img.color.withAlpha(iconAlpha)).draw(graphics, x, y, w, h);
        } else {
            toDraw.draw(graphics, x, y, w, h);
        }
        if (!outsideVisibleArea && mapType.isWorldIcon()) {
            class_310 mc = class_310.method_1551();
            String ds = class_3532.method_15384((double)MathUtils.dist((double)this.pos.field_1352, (double)this.pos.field_1351, (double)this.pos.field_1350, (double)mc.field_1724.method_23317(), (double)mc.field_1724.method_23318(), (double)mc.field_1724.method_23321())) + " m";
            int nw = mc.field_1772.method_1727(this.waypoint.getName());
            int dw = mc.field_1772.method_1727(ds);
            Color4I.DARK_GRAY.withAlpha(200).draw(graphics, x + (w - nw) / 2 - 2, y - 14, nw + 4, 12);
            Color4I.DARK_GRAY.withAlpha(200).draw(graphics, x + (w - dw) / 2 - 2, y + 18, dw + 4, 12);
            graphics.method_51433(mc.field_1772, this.waypoint.getName(), x + (w - nw) / 2, y - 12, -1, true);
            graphics.method_51433(mc.field_1772, ds, x + (w - dw) / 2, y + 20, -1, true);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
        }
    }
}

