/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.data.ClaimResult;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import me.shedaniel.architectury.hooks.TagHooks;
import net.minecraft.block.Block;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class FTBChunksAPI {
    public static final ITag<Block> EDIT_WHITELIST_TAG = TagHooks.getBlockOptional((ResourceLocation)new ResourceLocation("ftbchunks", "edit_whitelist"));
    public static final ITag<Block> INTERACT_WHITELIST_TAG = TagHooks.getBlockOptional((ResourceLocation)new ResourceLocation("ftbchunks", "interact_whitelist"));
    public static final ITag<Item> RIGHT_CLICK_BLACKLIST_TAG = TagHooks.getItemOptional((ResourceLocation)new ResourceLocation("ftbchunks", "right_click_blacklist"));
    public static final ITag<Item> RIGHT_CLICK_WHITELIST_TAG = TagHooks.getItemOptional((ResourceLocation)new ResourceLocation("ftbchunks", "right_click_whitelist"));
    public static ClaimedChunkManager manager;

    public static ClaimedChunkManager getManager() {
        if (manager == null) {
            throw new NullPointerException("FTB Chunks Manager hasn't been loaded yet!");
        }
        return manager;
    }

    public static boolean isManagerLoaded() {
        return manager != null;
    }

    public static ClaimResult claimAsPlayer(ServerPlayerEntity player, RegistryKey<World> dimension, ChunkPos pos, boolean checkOnly) {
        return FTBChunksAPI.getManager().getData(player).claim(player.func_195051_bN(), new ChunkDimPos(dimension, pos), checkOnly);
    }

    public static void syncPlayer(ServerPlayerEntity player) {
        SendGeneralDataPacket.send(FTBChunksAPI.getManager().getData(player), player);
    }
}

