/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.blocks.BlockStatesMap;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitsInitWithEnum;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class RelatedUnitsInit<T extends IRelatedUnit, E extends Enum<?>>
extends UnitsInitWithEnum<T, E> {
    protected final BlockStatesMap<T> allBlockStates = new BlockStatesMap();
    protected final Map<Item, T> allItems = new ConcurrentHashMap<Item, T>();
    protected final Map<Fluid, T> allFluids = new ConcurrentHashMap<Fluid, T>();

    public RelatedUnitsInit(ForgeMod mod, Class<E> builtIn) {
        super(mod, builtIn);
    }

    @Override
    public void onPostInit() {
        super.onPostInit();
        this.attachToStates();
    }

    protected void clearAttachedStates() {
        this.allBlockStates.clear();
        this.allItems.clear();
        this.allFluids.clear();
    }

    protected void attachToStates() {
        this.clearAttachedStates();
        for (IRelatedUnit unit : this.getAll()) {
            this.attachToBlockStates(unit);
            this.attachToItemStates(unit);
            this.attachToFluids(unit);
        }
    }

    protected void attachToBlockStates(T unit) {
        UnitId id = unit.getRelatedId();
        this.allBlockStates.put(id, unit);
    }

    protected void attachToItemStates(T unit) {
        UnitId id = unit.getRelatedId();
        Collection<Item> items = id.getAllMatchedItems();
        if (items != null) {
            items.forEach(item -> this.allItems.put((Item)item, unit));
        }
    }

    protected void attachToFluids(T unit) {
        UnitId id = unit.getRelatedId();
        Collection<Fluid> fluids = id.getAllMatchedFluids();
        if (fluids != null) {
            fluids.forEach(fluid -> this.allFluids.put((Fluid)fluid, unit));
        }
    }

    @Nullable
    public T findBy(ItemStack stack) {
        return this.findBy(stack.func_77973_b());
    }

    @Nullable
    public T findBy(Item item) {
        return (T)((IRelatedUnit)this.allItems.get(item));
    }

    @Nullable
    public T findBy(BlockState state) {
        return (T)((IRelatedUnit)this.allBlockStates.get(state));
    }

    @Nullable
    public T findBy(Fluid fluid) {
        return (T)((IRelatedUnit)this.allFluids.get(fluid));
    }
}

